/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import teamroots.embers.block.BlockVacuum;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;

public class TileEntityItemVacuum
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipeConnectable {
    Random random = new Random();

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockVacuum.facing);
        TileEntity tile = this.getWorld().getTileEntity(this.getPos().offset(facing.getOpposite()));
        if (!this.world.isRemote && this.world.isBlockPowered(this.getPos()) && tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            List nearestItems;
            IItemHandler inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            Vec3i vec = facing.getDirectionVec();
            AxisAlignedBB suckBB = new AxisAlignedBB((double)(this.getPos().getX() - 6 + vec.getX() * 6), (double)(this.getPos().getY() - 6 + vec.getY() * 6), (double)(this.getPos().getZ() - 6 + vec.getZ() * 6), (double)(this.getPos().getX() + 7 + vec.getX() * 6), (double)(this.getPos().getY() + 7 + vec.getY() * 6), (double)(this.getPos().getZ() + 7 + vec.getZ() * 6));
            List items = this.world.getEntitiesWithinAABB(EntityItem.class, suckBB, entity -> this.getInsertedSlot(entity.getItem(), inventory) != -1);
            if (items.size() > 0) {
                for (EntityItem item : items) {
                    Vec3d v = new Vec3d(item.posX - ((double)this.getPos().getX() + 0.5), item.posY - ((double)this.getPos().getY() + 0.5), item.posZ - ((double)this.getPos().getZ() + 0.5));
                    v.normalize();
                    item.motionX = -v.x * 0.25 * (double)0.2f + item.motionX * (double)0.8f;
                    item.motionY = -v.y * 0.25 * (double)0.2f + item.motionY * (double)0.8f;
                    item.motionZ = -v.z * 0.25 * (double)0.2f + item.motionZ * (double)0.8f;
                }
            }
            if ((nearestItems = this.world.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB((double)this.getPos().getX() - 0.25, (double)this.getPos().getY() - 0.25, (double)this.getPos().getZ() - 0.25, (double)this.getPos().getX() + 1.25, (double)this.getPos().getY() + 1.25, (double)this.getPos().getZ() + 1.25))).size() > 0) {
                for (EntityItem item : nearestItems) {
                    int slot;
                    if (item.isDead || (slot = this.getInsertedSlot(item.getItem(), inventory)) == -1) continue;
                    item.setItem(inventory.insertItem(slot, item.getItem(), false));
                    if (!item.getItem().isEmpty()) continue;
                    item.setDead();
                }
            }
        }
    }

    int getInsertedSlot(ItemStack stack, IItemHandler inventory) {
        int slot = -1;
        for (int j = 0; j < inventory.getSlots() && slot == -1; ++j) {
            ItemStack added = inventory.insertItem(j, stack, true);
            if (added.getCount() >= stack.getCount() && added.isItemEqual(stack)) continue;
            slot = j;
        }
        return slot;
    }

    public void markDirty() {
        super.markDirty();
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        EnumFacing face = (EnumFacing)state.getValue((IProperty)BlockVacuum.facing);
        return face.getOpposite() == facing ? EnumPipeConnection.PIPE : EnumPipeConnection.NONE;
    }
}

