/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IEmberPipeConnectable;
import teamroots.embers.tileentity.TileEntityEmberPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityEmberPipe
extends TileEntityEmberPipeBase {
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.VALUES.length];
    boolean syncConnections;
    boolean active;
    double currentPush;
    public static final double INIT_PUSH = ConfigMachine.EMBER_CONDUIT.initial_push;
    public static final double INCREMENT_PUSH = ConfigMachine.EMBER_CONDUIT.incremental_push;

    public void updateNeighbors(IBlockAccess world) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.setInternalConnection(facing, this.getConnection(world, this.getPos().offset(facing), facing));
        }
        this.syncConnections = true;
    }

    @Override
    public void update() {
        if (!this.world.isRemote) {
            this.active = this.getWorld().isBlockPowered(this.getPos());
            this.currentPush = this.clogged || !this.active ? INIT_PUSH : (this.currentPush += INCREMENT_PUSH);
            for (EnumFacing facing : EnumFacing.VALUES) {
                TileEntity tile;
                if (!this.isConnected(facing) || (tile = this.world.getTileEntity(this.pos.offset(facing))) == null || !tile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing.getOpposite())) continue;
                if (this.active) {
                    IEmberCapability handler = (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing.getOpposite());
                    if (handler.getEmber() > 0.0 && this.packet == 0.0) {
                        this.packet = handler.removeAmount(Math.min(this.currentPush, handler.getEmberCapacity() / 10.0), true);
                        this.syncPacket = true;
                    }
                    this.setFrom(facing, true);
                    continue;
                }
                this.setFrom(facing, false);
            }
        }
        super.update();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writeConnections(tag);
        return tag;
    }

    private void writeConnections(NBTTagCompound tag) {
        tag.setInteger("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.setInteger("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.setInteger("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.setInteger("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.setInteger("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.setInteger("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.getInteger("up")));
        }
        if (tag.hasKey("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.getInteger("down")));
        }
        if (tag.hasKey("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.getInteger("north")));
        }
        if (tag.hasKey("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.getInteger("south")));
        }
        if (tag.hasKey("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.getInteger("west")));
        }
        if (tag.hasKey("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.getInteger("east")));
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.getUpdateTag();
        if (this.syncConnections) {
            this.writeConnections(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncConnections || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncConnections = false;
    }

    @Override
    int getCapacity() {
        return 240;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing side) {
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NEIGHBORNONE;
        }
        return EnumPipeConnection.PIPE;
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.getIndex()] != null ? this.connections[facing.getIndex()] : EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.getIndex()] = connection;
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getInternalConnection(facing).canTransfer();
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IEmberCapability cap;
        TileEntity tile = world.getTileEntity(pos);
        IEmberCapability iEmberCapability = cap = tile != null ? (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, side.getOpposite()) : null;
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (tile instanceof IEmberPipeConnectable) {
            return ((IEmberPipeConnectable)tile).getConnection(side.getOpposite());
        }
        if (cap != null && cap.acceptsVolatile()) {
            return EnumPipeConnection.BLOCK;
        }
        if (Misc.isValidPipeConnector(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        if (Misc.isValidLever(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
        EnumPipeConnection connection = this.getInternalConnection(face);
        this.setInternalConnection(face, TileEntityEmberPipe.reverseForce(connection));
        TileEntity tile = this.world.getTileEntity(this.pos.offset(face));
        if (tile instanceof TileEntityEmberPipe) {
            ((TileEntityEmberPipe)tile).updateNeighbors((IBlockAccess)this.world);
        }
        if (connection == EnumPipeConnection.FORCENONE) {
            this.world.playSound(null, this.pos, SoundManager.PIPE_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (connection != EnumPipeConnection.NONE && connection != EnumPipeConnection.LEVER) {
            this.world.playSound(null, this.pos, SoundManager.PIPE_DISCONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

