/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IEmberInjectable;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockEmberInjector;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityEmberInjector
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController {
    public IEmberCapability capability = new DefaultEmberCapability();
    protected int ticksExisted = 0;
    protected int progress = -1;
    protected Random random = new Random();
    public static final double EMBER_COST = 1.0;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    boolean isWorking;

    public TileEntityEmberInjector() {
        this.capability.setEmberCapacity(24000.0);
        this.capability.setEmber(0.0);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        boolean cancel;
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.VALUES);
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        IBlockState state = this.world.getBlockState(this.getPos());
        TileEntity tile = this.world.getTileEntity(this.pos.offset((EnumFacing)state.getValue((IProperty)BlockEmberInjector.facing)));
        this.isWorking = false;
        double emberCost = UpgradeUtil.getTotalEmberConsumption(this, 1.0, upgrades) * UpgradeUtil.getTotalSpeedModifier(this, upgrades);
        if (tile instanceof IEmberInjectable && ((IEmberInjectable)tile).isValid() && this.capability.getEmber() > emberCost && !(cancel = UpgradeUtil.doWork(this, upgrades))) {
            ((IEmberInjectable)tile).inject(this, emberCost);
            UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), upgrades);
            this.capability.removeAmount(emberCost, true);
            this.isWorking = true;
            this.markDirty();
            if (this.world.isRemote) {
                for (int i = 0; i < 2; ++i) {
                    ParticleUtil.spawnParticleLineGlow(this.world, (float)this.pos.getX() + 0.5f + 0.25f * (this.random.nextFloat() - 0.5f), (float)this.pos.getY() + 0.625f, (float)this.pos.getZ() + 0.5f + 0.25f * (this.random.nextFloat() - 0.5f), (float)tile.getPos().getX() + 0.5f + (float)((EnumFacing)state.getValue((IProperty)BlockEmberInjector.facing)).getDirectionVec().getX() + 0.5f * (this.random.nextFloat() - 0.5f), (float)tile.getPos().getY() + 0.5f + (float)((EnumFacing)state.getValue((IProperty)BlockEmberInjector.facing)).getDirectionVec().getY() + 0.5f * (this.random.nextFloat() - 0.5f), (float)tile.getPos().getZ() + 0.5f + (float)((EnumFacing)state.getValue((IProperty)BlockEmberInjector.facing)).getDirectionVec().getZ() + 0.5f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 4.0f + this.random.nextFloat() * 2.0f, 40);
                }
            }
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.INJECTOR_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }
}

