/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.block.BlockCatalyticPlug;
import teamroots.embers.tileentity.TileEntityCatalyticPlug;

public class TileEntityCatalyticPlugRenderer
extends TileEntitySpecialRenderer<TileEntityCatalyticPlug> {
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityCatalyticPlug tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile != null && tile.getWorld().getBlockState(tile.getPos()).getBlock() instanceof BlockCatalyticPlug) {
            EnumFacing facing = (EnumFacing)tile.getWorld().getBlockState(tile.getPos()).getValue((IProperty)BlockCatalyticPlug.FACING);
            FluidStack fluidStack = tile.getFluidStack();
            int capacity = tile.getCapacity();
            if (fluidStack != null) {
                Fluid fluid = fluidStack.getFluid();
                int amount = fluidStack.amount;
                int c = fluid.getColor(fluidStack);
                int blue = c & 0xFF;
                int green = c >> 8 & 0xFF;
                int red = c >> 16 & 0xFF;
                alpha = c >> 24 & 0xFF;
                TextureAtlasSprite sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(fluid.getStill(fluidStack).toString());
                this.diffU = this.maxU - this.minU;
                this.diffV = this.maxV - this.minV;
                this.minU = (double)sprite.getMinU() + this.diffU * 0.25;
                this.maxU = (double)sprite.getMaxU() - this.diffU * 0.25;
                this.minV = (double)sprite.getMinV() + this.diffV * 0.25;
                this.maxV = (double)sprite.getMaxV() - this.diffV * 0.25;
                int i = this.getWorld().getCombinedLight(tile.getPos(), fluid.getLuminosity(fluidStack));
                int lightx = i >> 16 & 0xFFFF;
                int lighty = i & 0xFFFF;
                GlStateManager.disableCull();
                GlStateManager.disableLighting();
                GlStateManager.enableBlend();
                GlStateManager.enableAlpha();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                Tessellator tess = Tessellator.getInstance();
                BufferBuilder buffer = tess.getBuffer();
                buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
                buffer.pos(x + 0.25, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.25).tex(this.minU, this.minV).lightmap(lightx, lighty).color((float)red, (float)green, (float)blue, alpha).endVertex();
                buffer.pos(x + 0.75, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.25).tex(this.maxU, this.minV).lightmap(lightx, lighty).color((float)red, (float)green, (float)blue, alpha).endVertex();
                buffer.pos(x + 0.75, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.75).tex(this.maxU, this.maxV).lightmap(lightx, lighty).color((float)red, (float)green, (float)blue, alpha).endVertex();
                buffer.pos(x + 0.25, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.75).tex(this.minU, this.maxV).lightmap(lightx, lighty).color((float)red, (float)green, (float)blue, alpha).endVertex();
                tess.draw();
                GlStateManager.disableAlpha();
                GlStateManager.disableBlend();
                GlStateManager.enableLighting();
            }
            GlStateManager.popMatrix();
        }
        super.render((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
    }
}

