/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.misc.IMetalCoefficient;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityBoilerTop;
import teamroots.embers.util.Misc;

public class TileEntityBoilerBottom
extends TileFluidHandler
implements ITileEntityBase,
ITickable,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final double BASE_MULTIPLIER = ConfigMachine.BOILER.base_multiplier;
    public static final double PER_BLOCK_MULTIPLIER = ConfigMachine.BOILER.per_block_multiplier;
    public static final int FLUID_CONSUMED = ConfigMachine.BOILER.fluid_consumed;
    public static final int PROCESS_TIME = ConfigMachine.BOILER.process_time;
    public static final int CAPACITY = ConfigMachine.BOILER.capacity;
    Random random = new Random();
    int progress = -1;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityBoilerBottom.this.markDirty();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (EmbersAPI.getEmberValue(stack) == 0.0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();

    public TileEntityBoilerBottom() {
        this.tank = new FluidTank(CAPACITY);
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.setInteger("progress", this.progress);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        if (tag.hasKey("progress")) {
            this.progress = tag.getInteger("progress");
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank);
        if (didFill) {
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(this.getWorld(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public double getMultiplier() {
        IBlockState metalState = this.world.getBlockState(this.pos.down());
        IMetalCoefficient metalCoefficient = EmbersAPI.getMetalCoefficient(metalState);
        double metalMultiplier = metalCoefficient != null ? metalCoefficient.getCoefficient(metalState) : 0.0;
        double totalMult = BASE_MULTIPLIER;
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            IBlockState state = this.world.getBlockState(this.pos.down().offset(facing));
            if (state.getBlock() != Blocks.LAVA && state.getBlock() != Blocks.FLOWING_LAVA && state.getBlock() != Blocks.FIRE) continue;
            totalMult += PER_BLOCK_MULTIPLIER * metalMultiplier;
        }
        return totalMult;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        boolean cancel;
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.HORIZONTALS);
        UpgradeUtil.verifyUpgrades((TileEntity)this, this.upgrades);
        if (UpgradeUtil.doTick((TileEntity)this, this.upgrades)) {
            return;
        }
        TileEntity tile = this.getWorld().getTileEntity(this.getPos().up());
        int i = this.random.nextInt(this.inventory.getSlots());
        ItemStack emberStack = this.inventory.getStackInSlot(i);
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.getFluidAmount() >= FLUID_CONSUMED && !emberStack.isEmpty() && !(cancel = UpgradeUtil.doWork((TileEntity)this, this.upgrades)) && tile instanceof TileEntityBoilerTop) {
            TileEntityBoilerTop top = (TileEntityBoilerTop)tile;
            ++this.progress;
            if (this.progress > UpgradeUtil.getWorkTime((TileEntity)this, PROCESS_TIME, this.upgrades)) {
                this.progress = 0;
                double emberValue = EmbersAPI.getEmberValue(emberStack);
                double ember = UpgradeUtil.getTotalEmberProduction((TileEntity)this, emberValue * this.getMultiplier(), this.upgrades);
                if (ember > 0.0 && top.capability.getEmber() + ember <= top.capability.getEmberCapacity()) {
                    if (!this.world.isRemote) {
                        this.world.playSound(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.5, (double)this.getPos().getZ() + 0.5, SoundManager.PRESSURE_REFINERY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((float)this.getPos().getX() + 0.5f, (float)this.getPos().getY() + 1.5f, (float)this.getPos().getZ() + 0.5f));
                    }
                    UpgradeUtil.throwEvent((TileEntity)this, new EmberEvent((TileEntity)this, EmberEvent.EnumType.PRODUCE, ember), this.upgrades);
                    top.capability.addAmount(ember, true);
                    this.inventory.extractItem(i, 1, false);
                    this.tank.drain(FLUID_CONSUMED, true);
                    this.markDirty();
                    top.markDirty();
                }
            }
            this.markDirty();
        }
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE((TileEntity)this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("ember".equals(dialType)) {
            DecimalFormat multiplierFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.ember_multiplier");
            double multiplier = this.getMultiplier();
            information.add(I18n.format((String)"embers.tooltip.dial.ember_multiplier", (Object[])new Object[]{multiplierFormat.format(multiplier)}));
        }
        UpgradeUtil.throwEvent((TileEntity)this, new DialInformationEvent((TileEntity)this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.format((String)"embers.tooltip.goggles.item.ember", (Object[])new Object[0])));
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.format((String)"embers.tooltip.goggles.fluid.water", (Object[])new Object[0])));
        }
    }
}

