/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.block.BlockBeamSplitter;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityBeamSplitter
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketProducer,
IEmberPacketReceiver {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    Random random = new Random();
    public BlockPos targetLeft = null;
    public BlockPos targetRight = null;
    long ticksExisted = 0L;

    public TileEntityBeamSplitter() {
        this.capability.setEmberCapacity(400.0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        if (this.targetLeft != null) {
            tag.setInteger("targetLeftX", this.targetLeft.getX());
            tag.setInteger("targetLeftY", this.targetLeft.getY());
            tag.setInteger("targetLeftZ", this.targetLeft.getZ());
        }
        if (this.targetRight != null) {
            tag.setInteger("targetRightX", this.targetRight.getX());
            tag.setInteger("targetRightY", this.targetRight.getY());
            tag.setInteger("targetRightZ", this.targetRight.getZ());
        }
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        if (tag.hasKey("targetLeftX")) {
            this.targetLeft = new BlockPos(tag.getInteger("targetLeftX"), tag.getInteger("targetLeftY"), tag.getInteger("targetLeftZ"));
        }
        if (tag.hasKey("targetRightX")) {
            this.targetRight = new BlockPos(tag.getInteger("targetRightX"), tag.getInteger("targetRightY"), tag.getInteger("targetRightZ"));
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        ++this.ticksExisted;
        if (this.ticksExisted % 20L == 0L && !this.getWorld().isRemote && this.capability.getEmber() > 0.0) {
            boolean sendRight;
            TileEntity tileLeft = this.targetLeft != null ? this.getWorld().getTileEntity(this.targetLeft) : null;
            TileEntity tileRight = this.targetRight != null ? this.getWorld().getTileEntity(this.targetRight) : null;
            boolean sendLeft = tileLeft instanceof IEmberPacketReceiver && !((IEmberPacketReceiver)tileLeft).isFull();
            boolean bl = sendRight = tileRight instanceof IEmberPacketReceiver && !((IEmberPacketReceiver)tileRight).isFull();
            if (!sendLeft && !sendRight) {
                return;
            }
            double amount = this.capability.getEmber();
            if (sendLeft && sendRight) {
                amount /= 2.0;
            }
            boolean isXAligned = (Boolean)this.getWorld().getBlockState(this.getPos()).getValue((IProperty)BlockBeamSplitter.isXAligned);
            if (sendLeft) {
                EntityEmberPacket packetLeft = new EntityEmberPacket(this.getWorld());
                if (isXAligned) {
                    packetLeft.initCustom(this.getPos(), this.targetLeft, 0.0, -0.01, -0.5, amount);
                } else {
                    packetLeft.initCustom(this.getPos(), this.targetLeft, -0.5, -0.01, 0.0, amount);
                }
                this.getWorld().spawnEntity((Entity)packetLeft);
            }
            if (sendRight) {
                EntityEmberPacket packetRight = new EntityEmberPacket(this.getWorld());
                if (isXAligned) {
                    packetRight.initCustom(this.getPos(), this.targetRight, 0.0, -0.01, 0.5, amount);
                } else {
                    packetRight.initCustom(this.getPos(), this.targetRight, 0.5, -0.01, 0.0, amount);
                }
                this.getWorld().spawnEntity((Entity)packetRight);
            }
            this.capability.setEmber(0.0);
            this.markDirty();
        }
    }

    @Override
    public boolean isFull() {
        return this.capability.getEmber() >= this.capability.getEmberCapacity();
    }

    @Override
    public boolean onReceive(EntityEmberPacket packet) {
        return true;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        if (pos.equals((Object)this.getPos())) {
            return;
        }
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        if (((Boolean)state.getValue((IProperty)BlockBeamSplitter.isXAligned)).booleanValue()) {
            if (side == EnumFacing.NORTH) {
                this.targetLeft = pos;
                this.markDirty();
            }
            if (side == EnumFacing.SOUTH) {
                this.targetRight = pos;
                this.markDirty();
            }
        } else {
            if (side == EnumFacing.WEST) {
                this.targetLeft = pos;
                this.markDirty();
            }
            if (side == EnumFacing.EAST) {
                this.targetRight = pos;
                this.markDirty();
            }
        }
    }
}

