/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.api.tile.ISparkable;
import teamroots.embers.api.tile.ITargetable;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockBeamCannon;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageBeamCannonFX;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.register.DamageSourceRegister;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityBeamCannon
extends TileEntity
implements ITileEntityBase,
ITickable,
ITargetable {
    public static final double PULL_RATE = ConfigMachine.BEAM_CANNON.pull_rate;
    public static final int FIRE_THRESHOLD = ConfigMachine.BEAM_CANNON.fire_threshold;
    public static final double DAMAGE = ConfigMachine.BEAM_CANNON.damage;
    public static final int MAX_DISTANCE = ConfigMachine.BEAM_CANNON.max_distance;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public boolean acceptsVolatile() {
            return true;
        }
    };
    public BlockPos target = null;
    public BlockPos lastTarget = null;
    public long ticksExisted = 0L;
    public boolean lastPowered = false;
    public Random random = new Random();
    int offset = this.random.nextInt(40);
    private List<IUpgradeProvider> upgrades;

    public TileEntityBeamCannon() {
        this.onLoad();
        this.capability.setEmberCapacity(2000.0);
    }

    @Nonnull
    public EnumFacing getFacing() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        return (EnumFacing)state.getValue((IProperty)BlockBeamCannon.facing);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.target != null) {
            tag.setInteger("targetX", this.target.getX());
            tag.setInteger("targetY", this.target.getY());
            tag.setInteger("targetZ", this.target.getZ());
        }
        tag.setBoolean("lastPowered", this.lastPowered);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("targetX")) {
            this.target = new BlockPos(tag.getInteger("targetX"), tag.getInteger("targetY"), tag.getInteger("targetZ"));
        }
        this.lastPowered = tag.getBoolean("lastPowered");
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public void update() {
        EnumFacing facing = this.getFacing();
        if (this.target == null && this.ticksExisted == 0L) {
            this.target = this.getPos().offset(facing);
        }
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, new EnumFacing[]{facing.getOpposite()});
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        ++this.ticksExisted;
        boolean cancel = UpgradeUtil.doWork(this, this.upgrades);
        boolean isPowered = this.getWorld().isBlockPowered(this.getPos());
        boolean redstoneEnabled = UpgradeUtil.getOtherParameter((TileEntity)this, "redstone_enabled", true, this.upgrades);
        int threshold = UpgradeUtil.getOtherParameter((TileEntity)this, "fire_threshold", FIRE_THRESHOLD, this.upgrades);
        if (!cancel && this.capability.getEmber() >= (double)threshold && (!redstoneEnabled || isPowered && !this.lastPowered)) {
            this.fire();
        }
        this.lastPowered = isPowered;
    }

    private void pullEmber() {
        IEmberCapability cap;
        EnumFacing facing = this.getFacing();
        TileEntity attachedTile = this.getWorld().getTileEntity(this.getPos().offset(facing.getOpposite()));
        if (attachedTile != null && attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)).getEmber() > 0.0 && this.capability.getEmber() < this.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(PULL_RATE, true);
            this.capability.addAmount(removed, true);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTarget(BlockPos pos) {
        this.target = pos;
        this.markDirty();
    }

    public void fire() {
        Vec3d ray = new Vec3d((double)(this.target.getX() - this.getPos().getX()), (double)(this.target.getY() - this.getPos().getY()), (double)(this.target.getZ() - this.getPos().getZ())).normalize();
        double impactDist = Double.POSITIVE_INFINITY;
        double damage = UpgradeUtil.getOtherParameter((TileEntity)this, "damage", DAMAGE, this.upgrades);
        if (!this.getWorld().isRemote) {
            double posX = (double)this.getPos().getX() + 0.5;
            double posY = (double)this.getPos().getY() + 0.5;
            double posZ = (double)this.getPos().getZ() + 0.5;
            double startX = posX;
            double startY = posY;
            double startZ = posZ;
            boolean doContinue = true;
            int maxDist = UpgradeUtil.getOtherParameter((TileEntity)this, "distance", MAX_DISTANCE, this.upgrades);
            for (int i = 0; i < maxDist * 10 && doContinue; ++i) {
                IBlockState state = this.getWorld().getBlockState(new BlockPos(posX += ray.x * 0.1, posY += ray.y * 0.1, posZ += ray.z * 0.1));
                TileEntity tile = this.getWorld().getTileEntity(new BlockPos(posX, posY, posZ));
                if (this.sparkTarget(tile)) {
                    doContinue = false;
                } else if (tile instanceof IEmberPacketReceiver) {
                    if (tile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
                        ((IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)).addAmount(this.capability.getEmber(), true);
                        tile.markDirty();
                    }
                    doContinue = false;
                } else if (state.isFullCube() && state.isOpaqueCube()) {
                    doContinue = false;
                }
                List rawEntities = this.getWorld().getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(posX - 0.85, posY - 0.85, posZ - 0.85, posX + 0.85, posY + 0.85, posZ + 0.85));
                for (EntityLivingBase rawEntity : rawEntities) {
                    rawEntity.attackEntityFrom(DamageSourceRegister.DAMAGE_EMBER, (float)damage);
                }
                if (doContinue) continue;
                this.world.playSound(null, posX, posY, posZ, SoundManager.BEAM_CANNON_HIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                impactDist = i;
            }
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageBeamCannonFX(startX, startY, startZ, ray.x, ray.y, ray.z, impactDist));
            UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, this.capability.getEmber()), this.upgrades);
            this.capability.setEmber(0.0);
            this.markDirty();
            this.world.playSound(null, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, SoundManager.BEAM_CANNON_FIRE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean sparkTarget(TileEntity target) {
        if (target instanceof ISparkable) {
            ((ISparkable)target).sparkProgress(this, this.capability.getEmber());
            return true;
        }
        return false;
    }
}

