/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.block.BlockAutoHammer;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.tileentity.TileEntityAutoHammer;
import teamroots.embers.util.RenderUtil;
import teamroots.embers.util.StructBox;
import teamroots.embers.util.StructUV;

public class TileEntityAutoHammerRenderer
extends TileEntitySpecialRenderer<TileEntityAutoHammer> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/auto_hammer.png");
    public int lightx = 0;
    public int lighty = 0;
    public StructBox hammerShaft = new StructBox(-0.0625, 0.0, -0.0625, 0.0625, 0.625, 0.0625, new StructUV[]{new StructUV(1.0, 1.0, 3.0, 3.0, 16.0, 16.0), new StructUV(2.0, 2.0, 4.0, 4.0, 16.0, 16.0), new StructUV(0.0, 4.0, 2.0, 14.0, 16.0, 16.0), new StructUV(0.0, 4.0, 2.0, 14.0, 16.0, 16.0), new StructUV(0.0, 4.0, 2.0, 14.0, 16.0, 16.0), new StructUV(0.0, 4.0, 2.0, 14.0, 16.0, 16.0)});
    public StructBox hammerHead = new StructBox(-0.125, 0.625, -0.1875, 0.125, 0.875, 0.1875, new StructUV[]{new StructUV(4.0, 0.0, 10.0, 4.0, 16.0, 16.0), new StructUV(4.0, 0.0, 10.0, 4.0, 16.0, 16.0), new StructUV(0.0, 0.0, 4.0, 4.0, 16.0, 16.0), new StructUV(0.0, 0.0, 4.0, 4.0, 16.0, 16.0), new StructUV(4.0, 0.0, 10.0, 4.0, 16.0, 16.0), new StructUV(4.0, 0.0, 10.0, 4.0, 16.0, 16.0)});

    public void render(TileEntityAutoHammer tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null && tile.getWorld().getBlockState(tile.getPos()).getBlock() == BlockRegister.AUTO_HAMMER) {
            float progress = tile.progress;
            GlStateManager.pushMatrix();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Minecraft.getMinecraft().renderEngine.bindTexture(this.texture);
            GlStateManager.disableCull();
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder buffer = tess.getBuffer();
            GlStateManager.translate((double)x, (double)y, (double)z);
            EnumFacing facing = (EnumFacing)tile.getWorld().getBlockState(tile.getPos()).getValue((IProperty)BlockAutoHammer.facing);
            float angle = 0.0f;
            if (facing == EnumFacing.SOUTH) {
                angle = 180.0f;
            }
            if (facing == EnumFacing.EAST) {
                angle = 270.0f;
            }
            if (facing == EnumFacing.WEST) {
                angle = 90.0f;
            }
            float hammerAngle = -45.0f;
            if (progress != -1.0f && (hammerAngle = -45.0f - 90.0f * (1.0f - (progress - partialTicks) / 5.0f + 1.0f)) < -135.0f) {
                hammerAngle = -135.0f - (hammerAngle + 135.0f);
            }
            GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.rotate((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)-0.25f);
            GlStateManager.rotate((float)hammerAngle, (float)1.0f, (float)0.0f, (float)0.0f);
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
            RenderUtil.addBox(buffer, this.hammerShaft.x1, this.hammerShaft.y1, this.hammerShaft.z1, this.hammerShaft.x2, this.hammerShaft.y2, this.hammerShaft.z2, this.hammerShaft.textures, new int[]{1, 1, 1, 1, 1, 1});
            RenderUtil.addBox(buffer, this.hammerHead.x1, this.hammerHead.y1, this.hammerHead.z1, this.hammerHead.x2, this.hammerHead.y2, this.hammerHead.z2, this.hammerHead.textures, new int[]{1, 1, 1, 1, 1, 1});
            tess.draw();
            GlStateManager.popMatrix();
        }
    }
}

