/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import teamroots.embers.config.ConfigClient;
import teamroots.embers.particle.IEmberParticle;
import teamroots.embers.util.Misc;

public class ParticleSmoke
extends Particle
implements IEmberParticle {
    public float colorR = 0.0f;
    public float colorG = 0.0f;
    public float colorB = 0.0f;
    public float initScale = 0.0f;
    public float initAlpha = 0.0f;
    public ResourceLocation texture = new ResourceLocation("embers:entity/particle_smoke");

    public ParticleSmoke(World worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, float a, float scale, int lifetime) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        if ((double)this.colorR > 1.0) {
            this.colorR /= 255.0f;
        }
        if ((double)this.colorG > 1.0) {
            this.colorG /= 255.0f;
        }
        if ((double)this.colorB > 1.0) {
            this.colorB /= 255.0f;
        }
        this.setRBGColorF(this.colorR, this.colorG, this.colorB);
        this.particleMaxAge = lifetime;
        this.particleScale = scale;
        this.initScale = scale;
        this.motionX = vx;
        this.motionY = vy;
        this.motionZ = vz;
        this.particleAngle = (float)Math.PI * 2;
        this.particleAlpha = this.initAlpha = a;
        TextureAtlasSprite sprite = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(this.texture.toString());
        this.setParticleTexture(sprite);
        this.canCollide = ConfigClient.enableParticleCollisions;
    }

    public boolean shouldDisableDepth() {
        return true;
    }

    public int getFXLayer() {
        return 1;
    }

    public void onUpdate() {
        super.onUpdate();
        if (Misc.random.nextInt(6) == 0) {
            ++this.particleAge;
        }
        float lifeCoeff = (float)this.particleAge / (float)this.particleMaxAge;
        this.particleScale = this.initScale - this.initScale * lifeCoeff;
        this.particleAlpha = (1.0f - lifeCoeff) * this.initAlpha;
        this.motionX *= 0.96;
        this.motionY *= 0.96;
        this.motionZ *= 0.96;
        this.motionY += 0.004;
    }

    @Override
    public boolean alive() {
        return this.particleAge < this.particleMaxAge;
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public boolean renderThroughBlocks() {
        return false;
    }
}

