/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.particle;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import teamroots.embers.config.ConfigClient;
import teamroots.embers.particle.IEmberParticle;
import teamroots.embers.particle.ParticleGlow;

public class ParticleRenderer {
    private final ArrayDeque<Particle> normalParticles = new ArrayDeque();
    private final ArrayDeque<Particle> additiveParticles = new ArrayDeque();
    private final ArrayDeque<Particle> throughParticles = new ArrayDeque();
    private final ArrayDeque<Particle> additiveThroughParticles = new ArrayDeque();
    private final Queue<Particle> queue = new ArrayDeque<Particle>();

    public void updateParticles() {
        this.updateParticles(this.normalParticles);
        this.updateParticles(this.additiveParticles);
        this.updateParticles(this.throughParticles);
        this.updateParticles(this.additiveThroughParticles);
        if (!this.queue.isEmpty()) {
            Particle particle = this.queue.poll();
            while (particle != null) {
                IEmberParticle emberParticle = (IEmberParticle)particle;
                boolean additive = emberParticle.isAdditive();
                boolean rendersThrough = emberParticle.renderThroughBlocks();
                this.getParticleCollection(additive, rendersThrough).add(particle);
                particle = this.queue.poll();
            }
        }
    }

    public void updateParticles(ArrayDeque<Particle> particles) {
        Iterator<Particle> iterator = particles.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            if (((IEmberParticle)particle).alive() && (ConfigClient.enableParticles || particle instanceof ParticleGlow)) {
                particle.onUpdate();
                continue;
            }
            iterator.remove();
        }
    }

    public void renderParticles(EntityPlayer dumbplayer, float partialTicks) {
        float f = ActiveRenderInfo.getRotationX();
        float f1 = ActiveRenderInfo.getRotationZ();
        float f2 = ActiveRenderInfo.getRotationYZ();
        float f3 = ActiveRenderInfo.getRotationXY();
        float f4 = ActiveRenderInfo.getRotationXZ();
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player != null) {
            Particle.interpPosX = player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)partialTicks;
            Particle.interpPosY = player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)partialTicks;
            Particle.interpPosZ = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)partialTicks;
            Particle.cameraViewDir = player.getLook(partialTicks);
            GlStateManager.enableAlpha();
            GlStateManager.enableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.003921569f);
            GlStateManager.disableCull();
            GlStateManager.depthMask((boolean)false);
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder buffer = tess.getBuffer();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
            for (Particle particle : this.normalParticles) {
                particle.renderParticle(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.draw();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buffer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
            for (Particle particle : this.additiveParticles) {
                particle.renderParticle(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.draw();
            GlStateManager.disableDepth();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
            for (Particle particle : this.throughParticles) {
                particle.renderParticle(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.draw();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buffer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
            for (Particle particle : this.additiveThroughParticles) {
                particle.renderParticle(buffer, (Entity)player, partialTicks, f, f4, f1, f2, f3);
            }
            tess.draw();
            GlStateManager.enableDepth();
            GlStateManager.enableCull();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.disableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
        }
    }

    public void addParticle(Particle particle) {
        if (!ConfigClient.enableParticles && !(particle instanceof ParticleGlow)) {
            return;
        }
        if (particle instanceof IEmberParticle) {
            this.queue.add(particle);
        }
    }

    private Collection<Particle> getParticleCollection(boolean additive, boolean rendersThroughBlocks) {
        if (!rendersThroughBlocks && !additive) {
            return this.normalParticles;
        }
        if (!rendersThroughBlocks) {
            return this.additiveParticles;
        }
        if (!additive) {
            return this.throughParticles;
        }
        return this.additiveThroughParticles;
    }
}

