/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.particle.ParticleUtil;

public class MessageEmberActivationFX
implements IMessage {
    public static Random random = new Random();
    double posX = 0.0;
    double posY = 0.0;
    double posZ = 0.0;
    Color colorFlame = new Color(255, 64, 16);
    Color colorSpark = new Color(255, 64, 16);

    public MessageEmberActivationFX() {
    }

    public MessageEmberActivationFX(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public MessageEmberActivationFX(double x, double y, double z, Color colorFlame, Color colorSpark) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.colorFlame = colorFlame;
        this.colorSpark = colorSpark;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.colorFlame = new Color(buf.readInt(), buf.readInt(), buf.readInt());
        this.colorSpark = new Color(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        this.writeColor(buf, this.colorFlame);
        this.writeColor(buf, this.colorSpark);
    }

    private void writeColor(ByteBuf buf, Color color) {
        buf.writeInt(color.getRed());
        buf.writeInt(color.getGreen());
        buf.writeInt(color.getBlue());
    }

    private static boolean isVisible(Color color) {
        return color.getRed() > 0 || color.getGreen() > 0 || color.getBlue() > 0;
    }

    public static class MessageHolder
    implements IMessageHandler<MessageEmberActivationFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageEmberActivationFX message, MessageContext ctx) {
            WorldClient world = Minecraft.getMinecraft().world;
            Minecraft.getMinecraft().addScheduledTask(() -> MessageHolder.lambda$onMessage$0(message, (World)world));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(MessageEmberActivationFX message, World world) {
            int k;
            if (MessageEmberActivationFX.isVisible(message.colorFlame)) {
                for (k = 0; k < 80; ++k) {
                    ParticleUtil.spawnParticleLineGlow(world, (float)message.posX + 0.25f * (random.nextFloat() - 0.5f), (float)message.posY, (float)message.posZ + 0.25f * (random.nextFloat() - 0.5f), (float)message.posX + 0.75f * (random.nextFloat() - 0.5f), (float)message.posY + 2.0f + 0.75f * (random.nextFloat() - 0.5f), (float)message.posZ + 0.75f * (random.nextFloat() - 0.5f), message.colorFlame.getRed(), message.colorFlame.getGreen(), message.colorFlame.getBlue(), 3.0f + random.nextFloat() * 1.5f, 20 + random.nextInt(20));
                }
            }
            for (k = 0; k < 20; ++k) {
                ParticleUtil.spawnParticleSmoke(world, (float)message.posX + 0.25f * (random.nextFloat() - 0.5f), (float)message.posY, (float)message.posZ + 0.25f * (random.nextFloat() - 0.5f), 0.0625f * (random.nextFloat() - 0.5f), 0.0625f + 0.0625f * (random.nextFloat() - 0.5f), 0.0625f * (random.nextFloat() - 0.5f), 64.0f, 64.0f, 64.0f, 0.5f, 4.0f + random.nextFloat() * 4.0f, 60);
            }
            if (MessageEmberActivationFX.isVisible(message.colorSpark)) {
                for (float a = 0.0f; a < 10.0f; a += 1.0f) {
                    ParticleUtil.spawnParticleSpark(world, (float)message.posX, (float)message.posY + 0.5f, (float)message.posZ, 0.125f * (random.nextFloat() - 0.5f), 0.125f * random.nextFloat(), 0.125f * (random.nextFloat() - 0.5f), message.colorSpark.getRed(), message.colorSpark.getGreen(), message.colorSpark.getBlue(), random.nextFloat() * 0.75f + 0.45f, 60 + random.nextInt(20));
                }
            }
        }
    }
}

