/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.util.Misc;

public class ModelMagmaWormSegment
extends ModelBase {
    public static ModelMagmaWormSegment INSTANCE;
    ModelRenderer head1;
    ModelRenderer stonehead1;
    ModelRenderer stonehead2;
    ModelRenderer crest1;
    ModelRenderer crest2;
    ModelRenderer crest3;
    ModelRenderer crest4;
    ModelRenderer leg1;
    ModelRenderer leg2;
    ModelRenderer head2;
    ModelRenderer head3;
    ModelRenderer leg3;
    ModelRenderer leg4;
    ModelRenderer crest5;
    ModelRenderer crest6;
    ModelRenderer crest7;
    ModelRenderer crest8;

    public ModelMagmaWormSegment() {
        this.textureWidth = 128;
        this.textureHeight = 128;
        this.head1 = new ModelRenderer((ModelBase)this, 64, 0);
        this.head1.addBox(-6.0f, -6.0f, -6.0f, 12, 12, 12);
        this.head1.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.head1.setTextureSize(128, 128);
        this.head1.mirror = true;
        this.setRotation(this.head1, 0.0f, 0.0f, 0.0f);
        this.stonehead1 = new ModelRenderer((ModelBase)this, 16, 32);
        this.stonehead1.addBox(-3.0f, -3.0f, -3.0f, 6, 6, 6);
        this.stonehead1.setRotationPoint(0.0f, 0.0f, -1.0f);
        this.stonehead1.setTextureSize(128, 128);
        this.stonehead1.mirror = true;
        this.setRotation(this.stonehead1, 0.0f, 0.0f, 0.0f);
        this.stonehead2 = new ModelRenderer((ModelBase)this, 16, 32);
        this.stonehead2.addBox(-2.0f, -2.0f, -2.0f, 4, 4, 4);
        this.stonehead2.setRotationPoint(0.0f, 0.0f, 6.0f);
        this.stonehead2.setTextureSize(128, 128);
        this.stonehead2.mirror = true;
        this.setRotation(this.stonehead2, 0.0f, 0.0f, 0.0f);
        this.crest1 = new ModelRenderer((ModelBase)this, 32, 0);
        this.crest1.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.crest1.setRotationPoint(3.0f, -4.0f, -1.0f);
        this.crest1.setTextureSize(128, 128);
        this.crest1.mirror = true;
        this.setRotation(this.crest1, 2.617994f, 0.0f, 0.5235988f);
        this.crest2 = new ModelRenderer((ModelBase)this, 48, 0);
        this.crest2.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4);
        this.crest2.setRotationPoint(4.0f, -1.0f, -2.0f);
        this.crest2.setTextureSize(128, 128);
        this.crest2.mirror = true;
        this.setRotation(this.crest2, 2.617994f, 0.0f, 1.308997f);
        this.crest3 = new ModelRenderer((ModelBase)this, 32, 0);
        this.crest3.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.crest3.setRotationPoint(-3.0f, -4.0f, -1.0f);
        this.crest3.setTextureSize(128, 128);
        this.crest3.mirror = true;
        this.setRotation(this.crest3, 2.617994f, 0.0f, -0.5235988f);
        this.crest4 = new ModelRenderer((ModelBase)this, 48, 0);
        this.crest4.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4);
        this.crest4.setRotationPoint(-4.0f, -1.0f, -2.0f);
        this.crest4.setTextureSize(128, 128);
        this.crest4.mirror = true;
        this.setRotation(this.crest4, 2.617994f, 0.0f, -1.308997f);
        this.leg1 = new ModelRenderer((ModelBase)this, 32, 0);
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.leg1.setRotationPoint(-4.0f, 4.0f, -1.0f);
        this.leg1.setTextureSize(128, 128);
        this.leg1.mirror = true;
        this.setRotation(this.leg1, 2.879793f, 0.0f, -2.617994f);
        this.leg2 = new ModelRenderer((ModelBase)this, 32, 0);
        this.leg2.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.leg2.setRotationPoint(4.0f, 4.0f, -1.0f);
        this.leg2.setTextureSize(128, 128);
        this.leg2.mirror = true;
        this.setRotation(this.leg2, 2.879793f, 0.0f, 2.617994f);
        this.head2 = new ModelRenderer((ModelBase)this, 0, 64);
        this.head2.addBox(-5.0f, -5.0f, -5.0f, 10, 10, 10);
        this.head2.setRotationPoint(0.0f, 0.0f, 11.0f);
        this.head2.setTextureSize(128, 128);
        this.head2.mirror = true;
        this.setRotation(this.head2, 0.0f, 0.0f, 0.0f);
        this.leg3 = new ModelRenderer((ModelBase)this, 32, 0);
        this.leg3.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.leg3.setRotationPoint(2.5f, 3.0f, 8.0f);
        this.leg3.setTextureSize(128, 128);
        this.leg3.mirror = true;
        this.setRotation(this.leg3, 2.617994f, 0.0f, 2.617994f);
        this.leg4 = new ModelRenderer((ModelBase)this, 32, 0);
        this.leg4.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.leg4.setRotationPoint(-2.5f, 3.0f, 8.0f);
        this.leg4.setTextureSize(128, 128);
        this.leg4.mirror = true;
        this.setRotation(this.leg4, 2.617994f, 0.0f, -2.617994f);
        this.crest5 = new ModelRenderer((ModelBase)this, 48, 0);
        this.crest5.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4);
        this.crest5.setRotationPoint(-3.0f, 0.0f, 9.0f);
        this.crest5.setTextureSize(128, 128);
        this.crest5.mirror = true;
        this.setRotation(this.crest5, 2.617994f, 0.0f, -1.308997f);
        this.crest6 = new ModelRenderer((ModelBase)this, 48, 0);
        this.crest6.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4);
        this.crest6.setRotationPoint(3.0f, 0.0f, 9.0f);
        this.crest6.setTextureSize(128, 128);
        this.crest6.mirror = true;
        this.setRotation(this.crest6, 2.617994f, 0.0f, 1.308997f);
        this.crest7 = new ModelRenderer((ModelBase)this, 32, 0);
        this.crest7.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.crest7.setRotationPoint(2.0f, -3.0f, 9.0f);
        this.crest7.setTextureSize(128, 128);
        this.crest7.mirror = true;
        this.setRotation(this.crest7, 2.617994f, 0.0f, 0.5235988f);
        this.crest8 = new ModelRenderer((ModelBase)this, 32, 0);
        this.crest8.addBox(-2.0f, 0.0f, -2.0f, 4, 8, 4);
        this.crest8.setRotationPoint(-2.0f, -3.0f, 9.0f);
        this.crest8.setTextureSize(128, 128);
        this.crest8.mirror = true;
        this.setRotation(this.crest8, 2.617994f, 0.0f, -0.5235988f);
        this.head3 = new ModelRenderer((ModelBase)this, 0, 16);
        this.head3.addBox(-3.0f, -3.0f, -3.0f, 6, 6, 6);
        this.head3.setRotationPoint(0.0f, 0.0f, 19.0f);
        this.head3.setTextureSize(128, 128);
        this.head3.mirror = true;
        this.setRotation(this.head3, 0.0f, 0.0f, 0.0f);
    }

    public Vec3d getPosFromIndex(EntityMagmaWorm guardian, int index, float partialTicks) {
        return guardian.getSegmentPosition(index, partialTicks);
    }

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, int index) {
        float scale = scaleFactor;
        super.render(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entity);
        GlStateManager.pushAttrib();
        EntityMagmaWorm guardian = (EntityMagmaWorm)entity;
        Vec3d basePos = guardian.getHeadPosition(ageInTicks - (float)((int)ageInTicks));
        float fade = guardian.getFade(ageInTicks - (float)((int)ageInTicks));
        Vec3d pos1 = this.getPosFromIndex(guardian, index, ageInTicks - (float)((int)ageInTicks));
        Vec3d pos2 = this.getPosFromIndex(guardian, index + 1, ageInTicks - (float)((int)ageInTicks));
        float yaw = Misc.yawDegreesBetweenPoints(pos2.x, pos1.y, pos1.z, pos1.x, pos2.y, pos2.z);
        float pitch = Misc.pitchDegreesBetweenPoints(pos2.x, pos1.y, pos1.z, pos1.x, pos2.y, pos2.z);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(-basePos.x + pos1.x), (double)(basePos.y - pos1.y), (double)(basePos.z - pos1.z));
        GlStateManager.rotate((float)(yaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f * fade));
        this.stonehead1.render(scale);
        this.stonehead2.render(scale);
        GlStateManager.enableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.disableLighting();
        float lavaFade = guardian.getSegmentFade(index) * fade;
        GlStateManager.color((float)(1.0f * lavaFade), (float)(1.0f * lavaFade), (float)(1.0f * lavaFade), (float)(0.75f * lavaFade));
        this.head1.render(scale);
        this.head2.render(scale);
        this.head3.render(scale);
        this.leg1.render(scale);
        this.leg2.render(scale);
        this.leg3.render(scale);
        this.leg4.render(scale);
        this.crest1.render(scale);
        this.crest2.render(scale);
        this.crest3.render(scale);
        this.crest4.render(scale);
        this.crest5.render(scale);
        this.crest6.render(scale);
        this.crest7.render(scale);
        this.crest8.render(scale);
        GlStateManager.enableLighting();
        GlStateManager.disableAlpha();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
        GlStateManager.popAttrib();
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }
}

