/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.mixin.osv;

import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.properties.PropertyGroup;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import teamroots.embers.config.ConfigMaterial;

@Mixin(value={PropertyGroup.class}, remap=false)
public class PropertyGroupMixin {
    @Overwrite
    public static Set<PropertyGroup> setupPropertyGroups() {
        HashSet<PropertyGroup> groups = new HashSet<PropertyGroup>();
        Cfg.BlockRegistryCat.propertyGroups.forEach((name, entries) -> {
            if (Cfg.groupListed((String)name) && (!Cfg.modFamiliar((String)name) || Cfg.modEnabled((String)name))) {
                if (!name.equals("embers")) {
                    groups.add(new PropertyGroup(name, OreProperties.of((String[])entries)));
                } else {
                    String[] result = (String[])Arrays.stream(entries).filter(PropertyGroupMixin::embers_Rekindled$checkConf).toArray(String[]::new);
                    groups.add(new PropertyGroup(name, OreProperties.of((String[])result)));
                }
            }
        });
        return groups;
    }

    @Unique
    private static boolean embers_Rekindled$checkConf(String ore) {
        switch (ore) {
            case "embers_copper_ore": {
                return ConfigMaterial.COPPER.mustLoad();
            }
            case "embers_tin_ore": {
                return ConfigMaterial.TIN.mustLoad();
            }
            case "embers_lead_ore": {
                return ConfigMaterial.LEAD.mustLoad();
            }
            case "embers_silver_ore": {
                return ConfigMaterial.SILVER.mustLoad();
            }
            case "embers_nickel_ore": {
                return ConfigMaterial.NICKEL.mustLoad();
            }
            case "embers_aluminum_ore": {
                return ConfigMaterial.ALUMINUM.mustLoad();
            }
        }
        return false;
    }
}

