/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.crafttweaker.CTUtil;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenRegister
@ZenClass(value="mods.embers.Melter")
public class Melter {
    public static final String NAME = "Melter";
    public static final String CLASS = "mods.embers.Melter";

    @ZenMethod
    public static void add(ILiquidStack output, IIngredient input) {
        ItemMeltingRecipe recipe = new ItemMeltingRecipe(CTUtil.toIngredient(input), CraftTweakerMC.getLiquidStack((ILiquidStack)output));
        CraftTweaker.LATE_ACTIONS.add(new Add(recipe));
    }

    @ZenMethod
    public static void add(ILiquidStack output, IIngredient input, ILiquidStack bonus) {
        ItemMeltingRecipe recipe = new ItemMeltingRecipe(CTUtil.toIngredient(input), CraftTweakerMC.getLiquidStack((ILiquidStack)output)).addBonusOutput(CraftTweakerMC.getLiquidStack((ILiquidStack)bonus));
        CraftTweaker.LATE_ACTIONS.add(new Add(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveByInput(CraftTweakerMC.getItemStack((IItemStack)input)));
    }

    @ZenMethod
    public static void remove(ILiquidStack output) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveByOutput(CraftTweakerMC.getLiquidStack((ILiquidStack)output)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAll());
    }

    private static List<ItemMeltingRecipe> getRecipesByInput(ItemStack stack) {
        return RecipeRegistry.meltingRecipes.stream().filter(recipe -> recipe.input.apply(stack)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<ItemMeltingRecipe> getRecipesByOutput(FluidStack stack) {
        return RecipeRegistry.meltingRecipes.stream().filter(recipe -> stack.isFluidStackIdentical(recipe.getFluid())).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class RemoveAll
    implements IAction {
        protected RemoveAll() {
        }

        public void apply() {
            RecipeRegistry.meltingRecipes.clear();
        }

        public String describe() {
            return String.format("Removing all %s recipes", Melter.NAME);
        }
    }

    public static class RemoveByInput
    implements IAction {
        ItemStack input;

        protected RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            RecipeRegistry.meltingRecipes.removeAll(Melter.getRecipesByInput(this.input));
        }

        public String describe() {
            return String.format("Removing %s recipes with input: %s", Melter.NAME, this.input.toString());
        }
    }

    public static class RemoveByOutput
    implements IAction {
        FluidStack output;

        protected RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            RecipeRegistry.meltingRecipes.removeAll(Melter.getRecipesByOutput(this.output));
        }

        public String describe() {
            return String.format("Removing %s recipes with output: %s", Melter.NAME, this.output.toString());
        }
    }

    public static class Add
    implements IAction {
        ItemMeltingRecipe recipe;

        public Add(ItemMeltingRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRegistry.meltingRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", Melter.NAME, this.recipe.toString());
        }
    }
}

