/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.TileEntityReceiver;

public class BlockEmberReceiver
extends BlockTEBase {
    public static final PropertyDirection facing = PropertyDirection.create((String)"facing");

    public BlockEmberReceiver(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)facing)).getIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)EnumFacing.byIndex((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)face);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityReceiver();
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.isAirBlock(pos.offset((EnumFacing)state.getValue((IProperty)facing), -1))) {
            world.setBlockToAir(pos);
            this.dropBlockAsItem(world, pos, state, 0);
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.getValue((IProperty)facing)) {
            case UP: {
                return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
            }
            case DOWN: {
                return new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);
            }
            case NORTH: {
                return new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5);
            }
            case WEST: {
                return new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75);
            }
        }
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }
}

