/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityBoilerBottom;
import teamroots.embers.tileentity.TileEntityBoilerTop;

public class BlockBoiler
extends BlockTEBase {
    public static AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static AxisAlignedBB AABB_SIDE_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    public static AxisAlignedBB AABB_SIDE_EAST = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static AxisAlignedBB AABB_SIDE_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    public static AxisAlignedBB AABB_SIDE_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
    public static final PropertyBool isTop = PropertyBool.create((String)"top");

    public BlockBoiler(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        if (((Boolean)state.getValue((IProperty)isTop)).booleanValue()) {
            BlockBoiler.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_WEST);
            BlockBoiler.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_NORTH);
            BlockBoiler.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_EAST);
            BlockBoiler.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_SOUTH);
        } else {
            super.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn, b);
        }
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{isTop});
    }

    public int getMetaFromState(IBlockState state) {
        boolean top = (Boolean)state.getValue((IProperty)isTop);
        return top ? 1 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(meta == 1));
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (this.getMetaFromState(state) == 0) {
            world.setBlockState(pos.up(), this.getDefaultState().withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(true)));
        } else {
            world.setBlockState(pos.down(), this.getStateFromMeta(0));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if ((((Boolean)state.getValue((IProperty)isTop)).booleanValue() && world.getBlockState(pos.down()).getBlock() == this || !((Boolean)state.getValue((IProperty)isTop)).booleanValue() && world.getBlockState(pos.up()).getBlock() == this) && !world.isRemote && !player.capabilities.isCreativeMode) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (this.getMetaFromState(state) == 0) {
            world.setBlockToAir(pos.up());
        } else {
            world.setBlockToAir(pos.down());
        }
        ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, state, player);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        IBlockState state;
        if (!world.isRemote) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (this.getMetaFromState(state = world.getBlockState(pos)) == 0) {
            world.setBlockToAir(pos.up());
        } else {
            world.setBlockToAir(pos.down());
        }
        ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, state, null);
        world.setBlockToAir(pos);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return world.getBlockState(pos.up()) == Blocks.AIR.getDefaultState();
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        if (meta == 1) {
            return new TileEntityBoilerTop();
        }
        return new TileEntityBoilerBottom();
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((ITileEntityBase)world.getTileEntity(pos)).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }
}

