/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.TileEntityBeamSplitter;

public class BlockBeamSplitter
extends BlockTEBase {
    public static AxisAlignedBB AABB_UP = new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 1.0, 0.8125);
    public static AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.8125, 0.8125);
    public static final PropertyBool isXAligned = PropertyBool.create((String)"xaligned");
    public static final PropertyBool isConnectedUp = PropertyBool.create((String)"connectedup");

    public BlockBeamSplitter(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)state.getValue((IProperty)isConnectedUp)).booleanValue()) {
            return AABB_UP;
        }
        return AABB_DOWN;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{isXAligned, isConnectedUp});
    }

    public int getMetaFromState(IBlockState state) {
        if (((Boolean)state.getValue((IProperty)isXAligned)).booleanValue() && ((Boolean)state.getValue((IProperty)isConnectedUp)).booleanValue()) {
            return 3;
        }
        if (((Boolean)state.getValue((IProperty)isXAligned)).booleanValue() && !((Boolean)state.getValue((IProperty)isConnectedUp)).booleanValue()) {
            return 2;
        }
        if (!((Boolean)state.getValue((IProperty)isXAligned)).booleanValue() && ((Boolean)state.getValue((IProperty)isConnectedUp)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || side == EnumFacing.DOWN;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.getDefaultState();
        state = placer.getHorizontalFacing() == EnumFacing.EAST || placer.getHorizontalFacing() == EnumFacing.WEST ? state.withProperty((IProperty)isXAligned, (Comparable)Boolean.valueOf(true)) : state.withProperty((IProperty)isXAligned, (Comparable)Boolean.valueOf(false));
        state = face == EnumFacing.DOWN ? state.withProperty((IProperty)isConnectedUp, (Comparable)Boolean.valueOf(true)) : state.withProperty((IProperty)isConnectedUp, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta == 3) {
            return this.getDefaultState().withProperty((IProperty)isXAligned, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)isConnectedUp, (Comparable)Boolean.valueOf(true));
        }
        if (meta == 2) {
            return this.getDefaultState().withProperty((IProperty)isXAligned, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)isConnectedUp, (Comparable)Boolean.valueOf(false));
        }
        if (meta == 1) {
            return this.getDefaultState().withProperty((IProperty)isXAligned, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)isConnectedUp, (Comparable)Boolean.valueOf(true));
        }
        return this.getDefaultState().withProperty((IProperty)isXAligned, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)isConnectedUp, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityBeamSplitter();
    }
}

