/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.alchemy;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import teamroots.embers.tileentity.TileEntityAlchemyPedestal;
import teamroots.embers.util.AlchemyUtil;

public class AspectList {
    HashMap<String, Integer> aspectList = new HashMap();

    public AspectList() {
    }

    public AspectList(HashMap<String, Integer> map) {
        this.aspectList.putAll(map);
    }

    public void addAspect(String aspect, int amount) {
        this.aspectList.put(aspect, this.getAspect(aspect) + amount);
    }

    public void removeAspect(String aspect, int amount) {
        this.aspectList.put(aspect, Math.max(0, this.getAspect(aspect) - amount));
    }

    public void setAspect(String aspect, int amount) {
        this.aspectList.put(aspect, amount);
    }

    public int getAspect(String aspect) {
        return this.aspectList.getOrDefault(aspect, 0);
    }

    public boolean hasAspect(String aspect) {
        return this.aspectList.containsKey(aspect);
    }

    public Collection<String> getAspects() {
        return this.aspectList.keySet();
    }

    public int getTotal() {
        int total = 0;
        for (int aspectAmt : this.aspectList.values()) {
            total += aspectAmt;
        }
        return total;
    }

    public void reset() {
        this.aspectList.clear();
    }

    public void collect(List<TileEntityAlchemyPedestal> pedestals) {
        for (TileEntityAlchemyPedestal pedestal : pedestals) {
            ItemStack aspect = pedestal.inventory.getStackInSlot(1);
            ItemStack ash = pedestal.inventory.getStackInSlot(0);
            this.addAspect(AlchemyUtil.getAspect(aspect), ash.getCount());
        }
    }

    public void deserializeNBT(NBTTagCompound compound) {
        compound.getKeySet().stream().filter(key -> compound.hasKey(key, 99)).forEach(key -> this.aspectList.put((String)key, compound.getInteger(key)));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry<String, Integer> entry : this.aspectList.entrySet()) {
            compound.setInteger(entry.getKey(), entry.getValue().intValue());
        }
        return compound;
    }

    public static AspectList createStandard(int iron, int dawnstone, int copper, int silver, int lead) {
        AspectList rList = new AspectList();
        rList.setAspect("iron", iron);
        rList.setAspect("dawnstone", dawnstone);
        rList.setAspect("copper", copper);
        rList.setAspect("silver", silver);
        rList.setAspect("lead", lead);
        return rList;
    }

    public static class AspectRangeList {
        AspectList minAspects;
        AspectList maxAspects;
        Random random = new Random();
        int seedOffset;
        boolean fixMath;

        public AspectList getMinAspects() {
            return this.minAspects;
        }

        public AspectList getMaxAspects() {
            return this.maxAspects;
        }

        public boolean isEmpty() {
            return this.minAspects.getTotal() == 0 && this.maxAspects.getTotal() == 0;
        }

        public AspectRangeList() {
            this.minAspects = new AspectList();
            this.maxAspects = new AspectList();
        }

        public AspectRangeList(AspectList min, AspectList max) {
            this.minAspects = min;
            this.maxAspects = max;
        }

        public AspectRangeList setRange(String aspect, int min, int max) {
            this.minAspects.setAspect(aspect, min);
            this.maxAspects.setAspect(aspect, max);
            return this;
        }

        public AspectRangeList setSeedOffset(int offset) {
            this.seedOffset = offset;
            return this;
        }

        public AspectRangeList fixMathematicalError() {
            this.fixMath = true;
            return this;
        }

        public int getMin(String aspect) {
            return this.minAspects.getAspect(aspect);
        }

        public int getMax(String aspect) {
            return this.maxAspects.getAspect(aspect);
        }

        public int getRange(String aspect) {
            return this.getMax(aspect) - this.getMin(aspect);
        }

        public int getExact(String aspect, World world) {
            this.random.setSeed(world.getSeed() + (long)this.seedOffset + (long)(this.fixMath ? aspect.hashCode() : 0));
            int min = this.minAspects.getAspect(aspect);
            int max = this.maxAspects.getAspect(aspect);
            int range = max - min;
            return min + this.random.nextInt(range + 1);
        }
    }
}

