/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mysticalmechanics.api.GearHelper;
import mysticalmechanics.api.GearHelperTile;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearbox;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockMechActuator;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeActuator;
import teamroots.embers.util.ConsumerMechCapability;
import teamroots.embers.util.Misc;

public class TileEntityMechActuator
extends TileEntity
implements ITickable,
ITileEntityBase,
IGearbox,
IExtraCapabilityInformation {
    public UpgradeActuator upgrade;
    public GearHelperTile[] gears = new GearHelperTile[6];
    public boolean shouldUpdate;
    private Random random = new Random();
    public ConsumerMechCapability capability = new ConsumerMechCapability(){

        @Override
        public void onPowerChange() {
            TileEntityMechActuator box = TileEntityMechActuator.this;
            TileEntityMechActuator.this.shouldUpdate = true;
            box.func_70296_d();
        }

        public double getVisualPower(EnumFacing from) {
            GearHelper gearHelper = TileEntityMechActuator.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            double unchangedPower = this.getExternalPower(from);
            if (gearHelper == null) {
                return unchangedPower;
            }
            IGearBehavior behavior = gearHelper.getBehavior();
            return behavior.transformVisualPower((TileEntity)TileEntityMechActuator.this, from, gearHelper.getGear(), gearHelper.getData(), unchangedPower);
        }

        @Override
        public double getPower(EnumFacing from) {
            GearHelper gearHelper = TileEntityMechActuator.this.getGearHelper(from);
            if (gearHelper != null && gearHelper.isEmpty()) {
                return 0.0;
            }
            return super.getPower(from);
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            GearHelper gearHelper = TileEntityMechActuator.this.getGearHelper(from);
            if (this.isInput(from) && gearHelper.isEmpty()) {
                super.setPower(0.0, from);
            }
            if (this.isInput(from)) {
                this.powerExternal[from.func_176745_a()] = value;
                if (!gearHelper.isEmpty()) {
                    IGearBehavior behavior = gearHelper.getBehavior();
                    value = behavior.transformPower((TileEntity)TileEntityMechActuator.this, from, gearHelper.getGear(), gearHelper.getData(), value);
                    super.setPower(value, from);
                }
            }
        }

        public boolean isInput(EnumFacing from) {
            return TileEntityMechActuator.this.canAttachGear(from);
        }
    };

    private GearHelper getGearHelper(EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        return this.gears[facing.func_176745_a()];
    }

    public TileEntityMechActuator() {
        this.upgrade = new UpgradeActuator(this);
        for (int i = 0; i < this.gears.length; ++i) {
            this.gears[i] = new GearHelperTile((TileEntity)this, EnumFacing.func_82600_a((int)i));
        }
        this.capability.setAdditive(true);
    }

    public void updateNeighbors() {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            MysticalMechanicsAPI.IMPL.pullPower((TileEntity)this, f, (IMechCapability)this.capability, !this.getGear(f).func_190926_b());
        }
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int i;
        super.func_189515_b(tag);
        for (i = 0; i < 6; ++i) {
            tag.func_74782_a("side" + i, (NBTBase)this.gears[i].writeToNBT(new NBTTagCompound()));
        }
        this.capability.writeToNBT(tag);
        for (i = 0; i < 6; ++i) {
            tag.func_74780_a("mech_power" + i, this.capability.power[i]);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        for (i = 0; i < 6; ++i) {
            this.gears[i].readFromNBT(tag.func_74775_l("side" + i));
        }
        this.readLegacyGears(tag);
        for (i = 0; i < 6; ++i) {
            this.capability.power[i] = tag.func_74769_h("mech_power" + i);
        }
        this.capability.readFromNBT(tag);
        this.capability.markDirty();
    }

    private void readLegacyGears(NBTTagCompound tag) {
        for (int i = 0; i < 6; ++i) {
            if (!tag.func_74764_b("gear" + i)) continue;
            this.gears[i].setGear(new ItemStack(tag.func_74775_l("gear" + i)));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockMechActuator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMechActuator.facing);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing().func_176734_d() == facing;
        }
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return facing == null || this.canAttachGear(facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().func_176734_d() == facing) {
            return (T)this.upgrade;
        }
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY && (facing == null || this.canAttachGear(facing))) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    private double getGearInPower(EnumFacing facing) {
        return this.capability.getExternalPower(facing);
    }

    private double getGearOutPower(EnumFacing facing) {
        return this.capability.getInternalPower(facing);
    }

    public void func_73660_a() {
        if (this.shouldUpdate) {
            this.updateNeighbors();
            this.shouldUpdate = false;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int i = facing.func_176745_a();
            if (this.field_145850_b.field_72995_K) {
                this.gears[i].visualUpdate(this.getGearInPower(facing), this.capability.getVisualPower(facing));
            }
            this.gears[i].tick(this.getGearInPower(facing), this.getGearOutPower(facing));
            if (!this.gears[i].isDirty()) continue;
            this.shouldUpdate = true;
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && this.canAttachGear(side, heldItem)) {
            if (this.getGear(side).func_190926_b() && MysticalMechanicsAPI.IMPL.isValidGear(heldItem)) {
                ItemStack gear = heldItem.func_77946_l();
                gear.func_190920_e(1);
                this.attachGear(side, gear, player);
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                this.capability.onPowerChange();
                return true;
            }
        } else if (!this.getGear(side).func_190926_b()) {
            ItemStack gear = this.detachGear(side, player);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, gear));
            }
            this.capability.onPowerChange();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.gears[i].detach(player);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        }
        this.capability.setPower(0.0, null);
        this.updateNeighbors();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public void attachGear(EnumFacing facing, ItemStack stack, @Nullable EntityPlayer player) {
        if (!this.canAttachGear(facing)) {
            return;
        }
        this.gears[facing.func_176745_a()].attach(player, stack);
        this.func_70296_d();
    }

    public ItemStack detachGear(EnumFacing facing, @Nullable EntityPlayer player) {
        if (!this.canAttachGear(facing)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.gears[facing.func_176745_a()].detach(player);
        this.func_70296_d();
        return stack;
    }

    public ItemStack getGear(EnumFacing facing) {
        if (!this.canAttachGear(facing)) {
            return ItemStack.field_190927_a;
        }
        return this.gears[facing.func_176745_a()].getGear();
    }

    public boolean canAttachGear(EnumFacing facing, ItemStack stack) {
        return this.canAttachGear(facing);
    }

    public boolean canAttachGear(EnumFacing facing) {
        return facing != null && this.getFacing().func_176740_k() != facing.func_176740_k();
    }

    public int getConnections() {
        return 1;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return false;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
    }
}

