/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.particle.ParticleUtil;

public class MessageAshenAmuletFX
implements IMessage {
    public static Random random = new Random();
    Integer entityID;
    AxisAlignedBB aabb;

    public MessageAshenAmuletFX() {
    }

    public MessageAshenAmuletFX(Entity entity) {
        this.entityID = entity.func_145782_y();
    }

    public MessageAshenAmuletFX(BlockPos pos) {
        this.aabb = new AxisAlignedBB(pos);
    }

    public MessageAshenAmuletFX(AxisAlignedBB aabb) {
        this.aabb = aabb;
    }

    private int getType() {
        if (this.aabb != null == (this.entityID != null)) {
            return 0;
        }
        if (this.aabb != null) {
            return 1;
        }
        return 2;
    }

    public void fromBytes(ByteBuf buf) {
        int type = buf.readInt();
        switch (type) {
            case 1: {
                double minX = buf.readDouble();
                double minY = buf.readDouble();
                double minZ = buf.readDouble();
                double maxX = buf.readDouble();
                double maxY = buf.readDouble();
                double maxZ = buf.readDouble();
                this.aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
                return;
            }
            case 2: {
                this.entityID = buf.readInt();
                return;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        int type = this.getType();
        buf.writeInt(type);
        switch (type) {
            case 1: {
                buf.writeDouble(this.aabb.field_72340_a);
                buf.writeDouble(this.aabb.field_72338_b);
                buf.writeDouble(this.aabb.field_72339_c);
                buf.writeDouble(this.aabb.field_72336_d);
                buf.writeDouble(this.aabb.field_72337_e);
                buf.writeDouble(this.aabb.field_72334_f);
                return;
            }
            case 2: {
                buf.writeInt(this.entityID.intValue());
                return;
            }
        }
    }

    public static class MessageHolder
    implements IMessageHandler<MessageAshenAmuletFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageAshenAmuletFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            Minecraft.func_71410_x().func_152344_a(() -> MessageHolder.lambda$onMessage$0(message, (World)world));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(MessageAshenAmuletFX message, World world) {
            switch (message.getType()) {
                case 1: {
                    ParticleUtil.spawnParticleAsh(world, message.aabb, 20);
                    return;
                }
                case 2: {
                    Entity entity = world.func_73045_a(message.entityID.intValue());
                    if (entity != null) {
                        ParticleUtil.spawnParticleAsh(world, entity, 20);
                    }
                    return;
                }
            }
        }
    }
}

