/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import teamroots.embers.SoundManager;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.item.IProjectileWeapon;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.api.projectile.ProjectileRay;
import teamroots.embers.config.ConfigTool;
import teamroots.embers.damage.DamageEmber;
import teamroots.embers.item.ItemBase;
import teamroots.embers.util.EmberInventoryUtil;

public class ItemIgnitionCannon
extends ItemBase
implements IProjectileWeapon {
    public static double EMBER_COST = ConfigTool.BLAZING_RAY.cost;
    public static int COOLDOWN = ConfigTool.BLAZING_RAY.cooldown;
    public static double MAX_CHARGE = ConfigTool.BLAZING_RAY.charge;
    public static float DAMAGE = ConfigTool.BLAZING_RAY.damage;
    public static double MAX_SPREAD = ConfigTool.BLAZING_RAY.spread;
    public static float MAX_DISTANCE = ConfigTool.BLAZING_RAY.distance;

    public ItemIgnitionCannon() {
        super("ignition_cannon", true);
        this.func_77625_d(1);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            double charge = Math.min(MAX_CHARGE, (double)(this.func_77626_a(stack) - timeLeft)) / MAX_CHARGE;
            double handmod = entity.func_184600_cs() == EnumHand.MAIN_HAND ? 1.0 : -1.0;
            double posX = entity.field_70165_t + entity.func_70040_Z().field_72450_a + (handmod *= entity.func_184591_cq() == EnumHandSide.RIGHT ? 1.0 : -1.0) * ((double)entity.field_70130_N / 2.0) * Math.sin(Math.toRadians(-entity.field_70177_z - 90.0f));
            double posY = entity.field_70163_u + (double)entity.func_70047_e() - 0.2 + entity.func_70040_Z().field_72448_b;
            double posZ = entity.field_70161_v + entity.func_70040_Z().field_72449_c + handmod * ((double)entity.field_70130_N / 2.0) * Math.cos(Math.toRadians(-entity.field_70177_z - 90.0f));
            double targX = entity.field_70165_t + entity.func_70040_Z().field_72450_a * (double)MAX_DISTANCE + MAX_SPREAD * (1.0 - charge) * ((double)field_77697_d.nextFloat() - 0.5);
            double targY = entity.field_70163_u + entity.func_70040_Z().field_72448_b * (double)MAX_DISTANCE + MAX_SPREAD * (1.0 - charge) * ((double)field_77697_d.nextFloat() - 0.5);
            double targZ = entity.field_70161_v + entity.func_70040_Z().field_72449_c * (double)MAX_DISTANCE + MAX_SPREAD * (1.0 - charge) * ((double)field_77697_d.nextFloat() - 0.5);
            EffectDamage effect = new EffectDamage(DAMAGE, DamageEmber.EMBER_DAMAGE_SOURCE_FACTORY, 1, 1.0);
            ProjectileRay ray = new ProjectileRay((Entity)entity, new Vec3d(posX, posY, posZ), new Vec3d(targX, targY, targZ), false, effect);
            EmberProjectileEvent event = new EmberProjectileEvent(entity, stack, charge, ray);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                for (IProjectilePreset projectile : event.getProjectiles()) {
                    projectile.shoot(world);
                }
            }
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundManager.BLAZING_RAY_FIRE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        stack.func_77978_p().func_74768_a("cooldown", COOLDOWN);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("cooldown", 0);
        } else if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
            stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77978_p().func_74762_e("cooldown") <= 0 || player.field_71075_bZ.field_75098_d) {
            if (EmberInventoryUtil.getEmberTotal(player) >= EMBER_COST || player.field_71075_bZ.field_75098_d) {
                EmberInventoryUtil.removeEmber(player, EMBER_COST);
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundManager.BLAZING_RAY_EMPTY, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

