/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSparkleFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.Misc;

public class EntityEmberPacket
extends Entity {
    BlockPos pos = new BlockPos(0, 0, 0);
    public BlockPos dest = new BlockPos(0, 0, 0);
    public double value = 0.0;
    public int lifetime = 80;
    public float hue = Misc.random.nextFloat() * 360.0f;
    public boolean dead = false;

    public EntityEmberPacket(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.0f, 0.0f);
        this.func_82142_c(true);
    }

    public void initCustom(BlockPos pos, BlockPos dest, double vx, double vy, double vz, double value) {
        this.field_70165_t = (double)pos.func_177958_n() + 0.5;
        this.field_70163_u = (double)pos.func_177956_o() + 0.5;
        this.field_70161_v = (double)pos.func_177952_p() + 0.5;
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.dest = dest;
        this.pos = pos;
        this.value = value;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("destX")) {
            this.dest = new BlockPos(compound.func_74762_e("destX"), compound.func_74762_e("destY"), compound.func_74762_e("destZ"));
            this.func_70107_b(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z"));
            this.value = compound.func_74769_h("value");
            this.field_70159_w = compound.func_74769_h("vx");
            this.field_70181_x = compound.func_74769_h("vy");
            this.field_70179_y = compound.func_74769_h("vz");
            this.dead = compound.func_74767_n("dead");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.dest != null) {
            compound.func_74768_a("destX", this.dest.func_177958_n());
            compound.func_74768_a("destY", this.dest.func_177956_o());
            compound.func_74768_a("destZ", this.dest.func_177952_p());
        }
        compound.func_74780_a("x", this.field_70165_t);
        compound.func_74780_a("y", this.field_70163_u);
        compound.func_74780_a("z", this.field_70161_v);
        compound.func_74780_a("value", this.value);
        compound.func_74780_a("vx", this.field_70159_w);
        compound.func_74780_a("vy", this.field_70181_x);
        compound.func_74780_a("vz", this.field_70179_y);
        compound.func_74757_a("dead", this.dead);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lifetime == 79 && !this.func_130014_f_().field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSparkleFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, false));
        }
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.dead = true;
            this.func_130014_f_().func_72900_e((Entity)this);
        }
        if (!this.dead) {
            if (this.dest.func_177958_n() != 0 || this.dest.func_177956_o() != 0 || this.dest.func_177952_p() != 0) {
                double targetX = (double)this.dest.func_177958_n() + 0.5;
                double targetY = (double)this.dest.func_177956_o() + 0.5;
                double targetZ = (double)this.dest.func_177952_p() + 0.5;
                Vec3d targetVector = new Vec3d(targetX - this.field_70165_t, targetY - this.field_70163_u, targetZ - this.field_70161_v);
                double length = targetVector.func_72433_c();
                targetVector = targetVector.func_186678_a(0.3 / length);
                double weight = 0.0;
                if (length <= 3.0) {
                    weight = 0.9 * ((3.0 - length) / 3.0);
                }
                this.field_70159_w = (0.9 - weight) * this.field_70159_w + (0.1 + weight) * targetVector.field_72450_a;
                this.field_70181_x = (0.9 - weight) * this.field_70181_x + (0.1 + weight) * targetVector.field_72448_b;
                this.field_70179_y = (0.9 - weight) * this.field_70179_y + (0.1 + weight) * targetVector.field_72449_c;
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            IBlockState state = this.func_130014_f_().func_180495_p(this.func_180425_c());
            TileEntity tile = this.func_130014_f_().func_175625_s(this.func_180425_c());
            BlockPos pos = this.func_180425_c();
            if (this.field_70165_t > (double)pos.func_177958_n() + 0.25 && this.field_70165_t < (double)pos.func_177958_n() + 0.75 && this.field_70163_u > (double)pos.func_177956_o() + 0.25 && this.field_70163_u < (double)pos.func_177956_o() + 0.75 && this.field_70161_v > (double)pos.func_177952_p() + 0.25 && this.field_70161_v < (double)pos.func_177952_p() + 0.75) {
                this.affectTileEntity(state, tile);
            }
            if (this.func_130014_f_().field_72995_K) {
                double deltaX = this.field_70165_t - this.field_70169_q;
                double deltaY = this.field_70163_u - this.field_70167_r;
                double deltaZ = this.field_70161_v - this.field_70166_s;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
                for (double i = 0.0; i < dist; i += 1.0) {
                    double coeff = i / dist;
                    ParticleUtil.spawnParticleGlow(this.func_130014_f_(), (float)(this.field_70169_q + deltaX * coeff), (float)(this.field_70167_r + deltaY * coeff), (float)(this.field_70166_s + deltaZ * coeff), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 2.0f, 12);
                }
            }
        }
    }

    public void affectTileEntity(IBlockState state, TileEntity tile) {
        if (tile instanceof IEmberPacketReceiver && ((IEmberPacketReceiver)tile).onReceive(this) && tile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            assert (capability != null);
            if (!this.func_130014_f_().field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSparkleFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, capability.getEmber() + this.value > capability.getEmberCapacity()));
            }
            capability.addAmount(this.value, true);
            tile.func_70296_d();
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.lifetime = 20;
            this.dead = true;
            this.func_130014_f_().func_72900_e((Entity)this);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.value >= 100.0 ? SoundManager.EMBER_RECEIVE_BIG : SoundManager.EMBER_RECEIVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

