/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.api.documentation.annotations.Comp;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.MethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.Property;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderMethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderRegistrationMethod;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import groovyjarjarantlr4.v4.runtime.misc.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import teamroots.embers.compat.groovyscript.GSPlugin;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@RegistryDescription(linkGenerator="embers")
class Stamper
extends VirtualizedRegistry<ItemStampingRecipe> {
    Stamper() {
    }

    @RecipeBuilderDescription(example={@Example(value=".stamp(item('minecraft:clay')).fluidInput(fluid('water') * 100).output(item('minecraft:brick'))"), @Example(value=".input(item('minecraft:gravel')).stamp(item('minecraft:flint')).output(item('minecraft:glass'))")})
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        RecipeRegistry.stampingRecipes.removeAll(this.removeScripted());
        RecipeRegistry.stampingRecipes.addAll(this.restoreFromBackup());
    }

    public void add(ItemStampingRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            RecipeRegistry.stampingRecipes.add(recipe);
        }
    }

    public boolean remove(ItemStampingRecipe recipe) {
        if (RecipeRegistry.stampingRecipes.removeIf(r -> r == recipe)) {
            this.addBackup(recipe);
            return true;
        }
        return false;
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="item('embers:shard_ember')")})
    public boolean removeByInput(IIngredient input) {
        return RecipeRegistry.stampingRecipes.removeIf(r -> {
            if (Arrays.stream(r.input.func_193365_a()).anyMatch((Predicate<ItemStack>)input)) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="item('embers:plate_iron')"), @Example(value="item('embers:dust_ash')", commented=true)})
    public boolean removeByOutput(IIngredient output) {
        return RecipeRegistry.stampingRecipes.removeIf(r -> {
            if (output.test((Object)r.getOutputs().get(0))) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.QUERY)
    public SimpleObjectStream<ItemStampingRecipe> streamRecipes() {
        return new SimpleObjectStream(RecipeRegistry.stampingRecipes).setRemover(this::remove);
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, priority=2000, example={@Example(commented=true)})
    public void removeAll() {
        RecipeRegistry.stampingRecipes.forEach(arg_0 -> ((Stamper)this).addBackup(arg_0));
        RecipeRegistry.stampingRecipes.clear();
    }

    @Property.Properties(value={@Property(property="input", valid={@Comp(value="0", type=Comp.Type.GTE), @Comp(value="1", type=Comp.Type.LTE)}), @Property(property="fluidInput", valid={@Comp(value="0", type=Comp.Type.GTE), @Comp(value="1", type=Comp.Type.LTE)}), @Property(property="output", valid={@Comp(value="1")})})
    public static class RecipeBuilder
    extends AbstractRecipeBuilder<ItemStampingRecipe> {
        @Property(defaultValue="IIngredient.EMPTY", requirement="groovyscript.wiki.embers.stamper.stamp.required")
        private IIngredient stamp = IIngredient.EMPTY;

        @RecipeBuilderMethodDescription(field={"stamp"})
        public RecipeBuilder stamp(IIngredient stamp) {
            this.stamp = stamp;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Embers Stamper recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 0, 1, 1, 1);
            this.validateFluids(msg, 0, 1, 0, 0);
            msg.add(IngredientHelper.isEmpty((IIngredient)this.stamp), "stamp is required", new Object[0]);
        }

        @RecipeBuilderRegistrationMethod
        @Nullable
        public ItemStampingRecipe register() {
            if (!this.validate()) {
                return null;
            }
            ItemStampingRecipe recipe = IngredientHelper.isEmpty((Collection)this.input) ? new ItemStampingRecipe(Ingredient.field_193370_a, this.fluidInput.getOrEmpty(0), this.stamp.toMcIngredient(), (ItemStack)this.output.get(0)) : new ItemStampingRecipe(((IIngredient)this.input.get(0)).toMcIngredient(), this.fluidInput.getOrEmpty(0), this.stamp.toMcIngredient(), (ItemStack)this.output.get(0));
            GSPlugin.instance.stamper.add(recipe);
            return recipe;
        }
    }
}

