/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.api.documentation.annotations.Comp;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.MethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.Property;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderRegistrationMethod;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import groovyjarjarantlr4.v4.runtime.misc.Nullable;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import teamroots.embers.compat.groovyscript.GSPlugin;
import teamroots.embers.recipe.HeatCoilRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@RegistryDescription(linkGenerator="embers")
public class HeatCoil
extends VirtualizedRegistry<HeatCoilRecipe> {
    @RecipeBuilderDescription(example={@Example(value=".input(item('minecraft:clay')).output(item('minecraft:gravel'))"), @Example(value=".input(item('minecraft:gravel')).output(item('minecraft:grass'))")})
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        RecipeRegistry.heatCoilRecipes.removeAll(this.removeScripted());
        RecipeRegistry.heatCoilRecipes.addAll(this.restoreFromBackup());
    }

    public void add(HeatCoilRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            RecipeRegistry.heatCoilRecipes.add(recipe);
        }
    }

    public boolean remove(HeatCoilRecipe recipe) {
        if (RecipeRegistry.heatCoilRecipes.removeIf(r -> r == recipe)) {
            this.addBackup(recipe);
            return true;
        }
        return false;
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="item('minecraft:iron_ore')")})
    public boolean removeByInput(IIngredient input) {
        return RecipeRegistry.heatCoilRecipes.removeIf(r -> {
            if (Arrays.stream(r.getInput().func_193365_a()).anyMatch((Predicate<ItemStack>)input)) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="item('minecraft:iron_ingot')"), @Example(value="item('minecraft:glass')", commented=true)})
    public boolean removeByOutput(IIngredient output) {
        return RecipeRegistry.heatCoilRecipes.removeIf(r -> {
            if (output.test((Object)r.getOutput())) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.QUERY)
    public SimpleObjectStream<HeatCoilRecipe> streamRecipes() {
        return new SimpleObjectStream(RecipeRegistry.heatCoilRecipes).setRemover(this::remove);
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, priority=2000, example={@Example(commented=true)})
    public void removeAll() {
        RecipeRegistry.heatCoilRecipes.forEach(arg_0 -> ((HeatCoil)this).addBackup(arg_0));
        RecipeRegistry.heatCoilRecipes.clear();
    }

    @Property.Properties(value={@Property(property="input", valid={@Comp(value="1")}), @Property(property="output", valid={@Comp(value="1")})})
    public static class RecipeBuilder
    extends AbstractRecipeBuilder<HeatCoilRecipe> {
        public String getErrorMsg() {
            return "Error adding Embers Heat Coil recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 1, 1, 1);
            this.validateFluids(msg);
        }

        @RecipeBuilderRegistrationMethod
        @Nullable
        public HeatCoilRecipe register() {
            if (!this.validate()) {
                return null;
            }
            HeatCoilRecipe recipe = new HeatCoilRecipe((ItemStack)this.output.get(0), ((IIngredient)this.input.get(0)).toMcIngredient());
            GSPlugin.instance.heatcoil.add(recipe);
            return recipe;
        }
    }
}

