/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearData;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.handler.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockMechActuator;
import teamroots.embers.block.BlockMechActuatorSingle;
import teamroots.embers.block.BlockSteamEngine;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.config.ConfigMaterial;
import teamroots.embers.item.ItemBase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.register.FluidRegister;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.register.TileEntityRegister;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchManager;
import teamroots.embers.research.subtypes.ResearchFakePage;
import teamroots.embers.research.subtypes.ResearchShowItem;
import teamroots.embers.tileentity.TileEntityMechActuator;
import teamroots.embers.tileentity.TileEntityMechActuatorRenderer;
import teamroots.embers.tileentity.TileEntityMechActuatorSingle;
import teamroots.embers.tileentity.TileEntitySteamEngine;
import teamroots.embers.util.Misc;

public class MysticalMechanicsIntegration {
    public static final ResourceLocation IRON_GEAR_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_iron");
    public static final ResourceLocation GOLD_GEAR_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_gold");
    public static final ResourceLocation GOLD_GEAR_ON_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_gold_on");
    public static final ResourceLocation GOLD_GEAR_OFF_BEHAVIOR = new ResourceLocation("mysticalmechanics", "gear_gold_off");
    public static final ResourceLocation DAWNSTONE_GEAR_BEHAVIOR = new ResourceLocation("embers", "gear_dawnstone");
    public static final double IRON_GEAR_MAX_POWER = 80.0;
    public static final double GOLD_GEAR_MAX_POWER = 320.0;
    public static final Item GEAR_DAWNSTONE = new ItemBase("gear_dawnstone", true);
    public static final Block STEAM_ENGINE = new BlockSteamEngine(Material.field_151576_e, "steam_engine", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
    public static final Block MECH_ACTUATOR = new BlockMechActuator(Material.field_151576_e, "mech_actuator", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
    public static final Block MECH_ACTUATOR_SINGLE = new BlockMechActuatorSingle(Material.field_151576_e, "mech_actuator_single", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.0f);
    static Random random = new Random();

    public static ResourceLocation getRL(String s) {
        return new ResourceLocation("embers", s);
    }

    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Block axle_iron = Block.func_149684_b((String)"mysticalmechanics:axle_iron");
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("gear_dawnstone"), new ItemStack(GEAR_DAWNSTONE, 1), new Object[]{true, new Object[]{" N ", "NCN", " N ", Character.valueOf('C'), "nuggetDawnstone", Character.valueOf('N'), "ingotDawnstone"}}).setRegistryName(MysticalMechanicsIntegration.getRL("gear_dawnstone")));
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("mech_actuator_single"), new ItemStack(MECH_ACTUATOR_SINGLE, 1), new Object[]{true, new Object[]{"SPI", Character.valueOf('P'), "gearIron", Character.valueOf('S'), BlockRegister.MECH_ACCESSOR, Character.valueOf('I'), axle_iron}}).setRegistryName(MysticalMechanicsIntegration.getRL("mech_actuator_single")));
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("mech_actuator"), new ItemStack(MECH_ACTUATOR, 1), new Object[]{true, new Object[]{" I ", "IPI", "SI ", Character.valueOf('P'), "gearIron", Character.valueOf('S'), BlockRegister.MECH_ACCESSOR, Character.valueOf('I'), axle_iron}}).setRegistryName(MysticalMechanicsIntegration.getRL("mech_actuator")));
        event.getRegistry().register(new ShapedOreRecipe(MysticalMechanicsIntegration.getRL("steam_engine"), new ItemStack(STEAM_ENGINE, 1), new Object[]{true, new Object[]{" II", "APC", "FFC", Character.valueOf('C'), "plateCopper", Character.valueOf('P'), "gearIron", Character.valueOf('A'), axle_iron, Character.valueOf('I'), BlockRegister.PIPE, Character.valueOf('F'), "plateIron"}}).setRegistryName(MysticalMechanicsIntegration.getRL("steam_engine")));
        Ingredient stampGear = Ingredient.func_193367_a((Item)ItemRegister.STAMP_GEAR);
        int gearAmount = ConfigMachine.STAMPER.stampGearAmount * RecipeRegistry.INGOT_AMOUNT;
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, new FluidStack(FluidRegister.FLUID_MOLTEN_IRON, gearAmount), stampGear, new ItemStack(RegistryHandler.IRON_GEAR, 1)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, new FluidStack(FluidRegister.FLUID_MOLTEN_GOLD, gearAmount), stampGear, new ItemStack(RegistryHandler.GOLD_GEAR, 1)));
        RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(Ingredient.field_193370_a, new FluidStack(FluidRegister.FLUID_MOLTEN_DAWNSTONE, gearAmount), stampGear, new ItemStack(GEAR_DAWNSTONE, 1)));
    }

    public static void registerAll() {
        if (ConfigMaterial.DAWNSTONE.isNotOff()) {
            ItemRegister.INSTANCE.add(GEAR_DAWNSTONE);
        }
        BlockRegister.INSTANCE.add(STEAM_ENGINE);
        BlockRegister.INSTANCE.add(MECH_ACTUATOR);
        BlockRegister.INSTANCE.add(MECH_ACTUATOR_SINGLE);
        TileEntityRegister.register(TileEntitySteamEngine.class, "tile_entity_steam_engine");
        TileEntityRegister.register(TileEntityMechActuator.class, "tile_entity_mech_actuator");
        TileEntityRegister.register(TileEntityMechActuatorSingle.class, "tile_entity_mech_actuator_single");
    }

    public static void initOreDict() {
        if (ConfigMaterial.DAWNSTONE.isNotOff()) {
            OreDictionary.registerOre((String)"gearDawnstone", (Item)GEAR_DAWNSTONE);
        }
    }

    public static void init() {
        if (ConfigMaterial.DAWNSTONE.isNotOff()) {
            MysticalMechanicsAPI.IMPL.registerGear(DAWNSTONE_GEAR_BEHAVIOR, (Ingredient)new OreIngredient("gearDawnstone"), new IGearBehavior(){

                public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
                    return power;
                }

                public void visualUpdate(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
                    int particles = Math.min((int)Math.ceil(powerIn / 40.0), 5);
                    if (powerIn >= 80.0) {
                        for (int i = 0; i < particles; ++i) {
                            float xOff = 0.1f + random.nextFloat() * 0.8f;
                            float yOff = 0.1f + random.nextFloat() * 0.8f;
                            float zOff = 0.1f + random.nextFloat() * 0.8f;
                            switch (facing.func_176740_k()) {
                                case X: {
                                    xOff = 0.5f + (float)facing.func_82601_c() / 2.0f;
                                    break;
                                }
                                case Y: {
                                    yOff = 0.5f + (float)facing.func_96559_d() / 2.0f;
                                    break;
                                }
                                case Z: {
                                    zOff = 0.5f + (float)facing.func_82599_e() / 2.0f;
                                }
                            }
                            ParticleUtil.spawnParticleGlow(tile.func_145831_w(), (float)tile.func_174877_v().func_177958_n() + xOff, (float)tile.func_174877_v().func_177956_o() + yOff, (float)tile.func_174877_v().func_177952_p() + zOff, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                        }
                    }
                }
            });
        }
        MysticalMechanicsIntegration.replaceBehavior(IRON_GEAR_BEHAVIOR, (Ingredient)new OreIngredient("gearIron"), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 80.0, 1.0));
        MysticalMechanicsIntegration.replaceBehavior(GOLD_GEAR_BEHAVIOR, (Ingredient)new OreIngredient("gearGold"), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 320.0, 1.0));
        MysticalMechanicsIntegration.replaceBehavior(GOLD_GEAR_ON_BEHAVIOR, Ingredient.func_193367_a((Item)RegistryHandler.GOLD_GEAR_ON), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 320.0, 1.0));
        MysticalMechanicsIntegration.replaceBehavior(GOLD_GEAR_OFF_BEHAVIOR, Ingredient.func_193367_a((Item)RegistryHandler.GOLD_GEAR_OFF), behavior -> MysticalMechanicsIntegration.wrapPowerLevelBehavior(behavior, 320.0, 1.0));
    }

    private static void replaceBehavior(ResourceLocation name, Ingredient ingredient, Function<IGearBehavior, IGearBehavior> transformer) {
        IGearBehavior behavior = MysticalMechanicsAPI.IMPL.getGearBehavior(name);
        MysticalMechanicsAPI.IMPL.unregisterGear(name);
        MysticalMechanicsAPI.IMPL.registerGear(name, ingredient, transformer.apply(behavior));
    }

    private static IGearBehavior wrapPowerLevelBehavior(final IGearBehavior behavior, final double max_power, final double slope) {
        return new IGearBehavior(){

            public double transformPower(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double power) {
                power = behavior.transformPower(tile, facing, gear, data, power);
                return Misc.getDiminishedPower(power, max_power, slope);
            }

            public void visualUpdate(TileEntity tile, @Nullable EnumFacing facing, ItemStack gear, IGearData data, double powerIn, double powerOut) {
                behavior.visualUpdate(tile, facing, gear, data, powerIn, powerOut);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClientSide() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMechActuator.class, (TileEntitySpecialRenderer)new TileEntityMechActuatorRenderer());
    }

    public static void initMysticalMechanicsCategory() {
        ResearchManager.gearbox = new ResearchBase("gearbox", new ItemStack((Block)RegistryHandler.GEARBOX_FRAME), 2.0, 4.0);
        ResearchManager.mergebox = new ResearchBase("mergebox", new ItemStack((Block)RegistryHandler.MERGEBOX_FRAME), 1.0, 6.0).addAncestor(ResearchManager.gearbox);
        ResearchManager.axle_iron = new ResearchBase("axle_iron", new ItemStack((Block)RegistryHandler.IRON_AXLE), 2.0, 0.0).addAncestor(ResearchManager.gearbox);
        ItemStack gearIron = new ItemStack(RegistryHandler.IRON_GEAR);
        ItemStack gearGold = new ItemStack(RegistryHandler.GOLD_GEAR);
        ItemStack gearDawnstone = new ItemStack(GEAR_DAWNSTONE);
        ItemStack gearGoldOn = new ItemStack(RegistryHandler.GOLD_GEAR_ON);
        ItemStack gearGoldOff = new ItemStack(RegistryHandler.GOLD_GEAR_OFF);
        ResearchManager.gear_iron = new ResearchShowItem("gear_iron", gearIron, 4.0, 1.0).addItem(new ResearchShowItem.DisplayItem(gearIron)).addAncestor(ResearchManager.gearbox).addPage(new ResearchShowItem("gear_gold", gearGold, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(gearGold))).addPage(new ResearchShowItem("gear_redstone", gearGoldOn, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(gearGoldOff, gearGoldOn))).addPage(new ResearchShowItem("gear_dawnstone", gearDawnstone, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(gearDawnstone)));
        ResearchManager.actuator = new ResearchBase("actuator", new ItemStack(MECH_ACTUATOR_SINGLE), 9.0, 5.0).addAncestor(ResearchManager.gearbox).addPage(new ResearchShowItem("actuator_multi", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(MECH_ACTUATOR)))).addPage(new ResearchShowItem("actuator_bore", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.EMBER_BORE)))).addPage(new ResearchShowItem("actuator_pump", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.MECHANICAL_PUMP)))).addPage(new ResearchShowItem("actuator_stamper", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.STAMPER)))).addPage(new ResearchShowItem("actuator_mixer", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.MIXER)))).addPage(new ResearchShowItem("actuator_auto_hammer", ItemStack.field_190927_a, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.AUTO_HAMMER))));
        ResearchFakePage mechanical_mini_boiler = new ResearchFakePage(ResearchManager.mini_boiler, 12.0, 0.0);
        ResearchManager.steam_engine = new ResearchBase("steam_engine", new ItemStack(STEAM_ENGINE), 9.0, 2.0).addAncestor(ResearchManager.gearbox).addAncestor(mechanical_mini_boiler).addPage(new ResearchBase("steam_engine_overclock", ItemStack.field_190927_a, 0.0, 0.0));
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.gearbox);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.mergebox);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.axle_iron);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.gear_iron);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.actuator);
        ResearchManager.subCategoryMechanicalPower.addResearch(ResearchManager.steam_engine);
        ResearchManager.subCategoryMechanicalPower.addResearch(mechanical_mini_boiler);
    }

    public static void addCapabilityInformation(List<String> text, TileEntity tileEntity, EnumFacing facing) {
        MysticalMechanicsIntegration.addCapabilityMechanicalDescription(text, tileEntity, facing);
    }

    public static void addCapabilityMechanicalDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability capability = MysticalMechanicsAPI.MECH_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IMechCapability mechCapability = (IMechCapability)tile.getCapability(capability, facing);
            boolean canInput = mechCapability.isInput(facing);
            boolean canOutput = mechCapability.isOutput(facing);
            IExtraCapabilityInformation.EnumIOType ioType = MysticalMechanicsIntegration.getEnumIOType(canInput, canOutput);
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.mechanical", null));
            }
        }
    }

    private static IExtraCapabilityInformation.EnumIOType getEnumIOType(boolean canInput, boolean canOutput) {
        IExtraCapabilityInformation.EnumIOType ioType = canInput && canOutput ? IExtraCapabilityInformation.EnumIOType.BOTH : (canInput ? IExtraCapabilityInformation.EnumIOType.INPUT : (canOutput ? IExtraCapabilityInformation.EnumIOType.OUTPUT : IExtraCapabilityInformation.EnumIOType.NONE));
        return ioType;
    }
}

