/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.filter;

import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.api.filter.EnumFilterSetting;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.filter.IFilterComparator;
import teamroots.embers.util.FilterUtil;

public class FilterSieve
implements IFilter {
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("embers", "sieve");
    private ItemStack stack1;
    private ItemStack stack2;
    private int offset;
    private EnumFilterSetting setting;
    private boolean inverted;
    private IFilterComparator comparator;

    public FilterSieve(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public FilterSieve(ItemStack stack1, ItemStack stack2, int offset, EnumFilterSetting setting, boolean inverted) {
        this.stack1 = stack1;
        this.stack2 = stack2;
        this.offset = offset;
        this.setting = setting;
        this.inverted = inverted;
        this.findComparator();
    }

    private void findComparator() {
        if (this.stack1.func_190926_b() && this.stack2.func_190926_b()) {
            this.comparator = FilterUtil.ANY;
        } else {
            List<IFilterComparator> comparators = FilterUtil.getComparators(this.stack1, this.stack2);
            this.comparator = comparators.get(this.offset % comparators.size());
        }
    }

    @Override
    public ResourceLocation getType() {
        return RESOURCE_LOCATION;
    }

    @Override
    public boolean acceptsItem(ItemStack stack) {
        return this.comparator.isBetween(this.stack1, this.stack2, stack, this.setting) != this.inverted;
    }

    @Override
    public String formatFilter() {
        if (this.comparator == null) {
            return "INVALID COMPARATOR";
        }
        return this.comparator.format(this.stack1, this.stack2, this.setting, this.inverted);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("type", this.getType().toString());
        tag.func_74782_a("stack1", (NBTBase)this.stack1.serializeNBT());
        tag.func_74782_a("stack2", (NBTBase)this.stack2.serializeNBT());
        tag.func_74768_a("offset", this.offset);
        tag.func_74768_a("setting", this.setting.ordinal());
        tag.func_74757_a("inverted", this.inverted);
        tag.func_74778_a("comparator", this.comparator.getName());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stack1 = new ItemStack(tag.func_74775_l("stack1"));
        this.stack2 = new ItemStack(tag.func_74775_l("stack2"));
        this.offset = tag.func_74762_e("offset");
        this.setting = EnumFilterSetting.values()[tag.func_74762_e("setting")];
        this.inverted = tag.func_74767_n("invert");
        if (tag.func_74764_b("comparator")) {
            this.comparator = FilterUtil.getComparator(tag.func_74779_i("comparator"));
        } else {
            this.findComparator();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterSieve) {
            return this.equals((FilterSieve)obj);
        }
        return super.equals(obj);
    }

    private boolean equals(FilterSieve other) {
        return Objects.equals(this.comparator, other.comparator) && Objects.equals(this.inverted, other.inverted) && Objects.equals((Object)this.setting, (Object)other.setting) && ItemStack.func_77989_b((ItemStack)this.stack1, (ItemStack)other.stack1) && ItemStack.func_77989_b((ItemStack)this.stack2, (ItemStack)other.stack2);
    }
}

