/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockStone;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import teamroots.embers.config.ConfigWorld;
import teamroots.embers.entity.EntityAncientGolem;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.util.Misc;
import teamroots.embers.world.StructureBase;

public class WorldGenSmallRuin
extends StructureBase
implements IWorldGenerator {
    double l = Math.sin(1.0);

    public WorldGenSmallRuin() {
        super(7, 7);
        this.replaceWithAir = false;
        this.addBlockMapping(" ", Blocks.AIR.getDefaultState());
        this.addBlockMapping(".", BlockRegister.STRUCTURE_MARKER.getStateFromMeta(1));
        this.addBlockMapping("A", BlockRegister.ARCHAIC_BRICKS.getDefaultState());
        this.addBlockMapping("T", BlockRegister.ASHEN_TILE.getDefaultState());
        this.addBlockMapping("L", BlockRegister.ARCHAIC_LIGHT.getDefaultState());
        this.addBlockMapping("G", BlockRegister.STRUCTURE_MARKER.getStateFromMeta(0));
        this.addBlockMapping("R", BlockRegister.ARCHAIC_EDGE.getDefaultState());
        this.addBlockMapping("B", BlockRegister.ASHEN_BRICK.getDefaultState());
        this.addLayer(new String[]{"       ", " BBTBB ", " BTTTB ", " TTTTT ", " BTTTB ", " BBTBB ", "       "});
        this.addLayer(new String[]{"  A.A  ", " AA.AA ", "AA...AA", "...G...", "AA...AA", " AA.AA ", "  A.A  "});
        this.addLayer(new String[]{"  A.A  ", " AA.AA ", "AA...AA", ".......", "AA...AA", " AA.AA ", "  A.A  "});
        this.addLayer(new String[]{"  AAA  ", " AAAAA ", "AA...AA", "AA...AA", "AA...AA", " AAAAA ", "  AAA  "});
        this.addLayer(new String[]{"       ", "  RRR  ", " R...R ", " R...R ", " R...R ", "  RRR  ", "       "});
        this.addLayer(new String[]{"       ", "       ", "  AAA  ", "  ALA  ", "  AAA  ", "       ", "       "});
    }

    @Override
    public void placeBlock(World world, BlockPos pos, IBlockState state) {
        if (state.getBlock() == BlockRegister.STRUCTURE_MARKER) {
            if (state.getBlock().getMetaFromState(state) == 0 && ConfigWorld.SMALL_RUIN.containGolem) {
                EntityAncientGolem golem = new EntityAncientGolem(world);
                golem.setPosition((double)pos.getX() + 0.5, pos.getY(), pos.getZ());
                golem.onInitialSpawn(world.getDifficultyForLocation(pos), null);
                golem.enablePersistence();
                world.spawnEntity((Entity)golem);
                world.setBlockToAir(pos);
            } else if (state.getBlock().getMetaFromState(state) == 1) {
                world.setBlockToAir(pos);
            }
        } else {
            super.placeBlock(world, pos, state);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!WorldGenSmallRuin.isSmallRuinEnabled(world.provider.getDimension()) || world.isRemote) {
            return;
        }
        int xx = chunkX * 16 + 13 + Misc.random.nextInt(2);
        int zz = chunkZ * 16 + 13 + Misc.random.nextInt(2);
        if (ConfigWorld.SMALL_RUIN.chance == 0) {
            return;
        }
        if (world.getHeight(xx, zz) > 16) {
            int yy = 4 + Misc.random.nextInt(world.getHeight(xx, zz));
            if (random.nextInt(ConfigWorld.SMALL_RUIN.chance) == 0 && world.getBlockState(new BlockPos(xx, yy, zz)).getBlock() instanceof BlockStone) {
                boolean canGenerate = false;
                BlockPos pos = new BlockPos(xx, yy, zz);
                if (world.isAirBlock(pos.west(4)) || world.isAirBlock(pos.west(3)) || world.isAirBlock(pos.east(4)) || world.isAirBlock(pos.east(3)) || world.isAirBlock(pos.north(4)) || world.isAirBlock(pos.north(3)) || world.isAirBlock(pos.south(4)) || world.isAirBlock(pos.south(3))) {
                    canGenerate = true;
                }
                if (canGenerate) {
                    this.generateIn(world, xx, yy - 2, zz, false);
                }
            }
        }
    }

    public static boolean isSmallRuinEnabled(int dimension) {
        return IntStream.of(ConfigWorld.SMALL_RUIN.blacklist).boxed().collect(Collectors.toList()).contains(dimension) == ConfigWorld.SMALL_RUIN.isWhiteList;
    }
}

