/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.util.vector.Quaternion;
import teamroots.embers.particle.ParticleUtil;

public class Misc {
    public static final double LOG_E = Math.log10(Math.exp(1.0));
    public static Random random = new Random();

    public static EntityEquipmentSlot handToSlot(EnumHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                return EntityEquipmentSlot.MAINHAND;
            }
            case OFF_HAND: {
                return EntityEquipmentSlot.OFFHAND;
            }
        }
        return null;
    }

    public static boolean isValidLever(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockLever) {
            EnumFacing face = ((BlockLever.EnumOrientation)state.getValue((IProperty)BlockLever.FACING)).getFacing();
            return face == side;
        }
        if (block instanceof BlockButton) {
            EnumFacing face = (EnumFacing)state.getValue((IProperty)BlockButton.FACING);
            return face == side;
        }
        if (block instanceof BlockRedstoneTorch) {
            EnumFacing face = (EnumFacing)state.getValue((IProperty)BlockRedstoneTorch.FACING);
            return face == side;
        }
        return false;
    }

    public static boolean isValidPipeConnector(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.getBlockState(pos);
        return state.getBlockFaceShape(world, pos, side.getOpposite()) == BlockFaceShape.CENTER_BIG;
    }

    public static EnumFacing getOppositeFace(EnumFacing face) {
        return face.getOpposite();
    }

    public static EnumFacing getOppositeHorizontalFace(EnumFacing face) {
        return face.getAxis().isHorizontal() ? face.getOpposite() : face;
    }

    public static EnumFacing getOppositeVerticalFace(EnumFacing face) {
        return face.getAxis().isVertical() ? face.getOpposite() : face;
    }

    public static ItemStack getRepairItem(ItemStack stack) {
        try {
            if (stack.getItem() instanceof ItemTool) {
                ItemStack mat = ((ItemTool)stack.getItem()).toolMaterial.getRepairItemStack().copy();
                if (mat.getItemDamage() == Short.MAX_VALUE) {
                    mat.setItemDamage(0);
                }
                return mat;
            }
            if (stack.getItem() instanceof ItemSword) {
                ItemStack mat = ((ItemSword)stack.getItem()).material.getRepairItemStack().copy();
                if (mat.getItemDamage() == Short.MAX_VALUE) {
                    mat.setItemDamage(0);
                }
                return mat;
            }
            if (stack.getItem() instanceof ItemHoe) {
                ItemStack mat = ((ItemHoe)stack.getItem()).toolMaterial.getRepairItemStack().copy();
                if (mat.getItemDamage() == Short.MAX_VALUE) {
                    mat.setItemDamage(0);
                }
                return mat;
            }
            if (stack.getItem() instanceof ItemArmor) {
                ItemStack mat = ((ItemArmor)stack.getItem()).getArmorMaterial().getRepairItemStack().copy();
                if (mat.getItemDamage() == Short.MAX_VALUE) {
                    mat.setItemDamage(0);
                }
                return mat;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ItemStack.EMPTY;
    }

    public static List<TileEntity> getAdjacentTiles(World world, BlockPos pos) {
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        tiles.add(world.getTileEntity(pos.up()));
        tiles.add(world.getTileEntity(pos.down()));
        tiles.add(world.getTileEntity(pos.west()));
        tiles.add(world.getTileEntity(pos.east()));
        tiles.add(world.getTileEntity(pos.north()));
        tiles.add(world.getTileEntity(pos.south()));
        return tiles;
    }

    public static EntityItem rayTraceItem(World world, double posX, double posY, double posZ, double dirX, double dirY, double dirZ) {
        double x = posX;
        double y = posY;
        double z = posZ;
        for (int i = 0; i < 120; ++i) {
            List items;
            if ((items = world.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB((x += dirX / 20.0) - 0.2, (y += dirY / 20.0) - 0.2, (z += dirZ / 20.0) - 0.2, x + 0.2, y + 0.2, z + 0.2))).isEmpty()) continue;
            return (EntityItem)items.get(0);
        }
        return null;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean matchOreDict(ItemStack stack1, ItemStack stack2) {
        int[] keys1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] keys2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int k : keys1) {
            for (int i : keys2) {
                if (k != i) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean betweenAngles(float angleTest, float angleLow, float angleHigh) {
        boolean between;
        boolean bl = between = angleTest >= angleLow && angleTest <= angleHigh;
        if (angleHigh < angleLow) {
            between = angleTest >= angleLow && angleTest < 360.0f || angleTest > 0.0f && angleTest <= angleHigh;
        }
        return between;
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    public static float yawDegreesBetweenPointsSafe(double posX, double posY, double posZ, double posX2, double posY2, double posZ2, double previousYaw) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        if (Math.abs((double)f - previousYaw) > 90.0) {
            f = (double)f < previousYaw ? (f += 360.0f) : (f -= 360.0f);
        }
        return f;
    }

    public static Vec3d lookVector(float rotYaw, float rotPitch) {
        return new Vec3d(Math.sin(rotYaw) * Math.cos(rotPitch), Math.sin(rotPitch), Math.cos(rotYaw) * Math.cos(rotPitch));
    }

    public static int getResourceCount(ItemStack stack) {
        int baseCount = 0;
        if (stack.getItem() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)stack.getItem();
            if (armor.armorType == EntityEquipmentSlot.HEAD) {
                baseCount = 5;
            }
            if (armor.armorType == EntityEquipmentSlot.CHEST) {
                baseCount = 8;
            }
            if (armor.armorType == EntityEquipmentSlot.LEGS) {
                baseCount = 7;
            }
            if (armor.armorType == EntityEquipmentSlot.FEET) {
                baseCount = 4;
            }
        }
        if (stack.getItem() instanceof ItemSword) {
            baseCount = 2;
        }
        if (stack.getItem() instanceof ItemHoe) {
            baseCount = 2;
        }
        if (stack.getItem() instanceof ItemBow) {
            baseCount = 3;
        }
        if (stack.getItem() instanceof ItemTool) {
            baseCount = stack.getItem() instanceof ItemPickaxe || stack.getItem().getHarvestLevel(stack, "pickaxe", null, null) > -1 ? 3 : (stack.getItem() instanceof ItemAxe || stack.getItem().getHarvestLevel(stack, "axe", null, null) > -1 ? 3 : (stack.getItem() instanceof ItemHoe ? 2 : (stack.getItem() instanceof ItemSpade ? 1 : 1)));
        }
        if (baseCount > 0) {
            return (int)((float)baseCount * (1.0f - (float)stack.getItemDamage() / (float)stack.getMaxDamage()));
        }
        return -1;
    }

    public static boolean isHills(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS);
    }

    public static boolean isExtremeHills(Biome biome) {
        return biome.getBiomeName().compareTo(Biomes.EXTREME_HILLS.getBiomeName()) == 0 || biome.getBiomeName().compareTo(Biomes.EXTREME_HILLS_EDGE.getBiomeName()) == 0 || biome.getBiomeName().compareTo(Biomes.EXTREME_HILLS_WITH_TREES.getBiomeName()) == 0 || biome.getBiomeName().compareTo(Biomes.MUTATED_EXTREME_HILLS.getBiomeName()) == 0 || biome.getBiomeName().compareTo(Biomes.MUTATED_EXTREME_HILLS_WITH_TREES.getBiomeName()) == 0;
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.isRemote) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).isEmpty()) continue;
                world.spawnEntity((Entity)new EntityItem(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }

    public static ItemStack getStackFromState(IBlockState state) {
        if (state == null) {
            return ItemStack.EMPTY;
        }
        Block block = state.getBlock();
        int meta = block.damageDropped(state);
        return new ItemStack(block, 1, meta);
    }

    public static void syncTE(TileEntity tile) {
        int j;
        int i;
        PlayerChunkMap chunkMap;
        PlayerChunkMapEntry entry;
        SPacketUpdateTileEntity packet;
        World world = tile.getWorld();
        if (!tile.isInvalid() && world instanceof WorldServer && (packet = tile.getUpdatePacket()) != null && (entry = (chunkMap = ((WorldServer)world).getPlayerChunkMap()).getEntry(i = tile.getPos().getX() >> 4, j = tile.getPos().getZ() >> 4)) != null) {
            entry.sendPacket((Packet)packet);
        }
    }

    @Nullable
    public static RayTraceResult findEntityOnPath(World world, @Nullable Entity projectile, Entity shooter, AxisAlignedBB projectileAABB, Vec3d start, Vec3d end, Predicate<Entity> matcher) {
        RayTraceResult pickedEntity = null;
        double motionX = end.x - start.x;
        double motionY = end.y - start.y;
        double motionZ = end.z - start.z;
        List list = world.getEntitiesInAABBexcluding(projectile, projectileAABB.expand(motionX, motionY, motionZ).grow(1.0), matcher);
        double pickedDistance = 0.0;
        for (Entity entity : list) {
            double distance;
            AxisAlignedBB aabb;
            RayTraceResult raytraceresult;
            if (entity == shooter || (raytraceresult = (aabb = entity.getEntityBoundingBox().grow(0.3)).calculateIntercept(start, end)) == null || !((distance = start.squareDistanceTo(raytraceresult.hitVec)) < pickedDistance) && pickedDistance != 0.0) continue;
            raytraceresult.typeOfHit = RayTraceResult.Type.ENTITY;
            raytraceresult.entityHit = entity;
            pickedEntity = raytraceresult;
            pickedDistance = distance;
        }
        return pickedEntity;
    }

    @Nullable
    public static List<RayTraceResult> findEntitiesOnPath(World world, @Nullable Entity projectile, Entity shooter, AxisAlignedBB projectileAABB, Vec3d start, Vec3d end, Predicate<Entity> matcher) {
        ArrayList<RayTraceResult> entities = new ArrayList<RayTraceResult>();
        double motionX = end.x - start.x;
        double motionY = end.y - start.y;
        double motionZ = end.z - start.z;
        List list = world.getEntitiesInAABBexcluding(projectile, projectileAABB.expand(motionX, motionY, motionZ).grow(1.0), matcher);
        for (Entity entity : list) {
            AxisAlignedBB aabb;
            RayTraceResult raytraceresult;
            if (entity == shooter || (raytraceresult = (aabb = entity.getEntityBoundingBox().grow(0.3)).calculateIntercept(start, end)) == null) continue;
            raytraceresult.typeOfHit = RayTraceResult.Type.ENTITY;
            raytraceresult.entityHit = entity;
            entities.add(raytraceresult);
        }
        entities.sort((o1, o2) -> Double.compare(start.squareDistanceTo(o1.hitVec), start.squareDistanceTo(o2.hitVec)));
        return entities;
    }

    public static List<EntityPlayer> getNonCreativePlayers(World world, AxisAlignedBB box) {
        return world.getEntitiesWithinAABB(EntityPlayer.class, box);
    }

    public static boolean isCreativePlayer(EntityLivingBase e) {
        if (e instanceof EntityPlayer) {
            return ((EntityPlayer)e).isCreative();
        }
        return false;
    }

    public static double getDiminishedPower(double power, double softcap, double slope) {
        if (power > softcap) {
            return softcap * slope + Math.log10(power - softcap + LOG_E / slope) - Math.log10(LOG_E / slope);
        }
        return power * slope;
    }

    public static void spawnClogParticles(World world, BlockPos pos, int spouts, float radius) {
        Misc.spawnClogParticles(world, pos, spouts, radius, new Color(64, 64, 64));
    }

    public static void spawnClogParticles(World world, BlockPos pos, int spouts, float radius, Color color) {
        Random localRandom = new Random(pos.hashCode());
        for (int i = 0; i < spouts; ++i) {
            double angleA = localRandom.nextDouble() * Math.PI * 2.0;
            double angleB = localRandom.nextDouble() * Math.PI * 2.0;
            float xOffset = (float)(Math.cos(angleA) * Math.cos(angleB));
            float yOffset = (float)(Math.sin(angleA) * Math.cos(angleB));
            float zOffset = (float)Math.sin(angleB);
            float speed = 0.01875f;
            float vx = xOffset * speed + random.nextFloat() * speed * 0.3f;
            float vy = yOffset * speed + random.nextFloat() * speed * 0.3f;
            float vz = zOffset * speed + random.nextFloat() * speed * 0.3f;
            ParticleUtil.spawnParticleVapor(world, (float)pos.getX() + 0.5f + xOffset * radius, (float)pos.getY() + 0.5f + yOffset * radius, (float)pos.getZ() + 0.5f + zOffset * radius, vx, vy, vz, color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f, 0.2f, 3.0f, 40);
        }
    }

    public static IItemHandler makeBlockedItemHandler(final IItemHandler handler, final BooleanSupplier canInput, final BooleanSupplier canOutput) {
        return new IItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!canInput.getAsBoolean()) {
                    return stack;
                }
                return handler.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!canOutput.getAsBoolean()) {
                    return ItemStack.EMPTY;
                }
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }
        };
    }

    public static IItemHandler makeRestrictedItemHandler(final IItemHandler handler, final boolean input, final boolean output) {
        return new IItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!input) {
                    return stack;
                }
                return handler.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!output) {
                    return ItemStack.EMPTY;
                }
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }
        };
    }

    public static IFluidHandler makeRestrictedFluidHandler(final IFluidHandler handler, final boolean input, final boolean output) {
        return new IFluidHandler(){

            public IFluidTankProperties[] getTankProperties() {
                return handler.getTankProperties();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (!input) {
                    return 0;
                }
                return handler.fill(resource, doFill);
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (!output) {
                    return null;
                }
                return handler.drain(resource, doDrain);
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (!output) {
                    return null;
                }
                return handler.drain(maxDrain, doDrain);
            }
        };
    }

    public static RayTraceResult raytraceMultiAABB(List<AxisAlignedBB> aabbs, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        list.addAll(aabbs.stream().map(axisalignedbb -> Misc.rayTrace2(pos, start, end, axisalignedbb)).collect(Collectors.toList()));
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.hitVec.squareDistanceTo(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    private static RayTraceResult rayTrace2(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        Vec3d vec3d1;
        Vec3d vec3d = start.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        RayTraceResult raytraceresult = boundingBox.calculateIntercept(vec3d, vec3d1 = end.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.hitVec.add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), raytraceresult.sideHit, pos);
    }

    public static Quaternion slerp(Quaternion a, Quaternion b, float slide) {
        a = a.normalise(null);
        b = b.normalise(null);
        if (slide <= 0.0f) {
            return a;
        }
        if (slide >= 1.0f) {
            return b;
        }
        float dot = Quaternion.dot((Quaternion)a, (Quaternion)b);
        if (dot < 0.0f) {
            a = new Quaternion(-a.x, -a.y, -a.z, -a.w);
            dot = -dot;
        }
        float dotThreshold = 0.9995f;
        if (dot > 0.9995f) {
            Quaternion result = new Quaternion((float)MathHelper.clampedLerp((double)a.x, (double)b.x, (double)slide), (float)MathHelper.clampedLerp((double)a.y, (double)b.y, (double)slide), (float)MathHelper.clampedLerp((double)a.z, (double)b.z, (double)slide), (float)MathHelper.clampedLerp((double)a.w, (double)b.w, (double)slide));
            return result.normalise(null);
        }
        double theta0 = Math.acos(dot);
        double theta = theta0 * (double)slide;
        double sin_theta = Math.sin(theta);
        double sin_theta0 = Math.sin(theta0);
        float s0 = (float)(Math.cos(theta) - (double)dot * sin_theta / sin_theta0);
        float s1 = (float)(sin_theta / sin_theta0);
        return new Quaternion(a.x * s0 + b.x * s1, a.y * s0 + b.y * s1, a.z * s0 + b.z * s1, a.w * s0 + b.w * s1);
    }

    public static Quaternion toQuaternion(float x, float y, float z) {
        float f = (float)Math.toRadians(x);
        float f1 = (float)Math.toRadians(y);
        float f2 = (float)Math.toRadians(z);
        float f3 = MathHelper.sin((float)(0.5f * f));
        float f4 = MathHelper.cos((float)(0.5f * f));
        float f5 = MathHelper.sin((float)(0.5f * f1));
        float f6 = MathHelper.cos((float)(0.5f * f1));
        float f7 = MathHelper.sin((float)(0.5f * f2));
        float f8 = MathHelper.cos((float)(0.5f * f2));
        return new Quaternion(f3 * f6 * f8 + f4 * f5 * f7, f4 * f5 * f8 - f3 * f6 * f7, f3 * f5 * f8 + f4 * f6 * f7, f4 * f6 * f8 - f3 * f5 * f7);
    }

    public static Vec3d rotateVector(Vec3d vec, Quaternion quat) {
        Vec3d quatVec = new Vec3d((double)quat.x, (double)quat.y, (double)quat.z);
        float quatScalar = quat.w;
        return quatVec.scale(2.0 * quatVec.dotProduct(vec)).add(vec.scale((double)(quatScalar * quatScalar) - quatVec.dotProduct(quatVec))).add(quatVec.crossProduct(vec).scale(2.0 * (double)quatScalar));
    }

    public static EnumFacing readNullableFacing(int index) {
        return index > 0 ? EnumFacing.byIndex((int)index) : null;
    }

    public static int writeNullableFacing(EnumFacing facing) {
        return facing != null ? facing.getIndex() : -1;
    }

    public static boolean isGaseousFluid(FluidStack resource) {
        return resource != null && !resource.getFluid().getName().startsWith("aetherworks.") && resource.getFluid().getDensity() <= 0;
    }
}

