/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class IngredientSpecial
extends Ingredient {
    private static Set<IngredientSpecial> uncachedIngredients = Collections.newSetFromMap(new WeakHashMap());
    private ItemStack[] matchingStacks = new ItemStack[0];
    private boolean matchingStacksCached;
    private final Predicate<ItemStack> matcher;

    public IngredientSpecial(Predicate<ItemStack> matcher) {
        super(0);
        this.matcher = matcher;
        uncachedIngredients.add(this);
    }

    public boolean apply(@Nullable ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.EMPTY;
        }
        return this.matcher.test(stack);
    }

    public ItemStack[] getMatchingStacks() {
        if (!this.matchingStacksCached) {
            IngredientSpecial.cacheMatchingStacks();
        }
        return this.matchingStacks;
    }

    private static void cacheMatchingStacks() {
        HashMap matches = new HashMap();
        for (Item item : ForgeRegistries.ITEMS) {
            CreativeTabs[] tabs;
            for (CreativeTabs tab : tabs = item.getCreativeTabs()) {
                if (tab == null) continue;
                NonNullList items = NonNullList.create();
                item.getSubItems(tab, items);
                for (IngredientSpecial ingredient : uncachedIngredients) {
                    items.stream().filter(ingredient.matcher).forEach(stack -> matches.computeIfAbsent(ingredient, ingredientSpecial -> new ArrayList()).add(stack));
                }
            }
        }
        for (Map.Entry entry : matches.entrySet()) {
            ((IngredientSpecial)((Object)entry.getKey())).matchingStacks = entry.getValue() == null ? new ItemStack[]{} : ((List)entry.getValue()).toArray(new ItemStack[0]);
            ((IngredientSpecial)((Object)entry.getKey())).matchingStacksCached = true;
        }
        uncachedIngredients.clear();
    }
}

