/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.util.vector.Quaternion;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.api.projectile.ProjectileFireball;
import teamroots.embers.damage.DamageEmber;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.TurretHelper;

public class TileEntityTurret
extends TileEntity
implements ITickable,
ITileEntityBase {
    TurretHelper helper = new TurretHelper(new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0));
    int ticksExisted;

    public void update() {
        Vec3d forward;
        AxisAlignedBB aabbTarget;
        Iterator iterator;
        ++this.ticksExisted;
        float emitX = (float)this.pos.getX() + 0.5f;
        float emitY = (float)this.pos.getY() + 0.5f;
        float emitZ = (float)this.pos.getZ() + 0.5f;
        if (this.ticksExisted % 1 == 0 && (iterator = this.world.getEntitiesWithinAABB(EntityLivingBase.class, aabbTarget = new AxisAlignedBB(this.pos).grow(10.0)).iterator()).hasNext()) {
            Entity entity = (Entity)iterator.next();
            Vec3d delta = new Vec3d(entity.posX - (double)emitX, entity.posY + (double)(entity.getEyeHeight() / 2.0f) - (double)emitY, entity.posZ - (double)emitZ);
            this.helper.rotateTowards(delta);
        }
        if (this.ticksExisted % 10 == 0 && !this.world.isRemote) {
            forward = this.getUp();
            double eX = (double)emitX + forward.x * 0.7;
            double eY = (double)emitY + forward.y * 0.7;
            double eZ = (double)emitZ + forward.z * 0.7;
            EffectDamage effect = new EffectDamage(1.0f, DamageEmber.EMBER_DAMAGE_SOURCE_FACTORY, 1, 1.0);
            ProjectileFireball fireball = new ProjectileFireball(null, new Vec3d(eX, eY, eZ), new Vec3d(forward.x * 0.85, forward.y * 0.85, forward.z * 0.85), 2.0, 40, effect);
            EmberProjectileEvent event = new EmberProjectileEvent(null, ItemStack.EMPTY, 0.0, fireball);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                for (IProjectilePreset projectile : event.getProjectiles()) {
                    projectile.shoot(this.world);
                }
            }
        }
        if (this.world.isRemote) {
            forward = this.getForward();
            Vec3d side = this.getSide();
            Vec3d vec3d = this.getUp();
        }
        float rotationSpeed = 0.5f;
        this.helper.update(rotationSpeed);
    }

    public void shoot() {
    }

    public Quaternion getCurrentAngle() {
        return this.helper.getCurrentAngle();
    }

    public Quaternion getCurrentAngle(float partialTicks) {
        return this.helper.getCurrentAngle(partialTicks);
    }

    public Vec3d getForward() {
        Quaternion angle = this.getCurrentAngle();
        return TurretHelper.getForward(angle).normalize();
    }

    public Vec3d getUp() {
        Quaternion angle = this.getCurrentAngle();
        return TurretHelper.getUp(angle).normalize();
    }

    public Vec3d getSide() {
        Quaternion angle = this.getCurrentAngle();
        return TurretHelper.getSide(angle).normalize();
    }

    public Vec3d rotateVector(Vec3d vec, Quaternion quat) {
        Vec3d quatVec = new Vec3d((double)quat.x, (double)quat.y, (double)quat.z);
        float quatScalar = quat.w;
        return quatVec.scale(2.0 * quatVec.dotProduct(vec)).add(vec.scale((double)(quatScalar * quatScalar) - quatVec.dotProduct(quatVec))).add(quatVec.crossProduct(vec).scale(2.0 * (double)quatScalar));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        this.helper.writeToNBT(compound);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.helper.readFromNBT(compound);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.getBlock() != newSate.getBlock();
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }
}

