/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockStampBase;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityStampBase
extends TileFluidHandler
implements ITileEntityBase,
IExtraCapabilityInformation {
    public static int capacity = ConfigMachine.STAMPER.capacity;
    public ItemStackHandler inputs = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityStampBase.this.markDirty();
        }
    };

    public TileEntityStampBase() {
        this.tank = new FluidTank(capacity){

            protected void onContentsChanged() {
                TileEntityStampBase.this.markDirty();
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.getWorld().getBlockState(this.getPos()).getValue((IProperty)BlockStampBase.facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inputs;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!heldItem.isEmpty()) {
            boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
            if (!didFill) {
                player.setHeldItem(hand, this.inputs.insertItem(0, heldItem, false));
            }
            this.markDirty();
            return true;
        }
        if (!this.inputs.getStackInSlot(0).isEmpty() && !world.isRemote) {
            world.spawnEntity((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, this.inputs.getStackInSlot(0)));
            this.inputs.setStackInSlot(0, ItemStack.EMPTY);
            this.markDirty();
            return true;
        }
        return false;
    }

    public IFluidHandler getTank() {
        return this.tank;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("inputs", (NBTBase)this.inputs.serializeNBT());
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inputs.deserializeNBT(tag.getCompoundTag("inputs"));
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inputs);
        world.setTileEntity(pos, null);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE((TileEntity)this);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.format((String)"embers.tooltip.goggles.fluid.metal", (Object[])new Object[0])));
        }
    }
}

