/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityRelay
extends TileEntity
implements ITileEntityBase,
IEmberPacketProducer,
IEmberPacketReceiver,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    public BlockPos target = null;
    public long ticksExisted = 0L;
    Random random = new Random();
    int offset = this.random.nextInt(40);
    boolean polled = false;
    public EnumConnection up = EnumConnection.NONE;
    public EnumConnection down = EnumConnection.NONE;
    public EnumConnection north = EnumConnection.NONE;
    public EnumConnection south = EnumConnection.NONE;
    public EnumConnection east = EnumConnection.NONE;
    public EnumConnection west = EnumConnection.NONE;

    public static EnumConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumConnection.NONE;
            }
            case 1: {
                return EnumConnection.LEVER;
            }
        }
        return EnumConnection.NONE;
    }

    public TileEntityRelay() {
        this.capability.setEmberCapacity(0.0);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.getPos().up(), EnumFacing.DOWN);
        this.down = this.getConnection(world, this.getPos().down(), EnumFacing.UP);
        this.north = this.getConnection(world, this.getPos().north(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.getPos().south(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.getPos().west(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.getPos().east(), EnumFacing.EAST);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("up", this.up.ordinal());
        tag.setInteger("down", this.down.ordinal());
        tag.setInteger("north", this.north.ordinal());
        tag.setInteger("south", this.south.ordinal());
        tag.setInteger("west", this.west.ordinal());
        tag.setInteger("east", this.east.ordinal());
        if (this.target != null) {
            tag.setInteger("targetX", this.target.getX());
            tag.setInteger("targetY", this.target.getY());
            tag.setInteger("targetZ", this.target.getZ());
        }
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.up = TileEntityRelay.connectionFromInt(tag.getInteger("up"));
        this.down = TileEntityRelay.connectionFromInt(tag.getInteger("down"));
        this.north = TileEntityRelay.connectionFromInt(tag.getInteger("north"));
        this.south = TileEntityRelay.connectionFromInt(tag.getInteger("south"));
        this.west = TileEntityRelay.connectionFromInt(tag.getInteger("west"));
        this.east = TileEntityRelay.connectionFromInt(tag.getInteger("east"));
        if (tag.hasKey("targetX")) {
            this.target = new BlockPos(tag.getInteger("targetX"), tag.getInteger("targetY"), tag.getInteger("targetZ"));
        }
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public EnumConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing face;
        if (world.getBlockState(pos).getBlock() == Blocks.LEVER && ((face = ((BlockLever.EnumOrientation)world.getBlockState(pos).getValue((IProperty)BlockLever.FACING)).getFacing()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN)) {
            return EnumConnection.LEVER;
        }
        return EnumConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        if (pos.compareTo((Vec3i)this.getPos()) != 0) {
            this.capability.setEmberCapacity(200.0);
            this.target = pos;
            this.markDirty();
        }
    }

    @Override
    public boolean isFull() {
        TileEntity tile;
        this.polled = true;
        if (this.target != null && ((tile = this.getWorld().getTileEntity(this.target)) instanceof TileEntityRelay ? ((TileEntityRelay)tile).target != null && !((TileEntityRelay)tile).polled && ((TileEntityRelay)tile).target.compareTo((Vec3i)this.getPos()) != 0 : tile instanceof IEmberPacketReceiver)) {
            return ((IEmberPacketReceiver)tile).isFull();
        }
        return true;
    }

    @Override
    public boolean onReceive(EntityEmberPacket packet) {
        if (this.target != null) {
            packet.dest = this.target;
            packet.lifetime = 80;
        } else {
            packet.dest = this.getPos();
        }
        this.getWorld().playSound(null, this.pos, SoundManager.EMBER_RELAY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return false;
    }

    public void update() {
        this.polled = false;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public static enum EnumConnection {
        NONE,
        LEVER;

    }
}

