/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.block.BlockEmberEmitter;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityReceiver
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketReceiver {
    public static final double TRANSFER_RATE = ConfigMachine.RECEIVER.transfer_rate;
    public static final double EMBER_CAPACITY = ConfigMachine.RECEIVER.capacity;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityReceiver.this.markDirty();
        }

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    Random random = new Random();
    long ticksExisted = 0L;

    public TileEntityReceiver() {
        this.capability.setEmberCapacity(EMBER_CAPACITY);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        IEmberCapability cap;
        ++this.ticksExisted;
        BlockPos pos = this.getPos();
        IBlockState state = this.getWorld().getBlockState(pos);
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockEmberEmitter.facing);
        TileEntity attachedTile = this.getWorld().getTileEntity(pos.offset(facing.getOpposite()));
        if (this.ticksExisted % 2L == 0L && attachedTile != null && attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)) != null && cap.getEmber() < cap.getEmberCapacity() && this.capability.getEmber() > 0.0) {
            double added = cap.addAmount(Math.min(TRANSFER_RATE, this.capability.getEmber()), true);
            this.capability.removeAmount(added, true);
            if (!this.getWorld().isRemote) {
                attachedTile.markDirty();
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean isFull() {
        return this.capability.getEmber() >= this.capability.getEmberCapacity();
    }

    @Override
    public boolean onReceive(EntityEmberPacket packet) {
        return true;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

