/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockPump;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityPumpTop;
import teamroots.embers.util.FluidUtil;
import teamroots.embers.util.Misc;

public class TileEntityPumpBottom
extends TileEntity
implements ITileEntityBase,
ITickable,
IMechanicallyPowered,
IExtraDialInformation {
    public static final double EMBER_COST = ConfigMachine.PUMP.emberCost;
    int progress;
    int totalProgress;
    int lastProgress;
    EnumFacing front = EnumFacing.UP;
    public IEmberCapability capability = new DefaultEmberCapability();
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();

    public TileEntityPumpBottom() {
        this.capability.setEmberCapacity(ConfigMachine.PUMP.capacity);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        tag.setInteger("progress", this.progress);
        tag.setInteger("front", this.front.getIndex());
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        this.front = EnumFacing.byIndex((int)tag.getInteger("front"));
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY && facing != null) {
            return facing.getAxis() == this.front.getAxis();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY && facing != null && facing.getAxis() == this.front.getAxis()) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public boolean attemptPump(BlockPos pos) {
        TileEntityPumpTop t;
        int filled;
        FluidStack stack;
        IBlockState state = this.world.getBlockState(pos);
        if ((state.getBlock() instanceof IFluidBlock && ((IFluidBlock)state.getBlock()).canDrain(this.world, pos) || state.getBlock() instanceof BlockStaticLiquid) && (this.capability.getEmber() > 0.0 || this.isFreeFluid(state)) && (stack = FluidUtil.getFluid(this.world, pos, state)) != null && (filled = (t = (TileEntityPumpTop)this.world.getTileEntity(this.getPos().up())).getTank().fill(stack, false)) == stack.amount) {
            if (!this.world.isRemote) {
                t.getTank().fill(stack, true);
            }
            t.markDirty();
            this.world.setBlockToAir(pos);
            for (EnumFacing facing : EnumFacing.HORIZONTALS) {
                this.updateWater(pos.offset(facing));
            }
            return false;
        }
        return true;
    }

    private boolean isFreeFluid(IBlockState state) {
        FluidStack fluidStack = FluidUtil.getFluid(this.world, this.getPos(), state);
        if (fluidStack != null) {
            for (String s : ConfigMachine.PUMP.freeFluids) {
                if (!s.equals(fluidStack.getFluid().getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void updateWater(BlockPos pos) {
        IBlockState state = this.world.getBlockState(pos);
        if (state.getBlock() instanceof IFluidBlock || state.getBlock() instanceof BlockLiquid) {
            state.getBlock().updateTick(this.world, pos, state, new Random());
        }
    }

    public void update() {
        boolean cancel;
        IBlockState state = this.world.getBlockState(this.getPos());
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.HORIZONTALS);
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        if (state.getBlock() instanceof BlockPump) {
            this.front = (EnumFacing)state.getValue((IProperty)BlockPump.facing);
        }
        this.lastProgress = this.totalProgress;
        double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, this.upgrades);
        if (this.capability.getEmber() >= emberCost && !(cancel = UpgradeUtil.doWork(this, this.upgrades))) {
            int speed = (int)UpgradeUtil.getTotalSpeedModifier(this, this.upgrades);
            this.progress += speed;
            this.totalProgress += speed;
            UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
            this.capability.removeAmount(emberCost, true);
            if (this.progress > 400) {
                this.progress -= 400;
                boolean doContinue = true;
                if (!this.world.isRemote) {
                    for (int r = 0; r < 6 && doContinue; ++r) {
                        for (int i = -r; i < r + 1 && doContinue; ++i) {
                            for (int j = -r; j < 1 && doContinue; ++j) {
                                for (int k = -r; k < r + 1 && doContinue; ++k) {
                                    doContinue = this.attemptPump(this.getPos().add(i, j - 1, k));
                                }
                            }
                        }
                    }
                }
                if (this.world.isRemote) {
                    this.playSound(speed);
                }
            }
            this.markDirty();
        }
        this.markDirty();
    }

    private void playSound(int speed) {
        float pitch;
        SoundEvent sound;
        if (speed >= 20) {
            sound = SoundManager.PUMP_FAST;
            pitch = (float)speed / 20.0f;
        } else if (speed >= 10) {
            sound = SoundManager.PUMP_MID;
            pitch = (float)speed / 10.0f;
        } else {
            sound = SoundManager.PUMP_SLOW;
            pitch = speed;
        }
        this.world.playSound(Embers.proxy.getClientPlayer(), this.pos.up(), sound, SoundCategory.BLOCKS, 1.0f, pitch);
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Math.min(power / 2.0, 100.0);
    }

    @Override
    public double getMinimumPower() {
        return 2.0;
    }

    @Override
    public double getNominalSpeed() {
        return 10.0;
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }
}

