/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.block.BlockNodeBase;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public abstract class TileEntityNodeBase
extends TileEntity
implements ITileEntityBase {
    protected IUpgradeProvider upgrade = this.initUpgrade();

    protected abstract IUpgradeProvider initUpgrade();

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return facing == this.getFacing();
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && facing == this.getFacing()) {
            return (T)this.upgrade;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        return (EnumFacing)state.getValue((IProperty)BlockNodeBase.facing);
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

