/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.IItemPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;
import teamroots.embers.util.PipePriorityMap;

public abstract class TileEntityItemPipeBase
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipeConnectable,
IItemPipePriority {
    public static final int PRIORITY_BLOCK = 0;
    public static final int PRIORITY_PIPE = 0;
    Random random = new Random();
    boolean[] from = new boolean[EnumFacing.VALUES.length];
    boolean clogged = false;
    public ItemStackHandler inventory;
    EnumFacing lastTransfer;
    boolean syncInventory;
    boolean syncCloggedFlag;
    boolean syncTransfer;
    int ticksExisted;
    int lastRobin;

    protected TileEntityItemPipeBase() {
        this.initInventory();
    }

    protected void initInventory() {
        this.inventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return TileEntityItemPipeBase.this.getCapacity();
            }

            protected void onContentsChanged(int slot) {
                TileEntityItemPipeBase.this.markDirty();
            }
        };
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        if (this.requiresSync()) {
            NBTTagCompound updateTag = this.getSyncTag();
            this.resetSync();
            return new SPacketUpdateTileEntity(this.getPos(), 0, updateTag);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    abstract int getCapacity();

    @Override
    public int getPriority(EnumFacing facing) {
        return 0;
    }

    public abstract EnumPipeConnection getInternalConnection(EnumFacing var1);

    abstract void setInternalConnection(EnumFacing var1, EnumPipeConnection var2);

    abstract boolean isConnected(EnumFacing var1);

    public void setFrom(EnumFacing facing, boolean flag) {
        this.from[facing.getIndex()] = flag;
    }

    public void resetFrom() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.setFrom(facing, false);
        }
    }

    protected boolean isFrom(EnumFacing facing) {
        return this.from[facing.getIndex()];
    }

    protected boolean isAnySideUnclogged() {
        for (EnumFacing facing : EnumFacing.VALUES) {
            TileEntity tile;
            if (!this.isConnected(facing) || !((tile = this.world.getTileEntity(this.pos.offset(facing))) instanceof TileEntityItemPipeBase) || ((TileEntityItemPipeBase)tile).clogged) continue;
            return true;
        }
        return false;
    }

    public void update() {
        if (!this.world.isRemote) {
            ++this.ticksExisted;
            boolean itemsMoved = false;
            ItemStack passStack = this.inventory.extractItem(0, 1, true);
            if (!passStack.isEmpty()) {
                IItemHandler handler;
                PipePriorityMap<Integer, EnumFacing> possibleDirections = new PipePriorityMap<Integer, EnumFacing>();
                IItemHandler[] itemHandlers = new IItemHandler[EnumFacing.VALUES.length];
                for (EnumFacing facing : EnumFacing.VALUES) {
                    TileEntity tile;
                    if (!this.isConnected(facing) || this.isFrom(facing) || (tile = this.world.getTileEntity(this.pos.offset(facing))) == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.getOpposite())) continue;
                    handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.getOpposite());
                    int priority = 0;
                    if (tile instanceof IItemPipePriority) {
                        priority = ((IItemPipePriority)tile).getPriority(facing.getOpposite());
                    }
                    if (this.isFrom(facing.getOpposite())) {
                        priority -= 5;
                    }
                    possibleDirections.put(priority, facing);
                    itemHandlers[facing.getIndex()] = handler;
                }
                Iterator iterator = possibleDirections.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ArrayList list = possibleDirections.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        EnumFacing facing = (EnumFacing)list.get((i + this.lastRobin) % list.size());
                        handler = itemHandlers[facing.getIndex()];
                        itemsMoved = this.pushStack(passStack, facing, handler);
                        if (this.lastTransfer != facing) {
                            this.syncTransfer = true;
                            this.lastTransfer = facing;
                            this.markDirty();
                        }
                        if (!itemsMoved) continue;
                        ++this.lastRobin;
                        break;
                    }
                    if (!itemsMoved) continue;
                    break;
                }
            }
            if (this.inventory.getStackInSlot(0).isEmpty()) {
                if (this.lastTransfer != null && !itemsMoved) {
                    this.syncTransfer = true;
                    this.lastTransfer = null;
                    this.markDirty();
                }
                itemsMoved = true;
                this.resetFrom();
            }
            if (this.clogged == itemsMoved) {
                this.clogged = !itemsMoved;
                this.syncCloggedFlag = true;
                this.markDirty();
            }
        } else if (Embers.proxy.isPlayerWearingGoggles() && this.lastTransfer != null) {
            for (int i = 0; i < 3; ++i) {
                float dist = this.random.nextFloat() * 0.0f;
                int lifetime = 10;
                float vx = (float)this.lastTransfer.getXOffset() / ((float)lifetime / (1.0f - dist));
                float vy = (float)this.lastTransfer.getYOffset() / ((float)lifetime / (1.0f - dist));
                float vz = (float)this.lastTransfer.getZOffset() / ((float)lifetime / (1.0f - dist));
                float x = (float)this.pos.getX() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getXOffset() * dist;
                float y = (float)this.pos.getY() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getYOffset() * dist;
                float z = (float)this.pos.getZ() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.getZOffset() * dist;
                float r = this.clogged ? 255.0f : 16.0f;
                float g = this.clogged ? 16.0f : 255.0f;
                float b = 16.0f;
                float size = this.random.nextFloat() * 2.0f + 2.0f;
                ParticleUtil.spawnParticlePipeFlow(this.world, x, y, z, vx, vy, vz, r, g, b, 0.5f, size, lifetime);
            }
        }
    }

    private boolean pushStack(ItemStack passStack, EnumFacing facing, IItemHandler handler) {
        ItemStack added;
        int slot = -1;
        for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
            if (!handler.insertItem(j, passStack, true).isEmpty()) continue;
            slot = j;
        }
        if (slot != -1 && (added = handler.insertItem(slot, passStack, false)).isEmpty()) {
            this.inventory.extractItem(0, 1, false);
            return true;
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    protected void resetSync() {
        this.syncInventory = false;
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
    }

    protected boolean requiresSync() {
        return this.syncInventory || this.syncCloggedFlag || this.syncTransfer;
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    protected NBTTagCompound getSyncTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.syncInventory) {
            this.writeInventory(compound);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(compound);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(compound);
        }
        return compound;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writeInventory(tag);
        this.writeCloggedFlag(tag);
        this.writeLastTransfer(tag);
        for (EnumFacing facing : EnumFacing.VALUES) {
            tag.setBoolean("from" + facing.getIndex(), this.from[facing.getIndex()]);
        }
        tag.setInteger("lastRobin", this.lastRobin);
        return tag;
    }

    private void writeCloggedFlag(NBTTagCompound tag) {
        tag.setBoolean("clogged", this.clogged);
    }

    private void writeLastTransfer(NBTTagCompound tag) {
        tag.setInteger("lastTransfer", Misc.writeNullableFacing(this.lastTransfer));
    }

    private void writeInventory(NBTTagCompound tag) {
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("clogged")) {
            this.clogged = tag.getBoolean("clogged");
        }
        if (tag.hasKey("inventory")) {
            this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        }
        if (tag.hasKey("lastTransfer")) {
            this.lastTransfer = Misc.readNullableFacing(tag.getInteger("lastTransfer"));
        }
        for (EnumFacing facing : EnumFacing.VALUES) {
            if (!tag.hasKey("from" + facing.getIndex())) continue;
            this.from[facing.getIndex()] = tag.getBoolean("from" + facing.getIndex());
        }
        if (tag.hasKey("lastRobin")) {
            this.lastRobin = tag.getInteger("lastRobin");
        }
    }
}

