/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import teamroots.embers.SoundManager;
import teamroots.embers.item.ItemTinkerHammer;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.TileEntityFluidPipe;
import teamroots.embers.tileentity.TileEntityFluidPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityFluidExtractor
extends TileEntityFluidPipeBase {
    Random random = new Random();
    EnumPipeConnection[] connections = new EnumPipeConnection[EnumFacing.VALUES.length];
    IFluidHandler[] sideHandlers;
    boolean syncConnections;
    boolean active;
    public static final int MAX_DRAIN = 250;

    @Override
    protected void initFluidTank() {
        super.initFluidTank();
        this.sideHandlers = new IFluidHandler[EnumFacing.VALUES.length];
        for (final EnumFacing facing : EnumFacing.VALUES) {
            this.sideHandlers[facing.getIndex()] = new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return TileEntityFluidExtractor.this.tank.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (TileEntityFluidExtractor.this.active) {
                        return 0;
                    }
                    if (doFill) {
                        TileEntityFluidExtractor.this.setFrom(facing, true);
                    }
                    return TileEntityFluidExtractor.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return TileEntityFluidExtractor.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return TileEntityFluidExtractor.this.tank.drain(maxDrain, doDrain);
                }
            };
        }
    }

    public void updateNeighbors(IBlockAccess world) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            this.setInternalConnection(facing, this.getConnection(world, this.getPos().offset(facing), facing));
        }
        this.syncConnections = true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writeConnections(tag);
        return tag;
    }

    private void writeConnections(NBTTagCompound tag) {
        tag.setInteger("up", this.getInternalConnection(EnumFacing.UP).getIndex());
        tag.setInteger("down", this.getInternalConnection(EnumFacing.DOWN).getIndex());
        tag.setInteger("north", this.getInternalConnection(EnumFacing.NORTH).getIndex());
        tag.setInteger("south", this.getInternalConnection(EnumFacing.SOUTH).getIndex());
        tag.setInteger("west", this.getInternalConnection(EnumFacing.WEST).getIndex());
        tag.setInteger("east", this.getInternalConnection(EnumFacing.EAST).getIndex());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("up")) {
            this.setInternalConnection(EnumFacing.UP, EnumPipeConnection.fromIndex(tag.getInteger("up")));
        }
        if (tag.hasKey("down")) {
            this.setInternalConnection(EnumFacing.DOWN, EnumPipeConnection.fromIndex(tag.getInteger("down")));
        }
        if (tag.hasKey("north")) {
            this.setInternalConnection(EnumFacing.NORTH, EnumPipeConnection.fromIndex(tag.getInteger("north")));
        }
        if (tag.hasKey("south")) {
            this.setInternalConnection(EnumFacing.SOUTH, EnumPipeConnection.fromIndex(tag.getInteger("south")));
        }
        if (tag.hasKey("west")) {
            this.setInternalConnection(EnumFacing.WEST, EnumPipeConnection.fromIndex(tag.getInteger("west")));
        }
        if (tag.hasKey("east")) {
            this.setInternalConnection(EnumFacing.EAST, EnumPipeConnection.fromIndex(tag.getInteger("east")));
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.getUpdateTag();
        if (this.syncConnections) {
            this.writeConnections(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncConnections || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncConnections = false;
    }

    @Override
    int getCapacity() {
        return 250;
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing side) {
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NEIGHBORNONE;
        }
        return EnumPipeConnection.PIPE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.tank;
            }
            return (T)this.sideHandlers[facing.getIndex()];
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return this.connections[facing.getIndex()] != null ? this.connections[facing.getIndex()] : EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
        this.connections[facing.getIndex()] = connection;
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getInternalConnection(facing).canTransfer();
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.getTileEntity(pos);
        if (this.getInternalConnection(side) == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.FORCENONE;
        }
        if (tile instanceof TileEntityFluidExtractor) {
            return EnumPipeConnection.NONE;
        }
        if (tile instanceof IFluidPipeConnectable) {
            return ((IFluidPipeConnectable)tile).getConnection(side.getOpposite());
        }
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getOpposite())) {
            return EnumPipeConnection.BLOCK;
        }
        if (Misc.isValidLever(world, pos, side)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    public static EnumPipeConnection reverseForce(EnumPipeConnection connect) {
        if (connect == EnumPipeConnection.FORCENONE) {
            return EnumPipeConnection.NONE;
        }
        if (connect != EnumPipeConnection.NONE && connect != EnumPipeConnection.LEVER) {
            return EnumPipeConnection.FORCENONE;
        }
        return EnumPipeConnection.NONE;
    }

    public void reverseConnection(EnumFacing face) {
        EnumPipeConnection connection = this.getInternalConnection(face);
        this.setInternalConnection(face, TileEntityFluidExtractor.reverseForce(connection));
        TileEntity tile = this.world.getTileEntity(this.pos.offset(face));
        if (tile instanceof TileEntityFluidPipe) {
            ((TileEntityFluidPipe)tile).updateNeighbors((IBlockAccess)this.world);
        }
        if (tile instanceof TileEntityFluidExtractor) {
            ((TileEntityFluidExtractor)tile).updateNeighbors((IBlockAccess)this.world);
        }
        if (connection == EnumPipeConnection.FORCENONE) {
            this.world.playSound(null, this.pos, SoundManager.PIPE_CONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (connection != EnumPipeConnection.NONE && connection != EnumPipeConnection.LEVER) {
            this.world.playSound(null, this.pos, SoundManager.PIPE_DISCONNECT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof ItemTinkerHammer) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5)) {
                    if ((double)hitY < 0.5) {
                        this.reverseConnection(EnumFacing.DOWN);
                    } else {
                        this.reverseConnection(EnumFacing.UP);
                    }
                } else if ((double)hitZ < 0.5) {
                    this.reverseConnection(EnumFacing.NORTH);
                } else {
                    this.reverseConnection(EnumFacing.SOUTH);
                }
            }
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (Math.abs((double)hitX - 0.5) > Math.abs((double)hitY - 0.5)) {
                    if ((double)hitX < 0.5) {
                        this.reverseConnection(EnumFacing.WEST);
                    } else {
                        this.reverseConnection(EnumFacing.EAST);
                    }
                } else if ((double)hitY < 0.5) {
                    this.reverseConnection(EnumFacing.DOWN);
                } else {
                    this.reverseConnection(EnumFacing.UP);
                }
            }
            this.updateNeighbors((IBlockAccess)world);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    @Override
    public void update() {
        if (this.world.isRemote && this.clogged) {
            Misc.spawnClogParticles(this.world, this.pos, 1, 0.25f);
        }
        if (!this.world.isRemote) {
            this.active = this.getWorld().isBlockPowered(this.getPos());
            for (EnumFacing facing : EnumFacing.VALUES) {
                TileEntity tile;
                if (!this.isConnected(facing) || (tile = this.world.getTileEntity(this.pos.offset(facing))) == null || tile instanceof TileEntityFluidPipeBase || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.getOpposite())) continue;
                if (this.active) {
                    FluidStack extracted;
                    int filled;
                    IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.getOpposite());
                    if (handler.drain(250, false) != null && (filled = this.tank.fill(extracted = handler.drain(250, false), false)) > 0) {
                        this.tank.fill(extracted, true);
                        handler.drain(filled, true);
                    }
                    this.setFrom(facing, true);
                    continue;
                }
                this.setFrom(facing, false);
            }
        }
        super.update();
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }
}

