/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.IFluidPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityFluidDropper
extends TileEntity
implements ITileEntityBase,
ITickable,
IFluidPipeConnectable,
IFluidPipePriority {
    Random random = new Random();
    FluidTank tank = new FluidTank(1000);

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.tank.readFromNBT(tag.getCompoundTag("tank"));
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void update() {
        if (!this.world.isRemote) {
            EnumFacing facing = EnumFacing.DOWN;
            for (int i = 1; i <= 5; ++i) {
                IBlockState state;
                int pushed;
                FluidStack stack;
                IFluidHandler handler;
                BlockPos checkPos = this.pos.offset(facing, i);
                TileEntity tile = this.world.getTileEntity(checkPos);
                if (tile != null && (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.getOpposite())) != null && (stack = this.tank.drain(this.tank.getCapacity(), false)) != null && (pushed = handler.fill(stack, false)) > 0) {
                    handler.fill(stack, true);
                    this.tank.drain(pushed, true);
                }
                if ((state = this.world.getBlockState(checkPos)).getBlockFaceShape((IBlockAccess)this.world, checkPos, EnumFacing.UP) == BlockFaceShape.SOLID || state.getBlockFaceShape((IBlockAccess)this.world, checkPos, EnumFacing.DOWN) == BlockFaceShape.SOLID) break;
            }
        }
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return EnumPipeConnection.PIPE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return 50;
    }
}

