/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.IItemPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityDropper
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipeConnectable,
IItemPipePriority {
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityDropper.this.markDirty();
        }
    };
    Random random = new Random();

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public void update() {
        if (!this.inventory.getStackInSlot(0).isEmpty() && !this.getWorld().isRemote) {
            ItemStack stack = this.inventory.extractItem(0, 1, false);
            EntityItem item = new EntityItem(this.getWorld(), (double)this.getPos().getX() + 0.5, (double)this.getPos().getY(), (double)this.getPos().getZ() + 0.5, stack);
            item.motionX = 0.0;
            item.motionY = -0.1;
            item.motionZ = 0.0;
            this.getWorld().spawnEntity((Entity)item);
        }
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return EnumPipeConnection.PIPE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return 50;
    }
}

