/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityCrystalCell
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine,
ISoundController,
IExtraCapabilityInformation {
    public static final int MAX_CAPACITY = ConfigMachine.CRYSTAL_CELL.max_capacity;
    public static final int BASE_CAPACITY = ConfigMachine.CRYSTAL_CELL.base_capacity;
    Random random = new Random();
    public long ticksExisted = 0L;
    public float angle = 0.0f;
    public long seed = 0L;
    public double renderCapacity;
    public double renderCapacityLast;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityCrystalCell.this.markDirty();
        }

        @Override
        public boolean acceptsVolatile() {
            return true;
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityCrystalCell.this.markDirty();
            if (!TileEntityCrystalCell.this.getWorld().isRemote) {
                IBlockState state = TileEntityCrystalCell.this.getWorld().getBlockState(TileEntityCrystalCell.this.getPos());
                TileEntityCrystalCell.this.markDirty();
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.getItem() != ItemRegister.SHARD_EMBER && stack.getItem() != ItemRegister.CRYSTAL_EMBER) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public static final int SOUND_AMBIENT = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double xPos = (double)this.pos.getX() + 0.5;
        double yPos = (double)this.pos.getY() + 0.5;
        double zPos = (double)this.pos.getZ() + 0.5;
        double layerHeight = 0.25;
        double numLayers = 2.0 + Math.floor(this.capability.getEmberCapacity() / 128000.0);
        double size = numLayers * layerHeight;
        return new AxisAlignedBB(xPos - size / 2.0, yPos + 0.5, zPos - size / 2.0, xPos + size / 2.0, yPos + 0.5 + size, zPos + size / 2.0);
    }

    public TileEntityCrystalCell() {
        this.capability.setEmberCapacity(BASE_CAPACITY);
        this.seed = this.random.nextLong();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setLong("seed", this.seed);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        this.capability.readFromNBT(tag);
        this.seed = tag.getLong("seed");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setBlockToAir(pos.add(1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, -1));
        world.setBlockToAir(pos.add(1, 0, -1));
        world.setBlockToAir(pos.add(-1, 0, 1));
        world.setBlockToAir(pos.add(1, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, -1));
        world.setTileEntity(pos, null);
    }

    public void update() {
        boolean cancel;
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, new EnumFacing[]{EnumFacing.DOWN});
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        ++this.ticksExisted;
        this.renderCapacityLast = this.renderCapacity;
        this.renderCapacity = this.renderCapacity < this.capability.getEmberCapacity() ? (this.renderCapacity += Math.min(10000.0, this.capability.getEmberCapacity() - this.renderCapacity)) : (this.renderCapacity -= Math.min(10000.0, this.renderCapacity - this.capability.getEmberCapacity()));
        if (!this.inventory.getStackInSlot(0).isEmpty() && this.ticksExisted % 4L == 0L && !(cancel = UpgradeUtil.doWork(this, upgrades))) {
            ItemStack stack = this.inventory.extractItem(0, 1, true);
            if (!this.getWorld().isRemote && !stack.isEmpty()) {
                this.inventory.extractItem(0, 1, false);
                int maxCapacity = UpgradeUtil.getOtherParameter((TileEntity)this, "max_capacity", MAX_CAPACITY, upgrades);
                if (EmbersAPI.getEmberValue(stack) > 0.0 && this.capability.getEmberCapacity() < (double)maxCapacity) {
                    this.capability.setEmberCapacity(Math.min((double)maxCapacity, this.capability.getEmberCapacity() + EmbersAPI.getEmberValue(stack) * 10.0));
                    this.markDirty();
                }
            }
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            double x = (double)this.getPos().getX() + 0.5 + 0.5 * Math.sin(angle);
            double z = (double)this.getPos().getZ() + 0.5 + 0.5 * Math.cos(angle);
            if (this.getWorld().isRemote && !stack.isEmpty()) {
                double x2 = (double)this.getPos().getX() + 0.5;
                double z2 = (double)this.getPos().getZ() + 0.5;
                float layerHeight = 0.25f;
                float numLayers = 2.0f + (float)Math.floor(this.capability.getEmberCapacity() / 120000.0);
                float height = layerHeight * numLayers;
                for (float i = 0.0f; i < 72.0f; i += 1.0f) {
                    float coeff = i / 72.0f;
                    ParticleUtil.spawnParticleGlow(this.getWorld(), (float)x * (1.0f - coeff) + (float)x2 * coeff, (float)this.getPos().getY() + (1.0f - coeff) + (height / 2.0f + 1.5f) * coeff, (float)z * (1.0f - coeff) + (float)z2 * coeff, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                }
            }
            this.world.playSound(null, x, (double)this.pos.getY() + 0.5, z, SoundManager.CRYSTAL_CELL_GROW, SoundCategory.BLOCKS, 1.0f, 1.0f + this.random.nextFloat());
        }
        float numLayers = 2.0f + (float)Math.floor(this.capability.getEmberCapacity() / 120000.0);
        if (this.getWorld().isRemote) {
            int i = 0;
            while ((float)i < numLayers / 2.0f) {
                float layerHeight = 0.25f;
                float height = layerHeight * numLayers;
                float xDest = (float)this.getPos().getX() + 0.5f;
                float yDest = (float)this.getPos().getY() + height / 2.0f + 1.5f;
                float zDest = (float)this.getPos().getZ() + 0.5f;
                float x = (float)this.getPos().getX() + 0.5f + 2.0f * (this.random.nextFloat() - 0.5f);
                float z = (float)this.getPos().getZ() + 0.5f + 2.0f * (this.random.nextFloat() - 0.5f);
                float y = (float)this.getPos().getY() + 1.0f;
                ParticleUtil.spawnParticleGlow(this.getWorld(), x, y, z, (xDest - x) / 24.0f * this.random.nextFloat(), (yDest - y) / 24.0f * this.random.nextFloat(), (zDest - z) / 24.0f * this.random.nextFloat(), 255.0f, 64.0f, 16.0f, 2.0f, 24);
                ++i;
            }
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.CRYSTAL_CELL_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        super.getCapability(capability, facing);
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return null;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.format((String)"embers.tooltip.goggles.item.ember", (Object[])new Object[0])));
        }
    }
}

