/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.research;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.compat.BaublesIntegration;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.compat.Util;
import teamroots.embers.item.ItemEmberStorage;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageResearchData;
import teamroots.embers.network.message.MessageResearchTick;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.register.FluidRegister;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchCategory;
import teamroots.embers.research.capability.DefaultResearchCapability;
import teamroots.embers.research.capability.IResearchCapability;
import teamroots.embers.research.capability.ResearchCapabilityProvider;
import teamroots.embers.research.subtypes.ResearchFakePage;
import teamroots.embers.research.subtypes.ResearchShowItem;
import teamroots.embers.research.subtypes.ResearchSwitchCategory;
import teamroots.embers.util.Vec2i;

public class ResearchManager {
    public static final ResourceLocation PLAYER_RESEARCH = new ResourceLocation("embers", "research");
    public static final ResourceLocation PAGE_ICONS = new ResourceLocation("embers", "textures/gui/codex_pageicons.png");
    public static final double PAGE_ICON_SIZE = 0.09375;
    public static List<ResearchCategory> researches = new ArrayList<ResearchCategory>();
    public static ResearchBase dials;
    public static ResearchBase boiler;
    public static ResearchBase mini_boiler;
    public static ResearchBase ores;
    public static ResearchBase hammer;
    public static ResearchBase ancient_golem;
    public static ResearchBase gauge;
    public static ResearchBase caminite;
    public static ResearchBase bore;
    public static ResearchBase crystals;
    public static ResearchBase activator;
    public static ResearchBase tinker_lens;
    public static ResearchBase reaction_chamber;
    public static ResearchBase copper_cell;
    public static ResearchBase emitters;
    public static ResearchBase dawnstone;
    public static ResearchBase melter;
    public static ResearchBase stamper;
    public static ResearchBase mixer;
    public static ResearchBase breaker;
    public static ResearchBase hearth_coil;
    public static ResearchBase access;
    public static ResearchBase pump;
    public static ResearchBase clockwork_attenuator;
    public static ResearchBase geo_separator;
    public static ResearchBase beam_cannon;
    public static ResearchBase pulser;
    public static ResearchBase splitter;
    public static ResearchBase crystal_cell;
    public static ResearchBase cinder_staff;
    public static ResearchBase clockwork_tools;
    public static ResearchBase blazing_ray;
    public static ResearchBase charger;
    public static ResearchBase jars;
    public static ResearchBase alchemy;
    public static ResearchBase cinder_plinth;
    public static ResearchBase aspecti;
    public static ResearchBase catalytic_plug;
    public static ResearchBase ember_siphon;
    public static ResearchBase tyrfing;
    public static ResearchBase waste;
    public static ResearchBase cluster;
    public static ResearchBase ashen_cloak;
    public static ResearchBase inflictor;
    public static ResearchBase materia;
    public static ResearchBase field_chart;
    public static ResearchBase glimmer;
    public static ResearchBase metallurgic_dust;
    public static ResearchBase modifiers;
    public static ResearchBase inferno_forge;
    public static ResearchBase heat;
    public static ResearchBase dawnstone_anvil;
    public static ResearchBase autohammer;
    public static ResearchBase dismantling;
    public static ResearchBase pipes;
    public static ResearchBase tank;
    public static ResearchBase bin;
    public static ResearchBase dropper;
    public static ResearchBase reservoir;
    public static ResearchBase vacuum;
    public static ResearchBase transfer;
    public static ResearchBase golem_eye;
    public static ResearchBase requisition;
    public static ResearchBase adhesive;
    public static ResearchBase hellish_synthesis;
    public static ResearchBase archaic_brick;
    public static ResearchBase motive_core;
    public static ResearchBase dwarven_oil;
    public static ResearchBase wildfire;
    public static ResearchBase combustor;
    public static ResearchBase catalyzer;
    public static ResearchBase reactor;
    public static ResearchBase injector;
    public static ResearchBase stirling;
    public static ResearchBase ember_pipe;
    public static ResearchBase superheater;
    public static ResearchBase caster_orb;
    public static ResearchBase resonating_bell;
    public static ResearchBase blasting_core;
    public static ResearchBase winding_gears;
    public static ResearchBase cinder_jet;
    public static ResearchBase eldritch_insignia;
    public static ResearchBase intelligent_apparatus;
    public static ResearchBase flame_barrier;
    public static ResearchBase tinker_lens_augment;
    public static ResearchBase anti_tinker_lens;
    public static ResearchBase shifting_scales;
    public static ResearchBase diffraction_barrel;
    public static ResearchBase focal_lens;
    public static ResearchBase cost_reduction;
    public static ResearchBase mantle_bulb;
    public static ResearchBase explosion_charm;
    public static ResearchBase nonbeliever_amulet;
    public static ResearchBase ashen_amulet;
    public static ResearchBase dawnstone_mail;
    public static ResearchBase explosion_pedestal;
    public static ResearchBase gearbox;
    public static ResearchBase mergebox;
    public static ResearchBase axle_iron;
    public static ResearchBase gear_iron;
    public static ResearchBase actuator;
    public static ResearchBase steam_engine;
    public static ResearchCategory categoryWorld;
    public static ResearchCategory categoryMechanisms;
    public static ResearchCategory categoryMetallurgy;
    public static ResearchCategory categoryAlchemy;
    public static ResearchCategory categorySmithing;
    public static ResearchCategory subCategoryPipes;
    public static ResearchCategory subCategoryWeaponAugments;
    public static ResearchCategory subCategoryArmorAugments;
    public static ResearchCategory subCategoryProjectileAugments;
    public static ResearchCategory subCategoryMiscAugments;
    public static ResearchCategory subCategoryMechanicalPower;
    public static ResearchCategory subCategoryBaubles;
    public static ResearchCategory subCategorySimpleAlchemy;
    public static ResearchCategory subCategoryWildfire;

    public static boolean isPathToLock(ResearchBase entry) {
        for (ResearchCategory category : researches) {
            for (ResearchBase target : category.prerequisites) {
                if (!ResearchManager.isPathTowards(entry, target)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPathTowards(ResearchBase entry, ResearchBase target) {
        if (entry.isPathTowards(target)) {
            return true;
        }
        for (ResearchBase ancestor : target.ancestors) {
            if (!ResearchManager.isPathTowards(entry, ancestor)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && !event.getWorld().isRemote) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            ResearchManager.sendResearchData(player);
        }
    }

    public static void sendResearchData(EntityPlayerMP player) {
        IResearchCapability research = ResearchManager.getPlayerResearch((EntityPlayer)player);
        if (research != null) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageResearchData(research.getCheckmarks()), player);
        }
    }

    public static void receiveResearchData(Map<String, Boolean> checkmarks) {
        for (ResearchBase research : ResearchManager.getAllResearch()) {
            Boolean checked = checkmarks.get(research.name);
            if (checked == null) continue;
            research.check(checked);
        }
    }

    public static void sendCheckmark(ResearchBase research, boolean checked) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageResearchTick(research.name, checked));
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !event.getCapabilities().containsKey(PLAYER_RESEARCH)) {
            event.addCapability(PLAYER_RESEARCH, (ICapabilityProvider)new ResearchCapabilityProvider(new DefaultResearchCapability()));
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        IResearchCapability oldCap = ResearchManager.getPlayerResearch(event.getOriginal());
        IResearchCapability newCap = ResearchManager.getPlayerResearch(event.getEntityPlayer());
        if (oldCap != null && newCap != null) {
            NBTTagCompound compound = new NBTTagCompound();
            oldCap.writeToNBT(compound);
            newCap.readFromNBT(compound);
        }
    }

    public static IResearchCapability getPlayerResearch(EntityPlayer player) {
        if (player.hasCapability(ResearchCapabilityProvider.researchCapability, null)) {
            return (IResearchCapability)player.getCapability(ResearchCapabilityProvider.researchCapability, null);
        }
        return null;
    }

    public static List<ResearchBase> getAllResearch() {
        HashSet<ResearchBase> result = new HashSet<ResearchBase>();
        for (ResearchCategory category : researches) {
            category.getAllResearch(result);
        }
        return new ArrayList<ResearchBase>(result);
    }

    public static Map<ResearchBase, Integer> findByTag(String match) {
        HashMap<ResearchBase, Integer> result = new HashMap<ResearchBase, Integer>();
        HashSet<ResearchCategory> categories = new HashSet<ResearchCategory>();
        if (!match.isEmpty()) {
            for (ResearchCategory category : researches) {
                category.findByTag(match, result, categories);
            }
        }
        return result;
    }

    public static void initResearches() {
        ResearchBase baublesSwitch;
        ResearchBase mechanicalPowerSwitch;
        categoryWorld = new ResearchCategory("world", 16.0);
        categoryMechanisms = new ResearchCategory("mechanisms", 32.0);
        categoryMetallurgy = new ResearchCategory("metallurgy", 48.0);
        categoryAlchemy = new ResearchCategory("alchemy", 64.0);
        categorySmithing = new ResearchCategory("smithing", 80.0);
        Vec2i[] ringPositions = new Vec2i[]{new Vec2i(1, 1), new Vec2i(0, 3), new Vec2i(0, 5), new Vec2i(1, 7), new Vec2i(11, 7), new Vec2i(12, 5), new Vec2i(12, 3), new Vec2i(11, 1), new Vec2i(4, 1), new Vec2i(2, 4), new Vec2i(4, 7), new Vec2i(8, 7), new Vec2i(10, 4), new Vec2i(8, 1)};
        subCategoryWeaponAugments = new ResearchCategory("weapon_augments", 0.0).pushGoodLocations(ringPositions);
        subCategoryArmorAugments = new ResearchCategory("armor_augments", 0.0).pushGoodLocations(ringPositions);
        subCategoryProjectileAugments = new ResearchCategory("projectile_augments", 0.0).pushGoodLocations(ringPositions);
        subCategoryMiscAugments = new ResearchCategory("misc_augments", 0.0).pushGoodLocations(ringPositions);
        subCategoryPipes = new ResearchCategory("pipes", 0.0);
        subCategoryMechanicalPower = new ResearchCategory("mystical_mechanics", 0.0);
        subCategoryBaubles = new ResearchCategory("baubles", 0.0);
        subCategorySimpleAlchemy = new ResearchCategory("simple_alchemy", 0.0);
        subCategoryWildfire = new ResearchCategory("wildfire", 0.0);
        ores = new ResearchBase("ores", new ItemStack(Blocks.IRON_ORE), 0.0, 7.0);
        hammer = new ResearchBase("hammer", new ItemStack(ItemRegister.TINKER_HAMMER), 0.0, 3.0).addAncestor(ores);
        ancient_golem = new ResearchBase("ancient_golem", ItemStack.EMPTY, 0.0, 0.0).setIconBackground(PAGE_ICONS, 0.09375, 0.0);
        gauge = new ResearchBase("gauge", new ItemStack(ItemRegister.EMBER_DETECTOR), 4.0, 3.0).addAncestor(ores);
        caminite = new ResearchBase("caminite", new ItemStack(ItemRegister.BRICK_CAMINITE), 6.0, 7.0);
        bore = new ResearchBase("bore", new ItemStack(BlockRegister.EMBER_BORE), 9.0, 0.0).addAncestor(hammer).addAncestor(caminite);
        crystals = new ResearchBase("crystals", new ItemStack(ItemRegister.CRYSTAL_EMBER), 12.0, 3.0).addAncestor(bore);
        activator = new ResearchBase("activator", new ItemStack(BlockRegister.EMBER_ACTIVATOR), 9.0, 5.0).addAncestor(crystals);
        boiler = new ResearchBase("boiler", new ItemStack(BlockRegister.BOILER), 9.0, 7.0).addAncestor(activator);
        mini_boiler = new ResearchBase("mini_boiler", new ItemStack(BlockRegister.MINI_BOILER), 11.0, 7.0).addAncestor(activator);
        dials = new ResearchBase("dials", new ItemStack(BlockRegister.EMBER_GAUGE), 5.0, 5.0).addAncestor(hammer);
        tinker_lens = new ResearchBase("tinker_lens", new ItemStack(ItemRegister.TINKER_LENS), 4.0, 7.0).addAncestor(hammer);
        reaction_chamber = new ResearchBase("reaction_chamber", new ItemStack(BlockRegister.REACTION_CHAMBER), 12.0, 5.0).addAncestor(mini_boiler);
        pipes = new ResearchBase("pipes", new ItemStack(BlockRegister.PUMP), 2.0, 4.0);
        pipes.addPage(new ResearchShowItem("routing", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.ITEM_PIPE), new ItemStack(BlockRegister.PIPE))));
        pipes.addPage(new ResearchShowItem("valves", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.ITEM_PUMP), new ItemStack(BlockRegister.PUMP))));
        pipes.addPage(new ResearchShowItem("pipe_tools", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(ItemRegister.TINKER_HAMMER), new ItemStack(Items.STICK))));
        golem_eye = new ResearchBase("golem_eye", new ItemStack(ItemRegister.GOLEMS_EYE), 5.0, 7.0).addPage(new ResearchShowItem("filter_existing", new ItemStack(BlockRegister.ITEM_REQUEST), 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.ITEM_REQUEST)))).addPage(new ResearchShowItem("filter_not_existing", new ItemStack(BlockRegister.DAWNSTONE_ANVIL), 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.DAWNSTONE_ANVIL))));
        transfer = new ResearchBase("transfer", new ItemStack(BlockRegister.ITEM_TRANSFER), 5.0, 5.0).addAncestor(pipes).addAncestor(golem_eye);
        transfer.addPage(new ResearchShowItem("fluid_transfer", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.FLUID_TRANSFER))));
        vacuum = new ResearchBase("vacuum", new ItemStack(BlockRegister.VACUUM), 8.0, 4.0).addPage(new ResearchBase("vacuum_transfer", ItemStack.EMPTY, 0.0, 0.0)).addAncestor(pipes);
        dropper = new ResearchBase("dropper", new ItemStack(BlockRegister.ITEM_DROPPER), 8.0, 6.0).addAncestor(pipes);
        bin = new ResearchBase("bin", new ItemStack(BlockRegister.BIN), 4.0, 3.0).addAncestor(pipes);
        tank = new ResearchBase("tank", new ItemStack(BlockRegister.BLOCK_TANK), 3.0, 1.0).addAncestor(pipes);
        reservoir = new ResearchBase("reservoir", new ItemStack(BlockRegister.LARGE_TANK), 6.0, 0.0).addAncestor(tank).addPage(new ResearchShowItem("reservoir_valve", new ItemStack(BlockRegister.STONE_VALVE), 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.STONE_VALVE))));
        requisition = new ResearchBase("requisition", new ItemStack(BlockRegister.ITEM_REQUEST), 3.0, 6.0).addAncestor(pipes).addAncestor(golem_eye);
        emitters = new ResearchShowItem("emitters", new ItemStack(BlockRegister.EMBER_EMITTER), 0.0, 2.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.EMBER_EMITTER))).addPage(new ResearchShowItem("receivers", new ItemStack(BlockRegister.EMBER_RECEIVER), 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.EMBER_RECEIVER)))).addPage(new ResearchShowItem("linking", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.EMBER_RECEIVER), new ItemStack(ItemRegister.TINKER_HAMMER), new ItemStack(BlockRegister.EMBER_EMITTER))));
        melter = new ResearchBase("melter", new ItemStack(BlockRegister.BLOCK_FURNACE), 2.0, 0.0).addAncestor(emitters);
        geo_separator = new ResearchBase("geo_separator", new ItemStack(BlockRegister.GEO_SEPARATOR), 0.0, 0.0).addAncestor(melter);
        stamper = new ResearchBase("stamper", new ItemStack(BlockRegister.STAMPER), 2.0, 4.0).addAncestor(melter).addAncestor(emitters);
        access = new ResearchBase("access", new ItemStack(BlockRegister.MECH_CORE), 7.0, 5.0).addAncestor(stamper);
        hearth_coil = new ResearchBase("hearth_coil", new ItemStack(BlockRegister.HEAT_COIL), 10.0, 1.0).addAncestor(access);
        mixer = new ResearchBase("mixer", new ItemStack(BlockRegister.MIXER), 5.0, 2.0).addAncestor(stamper).addAncestor(melter);
        pump = new ResearchBase("pump", new ItemStack(BlockRegister.MECHANICAL_PUMP), 8.0, 0.0).addAncestor(mixer);
        breaker = new ResearchBase("breaker", new ItemStack(BlockRegister.BREAKER), 4.0, 7.0).addAncestor(stamper);
        dawnstone = new ResearchBase("dawnstone", new ItemStack(ItemRegister.INGOT_DAWNSTONE), 11.0, 4.0).addAncestor(mixer);
        copper_cell = new ResearchBase("copper_cell", new ItemStack(BlockRegister.COPPER_CELL), 0.0, 5.0).addAncestor(emitters);
        clockwork_attenuator = new ResearchBase("clockwork_attenuator", new ItemStack(BlockRegister.CLOCKWORK_ATTENUATOR), 12.0, 7.0);
        crystal_cell = new ResearchBase("crystal_cell", new ItemStack(BlockRegister.CRYSTAL_CELL), 0.0, 1.0);
        pulser = new ResearchShowItem("pulser", new ItemStack(BlockRegister.EMBER_PULSER), 0.0, 3.5).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.EMBER_PULSER))).addAncestor(crystal_cell).addPage(new ResearchShowItem("ember_funnel", new ItemStack(BlockRegister.EMBER_FUNNEL), 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.EMBER_FUNNEL))));
        charger = new ResearchBase("charger", new ItemStack(BlockRegister.CHARGER), 4.0, 0.0);
        ember_siphon = new ResearchBase("ember_siphon", new ItemStack(BlockRegister.EMBER_SIPHON), 2.0, 0.0).addAncestor(charger);
        ItemStack fullJar = ((ItemEmberStorage)ItemRegister.EMBER_JAR).withFill(((ItemEmberStorage)ItemRegister.EMBER_JAR).getCapacity());
        jars = new ResearchBase("jars", fullJar, 7.0, 1.0).addAncestor(charger);
        clockwork_tools = new ResearchBase("clockwork_tools", new ItemStack(ItemRegister.AXE_CLOCKWORK), 2.0, 2.0).addAncestor(jars).addPage(new ResearchShowItem("clockwork_pickaxe", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(ItemRegister.PICKAXE_CLOCKWORK)))).addPage(new ResearchShowItem("clockwork_hammer", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(ItemRegister.GRANDHAMMER)))).addPage(new ResearchShowItem("clockwork_axe", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(ItemRegister.AXE_CLOCKWORK))));
        splitter = new ResearchBase("splitter", new ItemStack(BlockRegister.BEAM_SPLITTER), 0.0, 6.0).addAncestor(pulser);
        cinder_staff = new ResearchBase("cinder_staff", new ItemStack(ItemRegister.STAFF_EMBER), 4.0, 4.0).addAncestor(jars);
        blazing_ray = new ResearchBase("blazing_ray", new ItemStack(ItemRegister.IGNITION_CANNON), 6.0, 5.0).addAncestor(jars);
        aspecti = new ResearchBase("aspecti", new ItemStack(ItemRegister.ASPECTUS_DAWNSTONE), 12.0, 1.0);
        cinder_plinth = new ResearchBase("cinder_plinth", new ItemStack(BlockRegister.CINDER_PLINTH), 9.0, 0.0);
        beam_cannon = new ResearchBase("beam_cannon", new ItemStack(BlockRegister.BEAM_CANNON), 9.0, 7.0);
        alchemy = new ResearchBase("alchemy", new ItemStack(BlockRegister.ALCHEMY_TABLET), 9.0, 4.0).addAncestor(cinder_plinth).addAncestor(aspecti).addAncestor(beam_cannon);
        catalytic_plug = new ResearchBase("catalytic_plug", new ItemStack(BlockRegister.CATALYTIC_PLUG), 12.0, 5.0).addAncestor(alchemy);
        waste = new ResearchBase("waste", new ItemStack(ItemRegister.ALCHEMIC_WASTE), 6.0, 2.0);
        materia = new ResearchBase("materia", new ItemStack(ItemRegister.ISOLATED_MATERIA), 6.0, 5.0).addAncestor(waste);
        cluster = new ResearchBase("cluster", new ItemStack(ItemRegister.EMBER_CLUSTER), 3.0, 4.0).addAncestor(waste);
        ashen_cloak = new ResearchShowItem("ashen_cloak", new ItemStack(ItemRegister.ASHEN_CLOAK_CHEST), 9.0, 4.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(ItemRegister.ASHEN_CLOAK_HEAD), new ItemStack(ItemRegister.ASHEN_CLOAK_CHEST), new ItemStack(ItemRegister.ASHEN_CLOAK_LEGS), new ItemStack(ItemRegister.ASHEN_CLOAK_BOOTS))).addAncestor(waste);
        field_chart = new ResearchBase("field_chart", new ItemStack(BlockRegister.FIELD_CHART), 0.0, 5.0).addAncestor(cluster);
        inflictor = new ResearchBase("inflictor", new ItemStack(ItemRegister.INFLICTOR_GEM), 11.0, 7.0).addAncestor(ashen_cloak);
        tyrfing = new ResearchBase("tyrfing", new ItemStack(ItemRegister.TYRFING), 8.0, 6.0).addAncestor(waste);
        glimmer = new ResearchBase("glimmer", new ItemStack(ItemRegister.GLIMMER_SHARD), 9.0, 0.0).addAncestor(waste);
        metallurgic_dust = new ResearchBase("metallurgic_dust", new ItemStack(ItemRegister.DUST_METALLURGIC), 0.0, 2.0).addAncestor(waste);
        adhesive = new ResearchBase("adhesive", new ItemStack(ItemRegister.ADHESIVE), 10.0, 1.0);
        hellish_synthesis = new ResearchBase("hellish_synthesis", new ItemStack(Blocks.NETHERRACK), 2.0, 1.0);
        archaic_brick = new ResearchBase("archaic_brick", new ItemStack(ItemRegister.ARCHAIC_BRICK), 5.0, 2.0).addAncestor(hellish_synthesis);
        motive_core = new ResearchBase("motive_core", new ItemStack(ItemRegister.ANCIENT_MOTIVE_CORE), 4.0, 4.0).addAncestor(archaic_brick);
        dwarven_oil = new ResearchBase("dwarven_oil", FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegister.FLUID_OIL, 1000)), 1.0, 4.0).addAncestor(hellish_synthesis);
        wildfire = new ResearchBase("wildfire", new ItemStack(ItemRegister.WILDFIRE_CORE), 1.0, 5.0);
        injector = new ResearchBase("injector", new ItemStack(BlockRegister.EMBER_INJECTOR), 0.0, 7.0).addAncestor(wildfire).addPage(new ResearchShowItem("crystal_level", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.SEED_IRON), new ItemStack(BlockRegister.SEED_GOLD), new ItemStack(BlockRegister.SEED_COPPER), new ItemStack(BlockRegister.SEED_TIN))).addItem(new ResearchShowItem.DisplayItem(new ItemStack(BlockRegister.SEED_SILVER), new ItemStack(BlockRegister.SEED_LEAD), new ItemStack(BlockRegister.SEED_NICKEL), new ItemStack(BlockRegister.SEED_ALUMINUM))));
        combustor = new ResearchBase("combustor", new ItemStack(BlockRegister.COMBUSTOR), 6.0, 5.0).addAncestor(wildfire);
        combustor.addPage(new ResearchShowItem("empty", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem("combustor_coal", new ItemStack(Items.COAL))).addItem(new ResearchShowItem.DisplayItem("combustor_nether_brick", new ItemStack(Items.NETHERBRICK))).addItem(new ResearchShowItem.DisplayItem("combustor_blaze_powder", new ItemStack(Items.BLAZE_POWDER))));
        catalyzer = new ResearchBase("catalyzer", new ItemStack(BlockRegister.CATALYZER), 5.0, 7.0).addAncestor(wildfire);
        catalyzer.addPage(new ResearchShowItem("empty", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem("catalyzer_redstone", new ItemStack(Items.REDSTONE))).addItem(new ResearchShowItem.DisplayItem("catalyzer_gunpowder", new ItemStack(Items.GUNPOWDER))).addItem(new ResearchShowItem.DisplayItem("catalyzer_glowstone", new ItemStack(Items.GLOWSTONE_DUST))));
        reactor = new ResearchBase("reactor", new ItemStack(BlockRegister.REACTOR), 9.0, 7.0).addAncestor(combustor).addAncestor(catalyzer);
        stirling = new ResearchBase("stirling", new ItemStack(BlockRegister.STIRLING), 0.0, 2.0).addAncestor(wildfire);
        ember_pipe = new ResearchBase("ember_pipe", new ItemStack(BlockRegister.EMBER_PIPE), 12.0, 6.0).addAncestor(reactor);
        dawnstone_anvil = new ResearchBase("dawnstone_anvil", new ItemStack(BlockRegister.DAWNSTONE_ANVIL), 12.0, 7.0);
        autohammer = new ResearchBase("autohammer", new ItemStack(BlockRegister.AUTO_HAMMER), 9.0, 5.0).addAncestor(dawnstone_anvil);
        heat = new ResearchBase("heat", new ItemStack(ItemRegister.CRYSTAL_EMBER), 7.0, 7.0).addAncestor(dawnstone_anvil);
        modifiers = new ResearchBase("modifiers", new ItemStack(ItemRegister.ANCIENT_MOTIVE_CORE), 5.0, 7.0).addAncestor(heat);
        dismantling = new ResearchBase("dismantling", ItemStack.EMPTY, 3.0, 5.0).setIconBackground(PAGE_ICONS, 0.1875, 0.0).addAncestor(modifiers);
        inferno_forge = new ResearchBase("inferno_forge", new ItemStack(BlockRegister.INFERNO_FORGE), 6.0, 4.0).addAncestor(heat);
        superheater = new ResearchBase("superheater", new ItemStack(ItemRegister.SUPERHEATER), subCategoryWeaponAugments.popGoodLocation());
        blasting_core = new ResearchBase("blasting_core", new ItemStack(ItemRegister.BLASTING_CORE), subCategoryWeaponAugments.popGoodLocation());
        caster_orb = new ResearchBase("caster_orb", new ItemStack(ItemRegister.CASTER_ORB), subCategoryWeaponAugments.popGoodLocation()).addPage(new ResearchBase("caster_orb_addendum", ItemStack.EMPTY, 0.0, 0.0));
        resonating_bell = new ResearchBase("resonating_bell", new ItemStack(ItemRegister.RESONATING_BELL), subCategoryWeaponAugments.popGoodLocation());
        winding_gears = new ResearchBase("winding_gears", new ItemStack(ItemRegister.WINDING_GEARS), subCategoryWeaponAugments.popGoodLocation()).addPage(new ResearchShowItem("winding_gears_boots", ItemStack.EMPTY, 0.0, 0.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack((Item)Items.IRON_BOOTS))));
        eldritch_insignia = new ResearchBase("eldritch_insignia", new ItemStack(ItemRegister.ELDRITCH_INSIGNIA), subCategoryArmorAugments.popGoodLocation());
        intelligent_apparatus = new ResearchBase("intelligent_apparatus", new ItemStack(ItemRegister.INTELLIGENT_APPARATUS), subCategoryArmorAugments.popGoodLocation());
        flame_barrier = new ResearchBase("flame_barrier", new ItemStack(ItemRegister.FLAME_BARRIER), subCategoryArmorAugments.popGoodLocation());
        cinder_jet = new ResearchBase("cinder_jet", new ItemStack(ItemRegister.JET_AUGMENT), subCategoryArmorAugments.popGoodLocation());
        tinker_lens_augment = new ResearchBase("tinker_lens_augment", new ItemStack(ItemRegister.TINKER_LENS), subCategoryArmorAugments.popGoodLocation());
        anti_tinker_lens = new ResearchBase("anti_tinker_lens", new ItemStack(ItemRegister.ANTI_TINKER_LENS), subCategoryArmorAugments.popGoodLocation()).addAncestor(tinker_lens_augment);
        shifting_scales = new ResearchBase("shifting_scales", new ItemStack(ItemRegister.SHIFTING_SCALES), subCategoryArmorAugments.popGoodLocation());
        diffraction_barrel = new ResearchBase("diffraction_barrel", new ItemStack(ItemRegister.DIFFRACTION_BARREL), subCategoryProjectileAugments.popGoodLocation());
        focal_lens = new ResearchBase("focal_lens", new ItemStack(ItemRegister.FOCAL_LENS), subCategoryProjectileAugments.popGoodLocation());
        tinker_lens.addPage(tinker_lens_augment);
        ResearchFakePage infernoForgeWeapon = new ResearchFakePage(inferno_forge, 6.0, 4.0);
        subCategoryWeaponAugments.addResearch(infernoForgeWeapon);
        subCategoryWeaponAugments.addResearch(superheater.addAncestor(infernoForgeWeapon));
        subCategoryWeaponAugments.addResearch(blasting_core.addAncestor(infernoForgeWeapon));
        subCategoryWeaponAugments.addResearch(caster_orb.addAncestor(infernoForgeWeapon));
        subCategoryWeaponAugments.addResearch(resonating_bell.addAncestor(infernoForgeWeapon));
        subCategoryWeaponAugments.addResearch(winding_gears.addAncestor(infernoForgeWeapon));
        ResearchFakePage infernoForgeArmor = new ResearchFakePage(inferno_forge, 6.0, 4.0);
        subCategoryArmorAugments.addResearch(infernoForgeArmor);
        subCategoryArmorAugments.addResearch(cinder_jet.addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(eldritch_insignia.addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(intelligent_apparatus.addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(flame_barrier.addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(new ResearchFakePage(blasting_core, subCategoryArmorAugments.popGoodLocation()).addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(tinker_lens_augment.addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(anti_tinker_lens.addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(shifting_scales.addAncestor(infernoForgeArmor));
        subCategoryArmorAugments.addResearch(new ResearchFakePage(winding_gears, subCategoryArmorAugments.popGoodLocation()).addAncestor(infernoForgeArmor));
        ResearchFakePage infernoForgeProjectile = new ResearchFakePage(inferno_forge, 6.0, 4.0);
        subCategoryProjectileAugments.addResearch(infernoForgeProjectile);
        subCategoryProjectileAugments.addResearch(diffraction_barrel.addAncestor(infernoForgeProjectile));
        subCategoryProjectileAugments.addResearch(focal_lens.addAncestor(infernoForgeProjectile));
        ResearchFakePage infernoForgeMisc = new ResearchFakePage(inferno_forge, 6.0, 4.0);
        subCategoryMiscAugments.addResearch(infernoForgeMisc);
        subCategoryPipes.addResearch(pipes);
        subCategoryPipes.addResearch(bin);
        subCategoryPipes.addResearch(tank);
        subCategoryPipes.addResearch(reservoir);
        subCategoryPipes.addResearch(transfer);
        subCategoryPipes.addResearch(vacuum);
        subCategoryPipes.addResearch(dropper);
        subCategoryPipes.addResearch(requisition);
        subCategoryPipes.addResearch(golem_eye);
        subCategorySimpleAlchemy.addResearch(hellish_synthesis);
        subCategorySimpleAlchemy.addResearch(archaic_brick);
        subCategorySimpleAlchemy.addResearch(motive_core);
        subCategorySimpleAlchemy.addResearch(adhesive);
        subCategorySimpleAlchemy.addResearch(dwarven_oil);
        subCategoryWildfire.addResearch(wildfire);
        subCategoryWildfire.addResearch(injector);
        subCategoryWildfire.addResearch(combustor);
        subCategoryWildfire.addResearch(catalyzer);
        subCategoryWildfire.addResearch(reactor);
        subCategoryWildfire.addResearch(stirling);
        subCategoryWildfire.addResearch(ember_pipe);
        if (Util.isMysticalMechanicsIntegrationEnabled()) {
            mechanicalPowerSwitch = ResearchManager.makeCategorySwitch(subCategoryMechanicalPower, 8, 7, ItemStack.EMPTY, 4, 1);
            MysticalMechanicsIntegration.initMysticalMechanicsCategory();
        } else {
            mechanicalPowerSwitch = new ResearchBase("mystical_mechanics", ItemStack.EMPTY, 8.0, 7.0).setIconBackground(PAGE_ICONS, 0.0, 0.1875);
        }
        mechanicalPowerSwitch.addAncestor(access);
        if (Util.isBaublesIntegrationEnabled()) {
            baublesSwitch = ResearchManager.makeCategorySwitch(subCategoryBaubles, 5, 7, ItemStack.EMPTY, 5, 1);
            BaublesIntegration.initBaublesCategory();
        } else {
            baublesSwitch = new ResearchBase("baubles", ItemStack.EMPTY, 5.0, 7.0).setIconBackground(PAGE_ICONS, 0.09375, 0.1875);
        }
        baublesSwitch.addAncestor(cluster);
        ResearchBase pipeSwitch = ResearchManager.makeCategorySwitch(subCategoryPipes, 3, 0, new ItemStack(BlockRegister.PIPE), 0, 1).addAncestor(hammer);
        ResearchBase weaponAugmentSwitch = ResearchManager.makeCategorySwitch(subCategoryWeaponAugments, 2, 1, ItemStack.EMPTY, 1, 1).setMinEntries(2).addAncestor(inferno_forge);
        ResearchBase armorAugmentSwitch = ResearchManager.makeCategorySwitch(subCategoryArmorAugments, 1, 3, ItemStack.EMPTY, 2, 1).setMinEntries(2).addAncestor(inferno_forge);
        ResearchBase projectileAugmentSwitch = ResearchManager.makeCategorySwitch(subCategoryProjectileAugments, 11, 3, ItemStack.EMPTY, 3, 1).setMinEntries(2).addAncestor(inferno_forge);
        ResearchBase miscAugmentSwitch = ResearchManager.makeCategorySwitch(subCategoryMiscAugments, 10, 1, ItemStack.EMPTY, 0, 1).setMinEntries(2).addAncestor(inferno_forge);
        ResearchBase wildfireSwitch = ResearchManager.makeCategorySwitch(subCategoryWildfire, 1, 7, new ItemStack(ItemRegister.WILDFIRE_CORE), 0, 1).addAncestor(cluster);
        ResearchBase simpleAlchemySwitch = ResearchManager.makeCategorySwitch(subCategorySimpleAlchemy, 12, 1, new ItemStack(Blocks.SOUL_SAND), 0, 1).addAncestor(waste);
        categoryWorld.addResearch(ores).addResearch(hammer).addResearch(ancient_golem).addResearch(gauge).addResearch(tinker_lens).addResearch(caminite).addResearch(bore).addResearch(pipeSwitch).addResearch(crystals).addResearch(activator).addResearch(boiler).addResearch(mini_boiler).addResearch(reaction_chamber).addResearch(dials);
        categoryMechanisms.addResearch(melter).addResearch(stamper).addResearch(hearth_coil).addResearch(mixer).addResearch(pump).addResearch(access).addResearch(mechanicalPowerSwitch).addResearch(breaker).addResearch(dawnstone).addResearch(emitters).addResearch(copper_cell).addResearch(clockwork_attenuator).addResearch(geo_separator);
        categoryMetallurgy.addResearch(splitter).addResearch(pulser).addResearch(crystal_cell).addResearch(charger).addResearch(ember_siphon).addResearch(jars).addResearch(clockwork_tools).addResearch(cinder_staff).addResearch(blazing_ray).addResearch(cinder_plinth).addResearch(aspecti).addResearch(alchemy).addResearch(beam_cannon).addResearch(catalytic_plug);
        categoryAlchemy.addResearch(waste).addResearch(simpleAlchemySwitch).addResearch(cluster).addResearch(ashen_cloak).addResearch(inflictor).addResearch(field_chart).addResearch(materia).addResearch(tyrfing).addResearch(glimmer).addResearch(metallurgic_dust).addResearch(baublesSwitch).addResearch(wildfireSwitch);
        categorySmithing.addResearch(dawnstone_anvil).addResearch(autohammer).addResearch(heat).addResearch(modifiers).addResearch(dismantling).addResearch(inferno_forge).addResearch(weaponAugmentSwitch).addResearch(armorAugmentSwitch).addResearch(projectileAugmentSwitch).addResearch(miscAugmentSwitch);
        categoryMechanisms.addPrerequisite(activator);
        categoryMetallurgy.addPrerequisite(dawnstone);
        categoryAlchemy.addPrerequisite(alchemy);
        categorySmithing.addPrerequisite(wildfire);
        researches.add(categoryWorld);
        researches.add(categoryMechanisms);
        researches.add(categoryMetallurgy);
        researches.add(categoryAlchemy);
        researches.add(categorySmithing);
    }

    private static ResearchSwitchCategory makeCategorySwitch(ResearchCategory targetCategory, int x, int y, ItemStack icon, int u, int v) {
        return (ResearchSwitchCategory)new ResearchSwitchCategory(targetCategory.name + "_category", icon, x, y).setTargetCategory(targetCategory).setIconBackground(PAGE_ICONS, 0.09375 * (double)u, 0.09375 * (double)v);
    }
}

