/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.filter.ComparatorMatch;
import teamroots.embers.api.filter.ComparatorNormal;
import teamroots.embers.api.filter.EnumFilterSetting;
import teamroots.embers.api.filter.FilterItem;
import teamroots.embers.api.filter.FilterSieve;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.compat.BaublesIntegration;
import teamroots.embers.compat.EnderioIntegration;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.compat.Util;
import teamroots.embers.compat.environmentaltech.EnvironmentalTechIntegration;
import teamroots.embers.compat.thaumcraft.ThaumcraftIntegration;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.config.ConfigMaterial;
import teamroots.embers.config.ConfigMisc;
import teamroots.embers.config.ConfigTool;
import teamroots.embers.item.EnumStampType;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.AshenCloakSocketRecipe;
import teamroots.embers.recipe.AshenCloakUnsocketRecipe;
import teamroots.embers.recipe.BoreOutput;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.FluidReactionRecipe;
import teamroots.embers.recipe.HeatCoilFurnaceRecipe;
import teamroots.embers.recipe.HeatCoilRecipe;
import teamroots.embers.recipe.IWrappableRecipe;
import teamroots.embers.recipe.ItemMeltingOreRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.ItemStampingOreRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.TankClearingRecipe;
import teamroots.embers.recipe.register.Alchemistry;
import teamroots.embers.recipe.register.InitEarly;
import teamroots.embers.recipe.register.InitLater;
import teamroots.embers.recipe.register.Melting;
import teamroots.embers.recipe.register.Mixing;
import teamroots.embers.recipe.register.Reacting;
import teamroots.embers.recipe.register.Smelting;
import teamroots.embers.recipe.register.Smithing;
import teamroots.embers.recipe.register.Stamping;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.util.FilterUtil;

public class RecipeRegistry {
    public static ArrayList<ItemMeltingRecipe> meltingRecipes = new ArrayList();
    @Deprecated
    public static ArrayList<ItemMeltingOreRecipe> meltingOreRecipes = new ArrayList();
    public static ArrayList<ItemStampingRecipe> stampingRecipes = new ArrayList();
    @Deprecated
    public static ArrayList<ItemStampingOreRecipe> stampingOreRecipes = new ArrayList();
    public static ArrayList<FluidMixingRecipe> mixingRecipes = new ArrayList();
    public static ArrayList<FluidReactionRecipe> fluidReactionRecipes = new ArrayList();
    public static ArrayList<AlchemyRecipe> alchemyRecipes = new ArrayList();
    public static ArrayList<DawnstoneAnvilRecipe> dawnstoneAnvilRecipes = new ArrayList();
    public static ArrayList<Ingredient> dawnstoneRepairBlacklist = new ArrayList();
    public static ArrayList<Ingredient> dawnstoneMateriaBlacklist = new ArrayList();
    public static ArrayList<Ingredient> dawnstoneBreakdownBlacklist = new ArrayList();
    public static ArrayList<HeatCoilRecipe> heatCoilRecipes = new ArrayList();
    public static ArrayList<BoreOutput> boreOutputSets = new ArrayList();
    public static BoreOutput defaultBoreOutput;
    public static final int INGOT_AMOUNT;
    public static final int NUGGET_AMOUNT;
    public static final int plateAmount;
    public static final int rodAmount;
    public static final int oreMeltAmount;

    public static ResourceLocation getRL(String s) {
        return new ResourceLocation("embers", s);
    }

    @Deprecated
    public static void registerBoreOutput(BoreOutput output) {
        boreOutputSets.add(output);
    }

    public static void setDefaultBoreOutput(BoreOutput output) {
        defaultBoreOutput = output;
    }

    public static void registerMaterialSet(RegistryEvent.Register<IRecipe> event, String metal, Item ingot, Item nugget, Item plate, Block block, Item pickaxe, Item axe, Item shovel, Item hoe, Item sword, boolean registerMetal, boolean registerTools) {
        String ingotKey = "ingot" + metal;
        String nuggetKey = "nugget" + metal;
        String blockKey = "block" + metal;
        if (registerMetal) {
            event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_block"), new ItemStack(block), new Object[]{true, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), ingotKey}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_block")));
            event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_ingot"), new ItemStack(ingot), new Object[]{true, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), nuggetKey}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_ingot")));
            event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL(ingotKey + "_block_decomp"), new ItemStack(ingot, 9), new Object[]{blockKey}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_block_decomp")));
            event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL(ingotKey + "_ingot_decomp"), new ItemStack(nugget, 9), new Object[]{ingotKey}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_ingot_decomp")));
            event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL(ingotKey + "_plate"), new ItemStack(plate, 1), new Object[]{ingotKey, ingotKey, ItemRegister.TINKER_HAMMER}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_plate")));
        }
        if (registerTools && registerMetal) {
            event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_sword"), new ItemStack(sword, 1), new Object[]{true, new Object[]{" C ", " C ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_sword")));
            event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_pickaxe"), new ItemStack(pickaxe, 1), new Object[]{true, new Object[]{"CCC", " S ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_pickaxe")));
            event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_shovel"), new ItemStack(shovel, 1), new Object[]{true, new Object[]{" C ", " S ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_shovel")));
            event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_axe"), new ItemStack(axe, 1), new Object[]{true, new Object[]{" CC", " SC", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL(ingotKey + "_axe")));
            event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_hoe"), new ItemStack(hoe, 1), new Object[]{true, new Object[]{" CC", " S ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL(ingotKey + "_hoe")));
        }
    }

    public static void mergeOreRecipes() {
        stampingRecipes.addAll(stampingOreRecipes);
        meltingRecipes.addAll(meltingOreRecipes);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void initEarly(RegistryEvent.Register<IRecipe> event) {
        InitEarly.INSTANCE.execute();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void initLater(RegistryEvent.Register<Item> event) {
        InitLater.INSTANCE.execute();
        if (Util.isMysticalMechanicsIntegrationEnabled()) {
            MysticalMechanicsIntegration.initOreDict();
        }
    }

    @SubscribeEvent
    public void init(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("crystal_ember"), new ItemStack(ItemRegister.CRYSTAL_EMBER, 1), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), ItemRegister.SHARD_EMBER}}).setRegistryName(RecipeRegistry.getRL("crystal_ember")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("shard_ember"), new ItemStack(ItemRegister.SHARD_EMBER, 6), new Object[]{ItemRegister.CRYSTAL_EMBER}).setRegistryName(RecipeRegistry.getRL("shard_ember")));
        if (ConfigMaterial.GOLD.mustLoad()) {
            event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("plate_gold"), RecipeRegistry.getItemStackFromOreDict("plateGold", 1), new Object[]{"ingotGold", "ingotGold", ItemRegister.TINKER_HAMMER}).setRegistryName(RecipeRegistry.getRL("plate_gold")));
        }
        if (ConfigMaterial.IRON.mustLoad()) {
            event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("plate_iron"), RecipeRegistry.getItemStackFromOreDict("plateIron", 1), new Object[]{"ingotIron", "ingotIron", ItemRegister.TINKER_HAMMER}).setRegistryName(RecipeRegistry.getRL("plate_iron")));
        }
        RecipeRegistry.registerMaterialSet(event, "Lead", ItemRegister.INGOT_LEAD, ItemRegister.NUGGET_LEAD, ItemRegister.PLATE_LEAD, BlockRegister.BLOCK_LEAD, ItemRegister.PICKAXE_LEAD, ItemRegister.AXE_LEAD, ItemRegister.SHOVEL_LEAD, ItemRegister.HOE_LEAD, ItemRegister.SWORD_LEAD, ConfigMaterial.LEAD.mustLoad(), ConfigTool.METAL_TOOL.LEAD.register);
        RecipeRegistry.registerMaterialSet(event, "Copper", ItemRegister.INGOT_COPPER, ItemRegister.NUGGET_COPPER, ItemRegister.PLATE_COPPER, BlockRegister.BLOCK_COPPER, ItemRegister.PICKAXE_COPPER, ItemRegister.AXE_COPPER, ItemRegister.SHOVEL_COPPER, ItemRegister.HOE_COPPER, ItemRegister.SWORD_COPPER, ConfigMaterial.COPPER.mustLoad(), ConfigTool.METAL_TOOL.COPPER.register);
        RecipeRegistry.registerMaterialSet(event, "Silver", ItemRegister.INGOT_SILVER, ItemRegister.NUGGET_SILVER, ItemRegister.PLATE_SILVER, BlockRegister.BLOCK_SILVER, ItemRegister.PICKAXE_SILVER, ItemRegister.AXE_SILVER, ItemRegister.SHOVEL_SILVER, ItemRegister.HOE_SILVER, ItemRegister.SWORD_SILVER, ConfigMaterial.SILVER.mustLoad(), ConfigTool.METAL_TOOL.SILVER.register);
        RecipeRegistry.registerMaterialSet(event, "Dawnstone", ItemRegister.INGOT_DAWNSTONE, ItemRegister.NUGGET_DAWNSTONE, ItemRegister.PLATE_DAWNSTONE, BlockRegister.BLOCK_DAWNSTONE, ItemRegister.PICKAXE_DAWNSTONE, ItemRegister.AXE_DAWNSTONE, ItemRegister.SHOVEL_DAWNSTONE, ItemRegister.HOE_DAWNSTONE, ItemRegister.SWORD_DAWNSTONE, ConfigMaterial.DAWNSTONE.mustLoad(), ConfigTool.METAL_TOOL.DAWNSTONE.register);
        RecipeRegistry.registerMaterialSet(event, "Aluminum", ItemRegister.INGOT_ALUMINUM, ItemRegister.NUGGET_ALUMINUM, ItemRegister.PLATE_ALUMINUM, BlockRegister.BLOCK_ALUMINUM, ItemRegister.PICKAXE_ALUMINUM, ItemRegister.AXE_ALUMINUM, ItemRegister.SHOVEL_ALUMINUM, ItemRegister.HOE_ALUMINUM, ItemRegister.SWORD_ALUMINUM, ConfigMaterial.ALUMINUM.mustLoad(), ConfigTool.METAL_TOOL.ALUMINUM.register);
        RecipeRegistry.registerMaterialSet(event, "Bronze", ItemRegister.INGOT_BRONZE, ItemRegister.NUGGET_BRONZE, ItemRegister.PLATE_BRONZE, BlockRegister.BLOCK_BRONZE, ItemRegister.PICKAXE_BRONZE, ItemRegister.AXE_BRONZE, ItemRegister.SHOVEL_BRONZE, ItemRegister.HOE_BRONZE, ItemRegister.SWORD_BRONZE, ConfigMaterial.BRONZE.mustLoad(), ConfigTool.METAL_TOOL.BRONZE.register);
        RecipeRegistry.registerMaterialSet(event, "Electrum", ItemRegister.INGOT_ELECTRUM, ItemRegister.NUGGET_ELECTRUM, ItemRegister.PLATE_ELECTRUM, BlockRegister.BLOCK_ELECTRUM, ItemRegister.PICKAXE_ELECTRUM, ItemRegister.AXE_ELECTRUM, ItemRegister.SHOVEL_ELECTRUM, ItemRegister.HOE_ELECTRUM, ItemRegister.SWORD_ELECTRUM, ConfigMaterial.ELECTRUM.mustLoad(), ConfigTool.METAL_TOOL.ELECTRUM.register);
        RecipeRegistry.registerMaterialSet(event, "Nickel", ItemRegister.INGOT_NICKEL, ItemRegister.NUGGET_NICKEL, ItemRegister.PLATE_NICKEL, BlockRegister.BLOCK_NICKEL, ItemRegister.PICKAXE_NICKEL, ItemRegister.AXE_NICKEL, ItemRegister.SHOVEL_NICKEL, ItemRegister.HOE_NICKEL, ItemRegister.SWORD_NICKEL, ConfigMaterial.NICKEL.mustLoad(), ConfigTool.METAL_TOOL.NICKEL.register);
        RecipeRegistry.registerMaterialSet(event, "Tin", ItemRegister.INGOT_TIN, ItemRegister.NUGGET_TIN, ItemRegister.PLATE_TIN, BlockRegister.BLOCK_TIN, ItemRegister.PICKAXE_TIN, ItemRegister.AXE_TIN, ItemRegister.SHOVEL_TIN, ItemRegister.HOE_TIN, ItemRegister.SWORD_TIN, ConfigMaterial.TIN.mustLoad(), ConfigTool.METAL_TOOL.TIN.register);
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("blend_caminite"), new ItemStack(ItemRegister.BLEND_CAMINITE, 8), new Object[]{Items.CLAY_BALL, Items.CLAY_BALL, Items.CLAY_BALL, Items.CLAY_BALL, "sand"}).setRegistryName(RecipeRegistry.getRL("blend_caminite")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("plate_caminite_raw"), new ItemStack(ItemRegister.PLATE_CAMINITE_RAW, 1), new Object[]{true, new Object[]{"XX", "XX", Character.valueOf('X'), ItemRegister.BLEND_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("plate_caminite_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_bar_raw"), new ItemStack(ItemRegister.STAMP_BAR_RAW, 1), new Object[]{true, new Object[]{" X ", "X X", " X ", Character.valueOf('X'), ItemRegister.BLEND_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("stamp_bar_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_flat_raw"), new ItemStack(ItemRegister.STAMP_FLAT_RAW, 1), new Object[]{true, new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), ItemRegister.BLEND_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("stamp_flat_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_plate_raw"), new ItemStack(ItemRegister.STAMP_PLATE_RAW, 1), new Object[]{true, new Object[]{"X X", "   ", "X X", Character.valueOf('X'), ItemRegister.BLEND_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("stamp_plate_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_gear_raw"), new ItemStack(ItemRegister.STAMP_GEAR_RAW, 1), new Object[]{true, new Object[]{"X X", " X ", "X X", Character.valueOf('X'), ItemRegister.BLEND_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("stamp_gear_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_rod_raw"), new ItemStack(ItemRegister.STAMP_ROD_RAW, 1), new Object[]{true, new Object[]{" XX", "X X", "XX ", Character.valueOf('X'), ItemRegister.BLEND_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("stamp_rod_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_round_raw"), new ItemStack(ItemRegister.STAMP_ROUND_RAW, 1), new Object[]{true, new Object[]{" X ", "XXX", " X ", Character.valueOf('X'), ItemRegister.BLEND_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("stamp_round_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_caminite_brick"), new ItemStack(BlockRegister.BLOCK_CAMINITE_BRICK, 1), new Object[]{true, new Object[]{"XX", "XX", Character.valueOf('X'), ItemRegister.BRICK_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("block_caminite_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_caminite_large_brick"), new ItemStack(BlockRegister.BLOCK_CAMINITE_LARGE_BRICK, 4), new Object[]{true, new Object[]{"XX", "XX", Character.valueOf('X'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("block_caminite_large_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_caminite_brick_slab"), new ItemStack(BlockRegister.BLOCK_CAMINITE_BRICK_SLAB, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("block_caminite_brick_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_caminite_brick"), new ItemStack(BlockRegister.STAIRS_CAMINITE_BRICK, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("stairs_caminite_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_caminite_brick"), new ItemStack(BlockRegister.WALL_CAMINITE_BRICK, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("wall_caminite_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_stone"), new ItemStack(BlockRegister.ASHEN_STONE, 4), new Object[]{true, new Object[]{" S ", "SAS", " S ", Character.valueOf('S'), "stone", Character.valueOf('A'), "dustAsh"}}).setRegistryName(RecipeRegistry.getRL("ashen_stone")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_stone_slab"), new ItemStack(BlockRegister.ASHEN_STONE_SLAB, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), BlockRegister.ASHEN_STONE}}).setRegistryName(RecipeRegistry.getRL("ashen_stone_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_ashen_stone"), new ItemStack(BlockRegister.STAIRS_ASHEN_STONE, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), BlockRegister.ASHEN_STONE}}).setRegistryName(RecipeRegistry.getRL("stairs_ashen_stone")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_ashen_stone"), new ItemStack(BlockRegister.WALL_ASHEN_STONE, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), BlockRegister.ASHEN_STONE}}).setRegistryName(RecipeRegistry.getRL("wall_ashen_stone")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_brick"), new ItemStack(BlockRegister.ASHEN_BRICK, 4), new Object[]{true, new Object[]{" S ", "SAS", " S ", Character.valueOf('S'), Blocks.STONEBRICK, Character.valueOf('A'), "dustAsh"}}).setRegistryName(RecipeRegistry.getRL("ashen_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_brick"), new ItemStack(BlockRegister.ASHEN_BRICK, 4), new Object[]{true, new Object[]{"SS", "SS", Character.valueOf('S'), BlockRegister.ASHEN_STONE}}).setRegistryName(RecipeRegistry.getRL("ashen_brick2")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_brick_slab"), new ItemStack(BlockRegister.ASHEN_BRICK_SLAB, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), BlockRegister.ASHEN_BRICK}}).setRegistryName(RecipeRegistry.getRL("ashen_brick_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_ashen_brick"), new ItemStack(BlockRegister.STAIRS_ASHEN_BRICK, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), BlockRegister.ASHEN_BRICK}}).setRegistryName(RecipeRegistry.getRL("stairs_ashen_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_ashen_brick"), new ItemStack(BlockRegister.WALL_ASHEN_BRICK, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), BlockRegister.ASHEN_BRICK}}).setRegistryName(RecipeRegistry.getRL("wall_ashen_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_tile"), new ItemStack(BlockRegister.ASHEN_TILE, 4), new Object[]{true, new Object[]{"SS", "SS", Character.valueOf('S'), BlockRegister.ASHEN_BRICK}}).setRegistryName(RecipeRegistry.getRL("ashen_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_tile_slab"), new ItemStack(BlockRegister.ASHEN_TILE_SLAB, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), BlockRegister.ASHEN_TILE}}).setRegistryName(RecipeRegistry.getRL("ashen_tile_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_ashen_tile"), new ItemStack(BlockRegister.STAIRS_ASHEN_TILE, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), BlockRegister.ASHEN_TILE}}).setRegistryName(RecipeRegistry.getRL("stairs_ashen_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_ashen_tile"), new ItemStack(BlockRegister.WALL_ASHEN_TILE, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), BlockRegister.ASHEN_TILE}}).setRegistryName(RecipeRegistry.getRL("wall_ashen_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_stone"), new ItemStack(BlockRegister.ASHEN_STONE, 4), new Object[]{true, new Object[]{"SS", "SS", Character.valueOf('S'), BlockRegister.ASHEN_TILE}}).setRegistryName(RecipeRegistry.getRL("ashen_stone2")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_tank"), new ItemStack(BlockRegister.BLOCK_TANK, 1), new Object[]{true, new Object[]{"B B", "P P", "BIB", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron", Character.valueOf('B'), ItemRegister.BRICK_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("block_tank")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("pipe"), new ItemStack(BlockRegister.PIPE, 8), new Object[]{true, new Object[]{"IPI", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("pipe")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("pump"), new ItemStack(BlockRegister.PUMP, 1), new Object[]{true, new Object[]{" R ", "PBP", " R ", Character.valueOf('P'), BlockRegister.PIPE, Character.valueOf('B'), ItemRegister.PLATE_CAMINITE, Character.valueOf('R'), "dustRedstone"}}).setRegistryName(RecipeRegistry.getRL("pump")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_furnace"), new ItemStack(BlockRegister.BLOCK_FURNACE, 1), new Object[]{true, new Object[]{"BPB", "BCB", "IFI", Character.valueOf('P'), ItemRegister.PLATE_CAMINITE, Character.valueOf('B'), ItemRegister.BRICK_CAMINITE, Character.valueOf('F'), Blocks.FURNACE, Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("block_furnace")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_receiver"), new ItemStack(BlockRegister.EMBER_RECEIVER, 4), new Object[]{true, new Object[]{"I I", "CPC", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('P'), ItemRegister.PLATE_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("ember_receiver")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_emitter"), new ItemStack(BlockRegister.EMBER_EMITTER, 4), new Object[]{true, new Object[]{" C ", " C ", "IPI", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('P'), ItemRegister.PLATE_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("ember_emitter")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("copper_cell"), new ItemStack(BlockRegister.COPPER_CELL, 1), new Object[]{true, new Object[]{"BIB", "ICI", "BIB", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "blockCopper", Character.valueOf('B'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("copper_cell")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_pipe"), new ItemStack(BlockRegister.ITEM_PIPE, 8), new Object[]{true, new Object[]{"IPI", Character.valueOf('P'), "plateLead", Character.valueOf('I'), "ingotLead"}}).setRegistryName(RecipeRegistry.getRL("item_pipe")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_pump"), new ItemStack(BlockRegister.ITEM_PUMP, 1), new Object[]{true, new Object[]{" R ", "PBP", " R ", Character.valueOf('P'), BlockRegister.ITEM_PIPE, Character.valueOf('B'), ItemRegister.PLATE_CAMINITE, Character.valueOf('R'), "dustRedstone"}}).setRegistryName(RecipeRegistry.getRL("item_pump")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("bin"), new ItemStack(BlockRegister.BIN, 1), new Object[]{true, new Object[]{"I I", "I I", "IPI", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("bin")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamper"), new ItemStack(BlockRegister.STAMPER, 1), new Object[]{true, new Object[]{"XCX", "XBX", "X X", Character.valueOf('B'), "blockIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('X'), ItemRegister.BRICK_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("stamper")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_base"), new ItemStack(BlockRegister.STAMP_BASE, 1), new Object[]{true, new Object[]{"I I", "XBX", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), Items.BUCKET, Character.valueOf('X'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("stamp_base")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_bore"), new ItemStack(BlockRegister.EMBER_BORE, 1), new Object[]{true, new Object[]{"YCY", "YBY", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), BlockRegister.MECH_CORE, Character.valueOf('Y'), BlockRegister.STAIRS_CAMINITE_BRICK, Character.valueOf('C'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("ember_bore")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mech_core"), new ItemStack(BlockRegister.MECH_CORE, 1), new Object[]{true, new Object[]{"IBI", " P ", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateLead", Character.valueOf('B'), Items.COMPASS}}).setRegistryName(RecipeRegistry.getRL("mech_core")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mech_accessor"), new ItemStack(BlockRegister.MECH_ACCESSOR, 1), new Object[]{true, new Object[]{"SPI", Character.valueOf('P'), "plateIron", Character.valueOf('S'), BlockRegister.STAIRS_CAMINITE_BRICK, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("mech_accessor")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_activator"), new ItemStack(BlockRegister.EMBER_ACTIVATOR, 1), new Object[]{true, new Object[]{"CCC", "CCC", "IFI", Character.valueOf('C'), "ingotCopper", Character.valueOf('F'), Blocks.FURNACE, Character.valueOf('I'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("ember_activator")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stone_edge"), new ItemStack(BlockRegister.STONE_EDGE, 1), new Object[]{true, new Object[]{"XXX", "Y Y", "XXX", Character.valueOf('Y'), ItemRegister.BRICK_CAMINITE, Character.valueOf('X'), new ItemStack(BlockRegister.WALL_CAMINITE_BRICK)}}).setRegistryName(RecipeRegistry.getRL("stone_edge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stone_valve"), new ItemStack(BlockRegister.STONE_VALVE, 1), new Object[]{true, new Object[]{"XXX", "Y Y", "XXX", Character.valueOf('Y'), BlockRegister.MECH_ACCESSOR, Character.valueOf('X'), new ItemStack(BlockRegister.WALL_CAMINITE_BRICK)}}).setRegistryName(RecipeRegistry.getRL("stone_valve")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mixer"), new ItemStack(BlockRegister.MIXER, 1), new Object[]{true, new Object[]{"PPP", "PCP", "IMI", Character.valueOf('P'), "plateIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('M'), BlockRegister.MECH_CORE, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("mixer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("heat_coil"), new ItemStack(BlockRegister.HEAT_COIL, 1), new Object[]{true, new Object[]{"PPP", "IBI", " M ", Character.valueOf('P'), "plateCopper", Character.valueOf('B'), "blockCopper", Character.valueOf('M'), BlockRegister.MECH_CORE, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("heat_coil")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_dropper"), new ItemStack(BlockRegister.ITEM_DROPPER, 1), new Object[]{true, new Object[]{" P ", "I I", Character.valueOf('P'), BlockRegister.ITEM_PIPE, Character.valueOf('I'), "ingotLead"}}).setRegistryName(RecipeRegistry.getRL("item_dropper")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("fluid_dropper"), new ItemStack(BlockRegister.FLUID_DROPPER, 1), new Object[]{true, new Object[]{" P ", "I I", Character.valueOf('P'), BlockRegister.PIPE, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("fluid_dropper")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("large_tank"), new ItemStack(BlockRegister.LARGE_TANK, 1), new Object[]{true, new Object[]{"Y Y", "I I", "YTY", Character.valueOf('Y'), BlockRegister.STAIRS_CAMINITE_BRICK, Character.valueOf('I'), "ingotIron", Character.valueOf('T'), BlockRegister.BLOCK_TANK}}).setRegistryName(RecipeRegistry.getRL("large_tank")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_gauge"), new ItemStack(BlockRegister.EMBER_GAUGE, 1), new Object[]{true, new Object[]{"B", "P", "C", Character.valueOf('P'), Items.PAPER, Character.valueOf('B'), "dustRedstone", Character.valueOf('C'), "plateCopper"}}).setRegistryName(RecipeRegistry.getRL("ember_gauge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("fluid_gauge"), new ItemStack(BlockRegister.FLUID_GAUGE, 1), new Object[]{true, new Object[]{"B", "P", "I", Character.valueOf('P'), Items.PAPER, Character.valueOf('I'), "plateIron", Character.valueOf('B'), "dustRedstone"}}).setRegistryName(RecipeRegistry.getRL("fluid_gauge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_lantern"), new ItemStack(BlockRegister.BLOCK_LANTERN, 4), new Object[]{true, new Object[]{"P", "E", "I", Character.valueOf('E'), ItemRegister.SHARD_EMBER, Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("block_lantern")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("tinker_hammer"), new ItemStack(ItemRegister.TINKER_HAMMER, 1), new Object[]{true, new Object[]{"IBI", "ISI", " S ", Character.valueOf('B'), "ingotLead", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("tinker_hammer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_detector"), new ItemStack(ItemRegister.EMBER_DETECTOR, 1), new Object[]{true, new Object[]{" I ", "CRC", "CIC", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"}}).setRegistryName(RecipeRegistry.getRL("ember_detector")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("beam_splitter"), new ItemStack(BlockRegister.BEAM_SPLITTER, 1), new Object[]{true, new Object[]{" D ", "CPC", " I ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron", Character.valueOf('D'), "ingotDawnstone"}}).setRegistryName(RecipeRegistry.getRL("beam_splitter")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_relay"), new ItemStack(BlockRegister.EMBER_RELAY, 4), new Object[]{true, new Object[]{" C ", "C C", " P ", Character.valueOf('C'), "ingotCopper", Character.valueOf('P'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("ember_relay")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("crystal_cell"), new ItemStack(BlockRegister.CRYSTAL_CELL, 1), new Object[]{true, new Object[]{" E ", "DED", "CBC", Character.valueOf('C'), "blockCopper", Character.valueOf('B'), "blockDawnstone", Character.valueOf('D'), "plateDawnstone", Character.valueOf('E'), ItemRegister.CRYSTAL_EMBER}}).setRegistryName(RecipeRegistry.getRL("crystal_cell")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_jar"), new ItemStack(ItemRegister.EMBER_JAR, 1), new Object[]{true, new Object[]{" C ", "ISI", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), ItemRegister.SHARD_EMBER, Character.valueOf('C'), "ingotCopper", Character.valueOf('G'), "blockGlass"}}).setRegistryName(RecipeRegistry.getRL("ember_jar")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_cartridge"), new ItemStack(ItemRegister.EMBER_CARTRIDGE, 1), new Object[]{true, new Object[]{"ICI", "GSG", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), ItemRegister.CRYSTAL_EMBER, Character.valueOf('C'), "plateCopper", Character.valueOf('G'), "blockGlass"}}).setRegistryName(RecipeRegistry.getRL("ember_cartridge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("charger"), new ItemStack(BlockRegister.CHARGER, 1), new Object[]{true, new Object[]{" X ", "DCD", "IPI", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('P'), "plateCopper", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron", Character.valueOf('X'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("charger")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("axe_clockwork"), new ItemStack(ItemRegister.AXE_CLOCKWORK, 1), new Object[]{true, new Object[]{"PCP", "ISI", " W ", Character.valueOf('C'), "plateCopper", Character.valueOf('P'), "plateDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('S'), ItemRegister.SHARD_EMBER, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("axe_clockwork")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("pickaxe_clockwork"), new ItemStack(ItemRegister.PICKAXE_CLOCKWORK, 1), new Object[]{true, new Object[]{"ISI", " C ", " W ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('S'), ItemRegister.SHARD_EMBER, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("pickaxe_clockwork")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("grandhammer"), new ItemStack(ItemRegister.GRANDHAMMER, 1), new Object[]{true, new Object[]{"BIB", " C ", " W ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), "blockDawnstone", Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("grandhammer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("staff_ember"), new ItemStack(ItemRegister.STAFF_EMBER, 1), new Object[]{true, new Object[]{"SES", "IWI", " W ", Character.valueOf('S'), "plateSilver", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('E'), ItemRegister.SHARD_EMBER, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("staff_ember")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ignition_cannon"), new ItemStack(ItemRegister.IGNITION_CANNON, 1), new Object[]{true, new Object[]{" DP", "DPI", "SW ", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('P'), "plateDawnstone", Character.valueOf('S'), ItemRegister.SHARD_EMBER, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("ignition_cannon")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("cinder_plinth"), new ItemStack(BlockRegister.CINDER_PLINTH, 1), new Object[]{true, new Object[]{" P ", "SFS", "PBP", Character.valueOf('P'), "plateLead", Character.valueOf('B'), BlockRegister.BLOCK_CAMINITE_BRICK, Character.valueOf('S'), "ingotSilver", Character.valueOf('F'), Blocks.FURNACE}}).setRegistryName(RecipeRegistry.getRL("cinder_plinth")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("alchemy_pedestal"), new ItemStack(BlockRegister.ALCHEMY_PEDESTAL, 1), new Object[]{true, new Object[]{"D D", "ICI", "SBS", Character.valueOf('D'), "plateDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), "blockCopper", Character.valueOf('S'), BlockRegister.STAIRS_CAMINITE_BRICK, Character.valueOf('C'), ItemRegister.CRYSTAL_EMBER}}).setRegistryName(RecipeRegistry.getRL("alchemy_pedestal")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("alchemy_tablet"), new ItemStack(BlockRegister.ALCHEMY_TABLET, 1), new Object[]{true, new Object[]{" D ", "SXS", "BIB", Character.valueOf('D'), "plateDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), BlockRegister.BLOCK_CAMINITE_BRICK, Character.valueOf('S'), BlockRegister.STAIRS_CAMINITE_BRICK, Character.valueOf('X'), "plateCopper"}}).setRegistryName(RecipeRegistry.getRL("alchemy_tablet")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_transfer"), new ItemStack(BlockRegister.ITEM_TRANSFER, 4), new Object[]{true, new Object[]{"PLP", "ILI", "I I", Character.valueOf('P'), "plateLead", Character.valueOf('I'), "ingotLead", Character.valueOf('L'), BlockRegister.ITEM_PIPE}}).setRegistryName(RecipeRegistry.getRL("item_transfer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("fluid_transfer"), new ItemStack(BlockRegister.FLUID_TRANSFER, 4), new Object[]{true, new Object[]{"PLP", "ILI", "I I", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), BlockRegister.PIPE}}).setRegistryName(RecipeRegistry.getRL("fluid_transfer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("beam_cannon"), new ItemStack(BlockRegister.BEAM_CANNON, 1), new Object[]{true, new Object[]{"PSP", "PSP", "IBI", Character.valueOf('S'), ItemRegister.CRYSTAL_EMBER, Character.valueOf('P'), "plateCopper", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("beam_cannon")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_head"), new ItemStack(ItemRegister.ASHEN_CLOAK_HEAD, 1), new Object[]{true, new Object[]{" S ", "C C", "DCD", Character.valueOf('S'), "string", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('C'), ItemRegister.ASHEN_CLOTH}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_head")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_chest"), new ItemStack(ItemRegister.ASHEN_CLOAK_CHEST, 1), new Object[]{true, new Object[]{"P P", "CDC", "CDC", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('P'), "plateDawnstone", Character.valueOf('C'), ItemRegister.ASHEN_CLOTH}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_chest")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_legs"), new ItemStack(ItemRegister.ASHEN_CLOAK_LEGS, 1), new Object[]{true, new Object[]{"CCC", "D D", "D D", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('C'), ItemRegister.ASHEN_CLOTH}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_legs")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_boots"), new ItemStack(ItemRegister.ASHEN_CLOAK_BOOTS, 1), new Object[]{true, new Object[]{"C C", "C C", "C C", Character.valueOf('C'), ItemRegister.ASHEN_CLOTH}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_boots")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("sealed_planks"), new ItemStack(BlockRegister.SEALED_PLANKS, 8), new Object[]{true, new Object[]{"PPP", "PSP", "PPP", Character.valueOf('S'), "slimeball", Character.valueOf('P'), "plankWood"}}).setRegistryName(RecipeRegistry.getRL("sealed_planks")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("wrapped_sealed_planks"), new ItemStack(BlockRegister.WRAPPED_SEALED_PLANKS, 1), new Object[]{Blocks.IRON_BARS, BlockRegister.SEALED_PLANKS}).setRegistryName(RecipeRegistry.getRL("wrapped_sealed_planks")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_bricks"), new ItemStack(BlockRegister.ARCHAIC_BRICKS, 1), new Object[]{true, new Object[]{"BB", "BB", Character.valueOf('B'), ItemRegister.ARCHAIC_BRICK}}).setRegistryName(RecipeRegistry.getRL("archaic_bricks")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_light"), new ItemStack(BlockRegister.ARCHAIC_LIGHT, 1), new Object[]{true, new Object[]{" B ", "BSB", " B ", Character.valueOf('B'), ItemRegister.ARCHAIC_BRICK, Character.valueOf('S'), ItemRegister.SHARD_EMBER}}).setRegistryName(RecipeRegistry.getRL("archaic_light")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("dawnstone_anvil"), new ItemStack(BlockRegister.DAWNSTONE_ANVIL, 1), new Object[]{true, new Object[]{"BBB", "cIc", "CCC", Character.valueOf('B'), "blockDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('C'), BlockRegister.BLOCK_CAMINITE_BRICK, Character.valueOf('c'), ItemRegister.BRICK_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("dawnstone_anvil")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("auto_hammer"), new ItemStack(BlockRegister.AUTO_HAMMER, 1), new Object[]{true, new Object[]{"cc ", "CIB", "cc ", Character.valueOf('B'), "blockIron", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "blockCopper", Character.valueOf('c'), BlockRegister.STAIRS_CAMINITE_BRICK}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL("auto_hammer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("vacuum"), new ItemStack(BlockRegister.VACUUM, 1), new Object[]{true, new Object[]{" LL", "P  ", " LL", Character.valueOf('P'), BlockRegister.ITEM_PIPE, Character.valueOf('L'), "ingotLead"}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL("vacuum")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_edge"), new ItemStack(BlockRegister.ARCHAIC_EDGE, 2), new Object[]{true, new Object[]{"BBB", "BCB", "BBB", Character.valueOf('B'), ItemRegister.ARCHAIC_BRICK, Character.valueOf('C'), ItemRegister.SHARD_EMBER}}).setRegistryName(RecipeRegistry.getRL("archaic_edge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_tile"), new ItemStack(BlockRegister.ARCHAIC_TILE, 4), new Object[]{true, new Object[]{"BB", "BB", Character.valueOf('B'), BlockRegister.ARCHAIC_BRICKS}}).setRegistryName(RecipeRegistry.getRL("archaic_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_bricks"), new ItemStack(BlockRegister.ARCHAIC_BRICKS, 4), new Object[]{true, new Object[]{"BB", "BB", Character.valueOf('B'), BlockRegister.ARCHAIC_TILE}}).setRegistryName(RecipeRegistry.getRL("archaic_bricks_2")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("breaker"), new ItemStack(BlockRegister.BREAKER, 1), new Object[]{true, new Object[]{"PIP", "LRL", "L L", Character.valueOf('P'), "plateIron", Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('L'), "ingotLead", Character.valueOf('R'), Items.REDSTONE}}).setRegistryName(RecipeRegistry.getRL("breaker")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_injector"), new ItemStack(BlockRegister.EMBER_INJECTOR, 1), new Object[]{true, new Object[]{"S S", "DCD", "BPB", Character.valueOf('P'), "plateSilver", Character.valueOf('S'), "ingotSilver", Character.valueOf('D'), "plateDawnstone", Character.valueOf('B'), BlockRegister.BLOCK_CAMINITE_BRICK, Character.valueOf('C'), ItemRegister.WILDFIRE_CORE}}).setRegistryName(RecipeRegistry.getRL("ember_injector")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("boiler"), new ItemStack(BlockRegister.BOILER, 1), new Object[]{true, new Object[]{"CCC", "IFI", "IBI", Character.valueOf('B'), "blockCopper", Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('C'), "ingotCopper", Character.valueOf('F'), Blocks.FURNACE}}).setRegistryName(RecipeRegistry.getRL("boiler")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("reactor"), new ItemStack(BlockRegister.REACTOR, 1), new Object[]{true, new Object[]{"CCC", "CWC", "SBS", Character.valueOf('B'), BlockRegister.BLOCK_CAMINITE_BRICK, Character.valueOf('W'), ItemRegister.WILDFIRE_CORE, Character.valueOf('C'), "ingotCopper", Character.valueOf('S'), "plateSilver"}}).setRegistryName(RecipeRegistry.getRL("reactor")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("combustor"), new ItemStack(BlockRegister.COMBUSTOR, 1), new Object[]{true, new Object[]{" C ", "PEP", "CMC", Character.valueOf('M'), BlockRegister.MECH_CORE, Character.valueOf('P'), "plateCopper", Character.valueOf('C'), "ingotCopper", Character.valueOf('E'), ItemRegister.EMBER_CLUSTER}}).setRegistryName(RecipeRegistry.getRL("combustor")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("catalyzer"), new ItemStack(BlockRegister.CATALYZER, 1), new Object[]{true, new Object[]{" C ", "PEP", "CMC", Character.valueOf('M'), BlockRegister.MECH_CORE, Character.valueOf('P'), "plateSilver", Character.valueOf('C'), "ingotSilver", Character.valueOf('E'), ItemRegister.EMBER_CLUSTER}}).setRegistryName(RecipeRegistry.getRL("catalyzer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("codex"), new ItemStack(ItemRegister.CODEX, 1), new Object[]{true, new Object[]{" B ", " E ", " B ", Character.valueOf('B'), ItemRegister.ARCHAIC_BRICK, Character.valueOf('E'), ItemRegister.ANCIENT_MOTIVE_CORE}}).setRegistryName(RecipeRegistry.getRL("codex")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("field_chart"), new ItemStack(BlockRegister.FIELD_CHART, 1), new Object[]{true, new Object[]{"BBB", "BCB", "BBB", Character.valueOf('B'), ItemRegister.ARCHAIC_BRICK, Character.valueOf('C'), ItemRegister.EMBER_CLUSTER}}).setRegistryName(RecipeRegistry.getRL("field_chart")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_circuit"), new ItemStack(ItemRegister.ARCHAIC_CIRCUIT, 1), new Object[]{true, new Object[]{" B ", "BCB", " B ", Character.valueOf('B'), ItemRegister.ARCHAIC_BRICK, Character.valueOf('C'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("archaic_circuit")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("inferno_forge"), new ItemStack(BlockRegister.INFERNO_FORGE, 1), new Object[]{true, new Object[]{"BPB", "DCD", "SWS", Character.valueOf('B'), BlockRegister.BLOCK_DAWNSTONE, Character.valueOf('D'), "ingotDawnstone", Character.valueOf('C'), "blockCopper", Character.valueOf('W'), ItemRegister.WILDFIRE_CORE, Character.valueOf('P'), "plateIron", Character.valueOf('S'), BlockRegister.BLOCK_CAMINITE_BRICK}}).setRegistryName(RecipeRegistry.getRL("inferno_forge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("superheater"), new ItemStack(ItemRegister.SUPERHEATER, 1), new Object[]{true, new Object[]{" ID", "PPI", "PP ", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('D'), "plateDawnstone", Character.valueOf('P'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("superheater")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("resonating_bell"), new ItemStack(ItemRegister.RESONATING_BELL, 1), new Object[]{true, new Object[]{"IIP", " sI", "S I", Character.valueOf('I'), "ingotIron", Character.valueOf('s'), "ingotSilver", Character.valueOf('P'), "plateIron", Character.valueOf('S'), "plateSilver"}}).setRegistryName(RecipeRegistry.getRL("resonating_bell")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("jet_augment"), new ItemStack(ItemRegister.JET_AUGMENT, 1), new Object[]{true, new Object[]{"PP ", "IsD", "PP ", Character.valueOf('I'), "ingotIron", Character.valueOf('s'), ItemRegister.SHARD_EMBER, Character.valueOf('P'), "plateDawnstone", Character.valueOf('D'), "ingotDawnstone"}}).setRegistryName(RecipeRegistry.getRL("jet_augment")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("caster_orb"), new ItemStack(ItemRegister.CASTER_ORB, 1), new Object[]{true, new Object[]{"DCD", "D D", " P ", Character.valueOf('C'), ItemRegister.CRYSTAL_EMBER, Character.valueOf('P'), "plateDawnstone", Character.valueOf('D'), "ingotDawnstone"}}).setRegistryName(RecipeRegistry.getRL("caster_orb")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_pulser"), new ItemStack(BlockRegister.EMBER_PULSER, 1), new Object[]{true, new Object[]{"D", "E", "I", Character.valueOf('E'), BlockRegister.EMBER_EMITTER, Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "plateDawnstone"}}).setRegistryName(RecipeRegistry.getRL("ember_pulser")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_funnel"), new ItemStack(BlockRegister.EMBER_FUNNEL, 1), new Object[]{true, new Object[]{"D D", "CRC", " D ", Character.valueOf('R'), BlockRegister.EMBER_RECEIVER, Character.valueOf('C'), "ingotCopper", Character.valueOf('D'), "plateDawnstone"}}).setRegistryName(RecipeRegistry.getRL("ember_funnel")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("caminite_lever"), new ItemStack(BlockRegister.CAMINITE_LEVER, 4), new Object[]{true, new Object[]{"S", "P", Character.valueOf('S'), "stickWood", Character.valueOf('P'), new ItemStack(ItemRegister.PLATE_CAMINITE)}}).setRegistryName(RecipeRegistry.getRL("caminite_lever")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mini_boiler"), new ItemStack(BlockRegister.MINI_BOILER, 1), new Object[]{true, new Object[]{"PPP", "E P", "PPP", Character.valueOf('E'), "ingotCopper", Character.valueOf('P'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("mini_boiler")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("diffraction_barrel"), new ItemStack(ItemRegister.DIFFRACTION_BARREL, 1), new Object[]{true, new Object[]{"XPI", Character.valueOf('X'), Blocks.IRON_BARS, Character.valueOf('P'), "plateIron", Character.valueOf('I'), ItemRegister.SUPERHEATER}}).setRegistryName(RecipeRegistry.getRL("diffraction_barrel")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mechanical_pump"), new ItemStack(BlockRegister.MECHANICAL_PUMP, 1), new Object[]{true, new Object[]{"EPE", "PPP", "BIB", Character.valueOf('E'), BlockRegister.PIPE, Character.valueOf('I'), BlockRegister.PUMP, Character.valueOf('P'), "plateIron", Character.valueOf('B'), ItemRegister.BRICK_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("mechanical_pump")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("tinker_lens"), new ItemStack(ItemRegister.TINKER_LENS, 1), new Object[]{true, new Object[]{"BE ", "IPE", "BE ", Character.valueOf('E'), "nuggetLead", Character.valueOf('I'), "plateLead", Character.valueOf('P'), "paneGlass", Character.valueOf('B'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("tinker_lens")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("anti_tinker_lens"), new ItemStack(ItemRegister.ANTI_TINKER_LENS, 1), new Object[]{true, new Object[]{" A ", "APA", " A ", Character.valueOf('P'), ItemRegister.TINKER_LENS, Character.valueOf('A'), "dustAsh"}}).setRegistryName(RecipeRegistry.getRL("anti_tinker_lens")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("glimmer_lamp"), new ItemStack(ItemRegister.GLIMMER_LAMP, 1), new Object[]{true, new Object[]{" P ", "XGX", " P ", Character.valueOf('G'), ItemRegister.GLIMMER_SHARD, Character.valueOf('X'), Blocks.IRON_BARS, Character.valueOf('P'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("glimmer_lamp")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_siphon"), new ItemStack(BlockRegister.EMBER_SIPHON, 1), new Object[]{true, new Object[]{"PGP", "XGX", "BBB", Character.valueOf('G'), "ingotCopper", Character.valueOf('X'), "plateNickel", Character.valueOf('P'), new ItemStack(BlockRegister.WALL_CAMINITE_BRICK), Character.valueOf('B'), ItemRegister.BRICK_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("ember_siphon")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stirling"), new ItemStack(BlockRegister.STIRLING, 1), new Object[]{true, new Object[]{"XGX", "XGX", "BPB", Character.valueOf('G'), "blockCopper", Character.valueOf('X'), "plateDawnstone", Character.valueOf('P'), ItemRegister.WILDFIRE_CORE, Character.valueOf('B'), ItemRegister.SHARD_EMBER}}).setRegistryName(RecipeRegistry.getRL("stirling")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("clockwork_attenuator"), new ItemStack(BlockRegister.CLOCKWORK_ATTENUATOR, 1), new Object[]{true, new Object[]{"GBG", " P ", "GIG", Character.valueOf('P'), Items.PAPER, Character.valueOf('I'), "plateElectrum", Character.valueOf('B'), "dustRedstone", Character.valueOf('G'), "nuggetElectrum"}}).setRegistryName(RecipeRegistry.getRL("clockwork_attenuator")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("geo_separator"), new ItemStack(BlockRegister.GEO_SEPARATOR, 1), new Object[]{true, new Object[]{"  B", "GIG", Character.valueOf('I'), BlockRegister.BLOCK_TANK, Character.valueOf('B'), "blockNickel", Character.valueOf('G'), ItemRegister.BRICK_CAMINITE}}).setRegistryName(RecipeRegistry.getRL("geo_separator")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("reaction_chamber"), new ItemStack(BlockRegister.REACTION_CHAMBER, 1), new Object[]{true, new Object[]{"DDD", "D D", "BIB", Character.valueOf('I'), ItemRegister.SPARK_PLUG, Character.valueOf('B'), "ingotBronze", Character.valueOf('D'), "plateBronze"}}).setRegistryName(RecipeRegistry.getRL("reaction_chamber")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("spark_plug"), new ItemStack(ItemRegister.SPARK_PLUG, 1), new Object[]{true, new Object[]{"N N", " I ", " B ", Character.valueOf('I'), "plateIron", Character.valueOf('B'), ItemRegister.ASPECTUS_SILVER, Character.valueOf('N'), "ingotAluminium"}}).setRegistryName(RecipeRegistry.getRL("spark_plug")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_request"), new ItemStack(BlockRegister.ITEM_REQUEST, 1), new Object[]{true, new Object[]{"ASA", "IPS", "ASA", Character.valueOf('P'), BlockRegister.ITEM_PUMP, Character.valueOf('I'), ItemRegister.INTELLIGENT_APPARATUS, Character.valueOf('S'), "plateSilver", Character.valueOf('A'), ItemRegister.ASPECTUS_SILVER}}).setRegistryName(RecipeRegistry.getRL("item_request")));
        event.getRegistry().register(new TankClearingRecipe(RecipeRegistry.getRL("block_tank_clear"), new ItemStack(BlockRegister.BLOCK_TANK)).setRegistryName(RecipeRegistry.getRL("block_tank_clear")));
        event.getRegistry().register(new AshenCloakSocketRecipe().setRegistryName(RecipeRegistry.getRL("cloak_socketing")));
        event.getRegistry().register(new AshenCloakUnsocketRecipe().setRegistryName(RecipeRegistry.getRL("cloak_unsocketing")));
        if (Util.isBaublesIntegrationEnabled()) {
            BaublesIntegration.registerRecipes(event);
        }
        if (Util.isMysticalMechanicsIntegrationEnabled()) {
            MysticalMechanicsIntegration.registerRecipes(event);
        }
        if (Util.isEnvironmentalTechIntegrationEnabled()) {
            EnvironmentalTechIntegration.registerRecipes(event);
        }
        if (Util.isTinkersIntegrationEnabled() && Util.isEnderIOIntegrationEnabled()) {
            EnderioIntegration.registerRecipes(event);
        }
        if (Util.isThaumcraftIntegrationEnabled()) {
            ThaumcraftIntegration.registerRecipes(event);
        }
        Alchemistry.INSTANCE.execute();
        Melting.INSTANCE.execute();
        Mixing.INSTANCE.execute();
        Reacting.INSTANCE.execute();
        Smelting.INSTANCE.execute();
        Smithing.INSTANCE.execute();
        Stamping.INSTANCE.execute();
        heatCoilRecipes.add(new HeatCoilFurnaceRecipe());
        FilterUtil.registerComparator(FilterUtil.ANY);
        FilterUtil.registerComparator(new ComparatorMatch("strict", 35){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.strict", (Object[])new Object[]{stack1.getDisplayName()});
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("normal", 30){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.isItemEqual(stack2);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.normal", (Object[])new Object[]{stack1.getDisplayName()});
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("item", 15){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.getItem() == stack2.getItem();
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.item", (Object[])new Object[]{stack1.getDisplayName()});
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("meta", 20){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.getHasSubtypes() && stack1.getMetadata() == stack2.getMetadata();
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.metadata", (Object[])new Object[]{stack1.getMetadata()});
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("nbt", 25){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.hasTagCompound() && ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.nbt", (Object[])new Object[0]);
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("name", 50){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.hasDisplayName() && stack2.hasDisplayName() && stack1.getDisplayName().equals(stack2.getDisplayName());
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.name", (Object[])new Object[]{stack1.getDisplayName()});
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("mod", 50){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                ResourceLocation resLoc1 = stack1.getItem().getRegistryName();
                ResourceLocation resLoc2 = stack2.getItem().getRegistryName();
                String s1 = resLoc1 != null ? resLoc1.getNamespace() : "";
                String s2 = resLoc2 != null ? resLoc2.getNamespace() : "";
                return s1.equals(s2);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.mod", (Object[])new Object[]{stack1.getItem().getRegistryName().getNamespace()});
            }
        });
        FilterUtil.registerComparator(new ComparatorNormal("durability", 30){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.isItemStackDamageable() && stack2.isItemStackDamageable();
            }

            @Override
            public Comparable getCompare(ItemStack stack) {
                return Integer.valueOf(stack.getMaxDamage() - stack.getItemDamage());
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                Comparable b;
                Comparable a = this.getCompare(stack1);
                String format = a.compareTo(b = this.getCompare(stack2)) != 0 ? I18n.format((String)"embers.filter.durability", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)}) : (setting == EnumFilterSetting.STRICT ? I18n.format((String)"embers.filter.durability.strict", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)}) : I18n.format((String)"embers.filter.durability.fuzzy", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)}));
                if (inverted) {
                    return I18n.format((String)"embers.filter.invert", (Object[])new Object[]{format});
                }
                return format;
            }
        });
        FilterUtil.registerComparator(new ComparatorNormal("fuel", 40){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return TileEntityFurnace.getItemBurnTime((ItemStack)stack1) > 0 && TileEntityFurnace.getItemBurnTime((ItemStack)stack2) > 0;
            }

            @Override
            public Comparable getCompare(ItemStack stack) {
                return Integer.valueOf(TileEntityFurnace.getItemBurnTime((ItemStack)stack));
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                Comparable b;
                Comparable a = this.getCompare(stack1);
                String format = a.compareTo(b = this.getCompare(stack2)) != 0 ? I18n.format((String)"embers.filter.fuel", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)}) : (setting == EnumFilterSetting.STRICT ? I18n.format((String)"embers.filter.fuel.strict", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)}) : I18n.format((String)"embers.filter.fuel.fuzzy", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)}));
                if (inverted) {
                    return I18n.format((String)"embers.filter.invert", (Object[])new Object[]{format});
                }
                return format;
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("has_fluid", 120){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && stack2.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.has_fluid", (Object[])new Object[0]);
            }
        });
        FilterUtil.registerComparator(new ComparatorNormal("fluid", 125){

            private boolean areFluidsEqual(FluidStack a, FluidStack b) {
                if (a == null && b == null) {
                    return true;
                }
                return a != null && b != null && a.isFluidEqual(b);
            }

            private int getAmount(FluidStack fluid) {
                return fluid != null ? fluid.amount : 0;
            }

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                IFluidHandlerItem capability1 = FluidUtil.getFluidHandler((ItemStack)stack1);
                IFluidHandlerItem capability2 = FluidUtil.getFluidHandler((ItemStack)stack2);
                if (capability1 != null && capability2 != null) {
                    FluidStack fluid1 = capability1.drain(Integer.MAX_VALUE, false);
                    FluidStack fluid2 = capability2.drain(Integer.MAX_VALUE, false);
                    return this.areFluidsEqual(fluid1, fluid2);
                }
                return false;
            }

            @Override
            public Comparable getCompare(ItemStack stack) {
                IFluidHandlerItem capability = FluidUtil.getFluidHandler((ItemStack)stack);
                assert (capability != null);
                FluidStack fluid = capability.drain(Integer.MAX_VALUE, false);
                return Integer.valueOf(this.getAmount(fluid));
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                String name;
                IFluidHandlerItem capability = FluidUtil.getFluidHandler((ItemStack)stack1);
                assert (capability != null);
                FluidStack fluid = capability.drain(Integer.MAX_VALUE, false);
                Comparable a = this.getCompare(stack1);
                Comparable b = this.getCompare(stack2);
                String string = name = fluid != null ? fluid.getLocalizedName() : "";
                if (a.compareTo(b) != 0) {
                    return I18n.format((String)"embers.filter.fluid", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b), name});
                }
                if (setting == EnumFilterSetting.STRICT) {
                    return I18n.format((String)"embers.filter.fluid.strict", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b), name});
                }
                return I18n.format((String)"embers.filter.fluid.fuzzy", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b), name});
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("has_ember", 150){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && stack2.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.has_ember", (Object[])new Object[0]);
            }
        });
        FilterUtil.registerComparator(new ComparatorNormal("ember", 155){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && stack2.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            }

            @Override
            public Comparable getCompare(ItemStack stack) {
                if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
                    IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
                    assert (capability != null);
                    return Double.valueOf(capability.getEmber());
                }
                return Integer.valueOf(0);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                Comparable b;
                Comparable a = this.getCompare(stack1);
                if (a.compareTo(b = this.getCompare(stack2)) != 0) {
                    return I18n.format((String)"embers.filter.ember", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
                }
                if (setting == EnumFilterSetting.STRICT) {
                    return I18n.format((String)"embers.filter.ember.strict", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
                }
                return I18n.format((String)"embers.filter.ember.fuzzy", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
            }
        });
        FilterUtil.registerComparator(new ComparatorNormal("ember_fuel", 160){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return EmbersAPI.getEmberValue(stack1) > 0.0 && EmbersAPI.getEmberValue(stack2) > 0.0;
            }

            @Override
            public Comparable getCompare(ItemStack stack) {
                double ember = EmbersAPI.getEmberValue(stack);
                if (ember > 0.0) {
                    return Double.valueOf(ember);
                }
                return Integer.valueOf(0);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                Comparable b;
                Comparable a = this.getCompare(stack1);
                if (a.compareTo(b = this.getCompare(stack2)) != 0) {
                    return I18n.format((String)"embers.filter.ember_fuel", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
                }
                if (setting == EnumFilterSetting.STRICT) {
                    return I18n.format((String)"embers.filter.ember_fuel.strict", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
                }
                return I18n.format((String)"embers.filter.ember_fuel.fuzzy", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
            }
        });
        FilterUtil.registerComparator(new ComparatorMatch("has_forge_energy", 200){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.hasCapability(CapabilityEnergy.ENERGY, null) && stack2.hasCapability(CapabilityEnergy.ENERGY, null);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                return I18n.format((String)"embers.filter.has_forge_energy", (Object[])new Object[0]);
            }
        });
        FilterUtil.registerComparator(new ComparatorNormal("forge_energy", 205){

            @Override
            public boolean match(ItemStack stack1, ItemStack stack2) {
                return stack1.hasCapability(CapabilityEnergy.ENERGY, null) && stack2.hasCapability(CapabilityEnergy.ENERGY, null);
            }

            @Override
            public Comparable getCompare(ItemStack stack) {
                if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    IEnergyStorage capability = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                    assert (capability != null);
                    return Integer.valueOf(capability.getEnergyStored());
                }
                return Integer.valueOf(0);
            }

            @Override
            public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
                Comparable b;
                Comparable a = this.getCompare(stack1);
                if (a.compareTo(b = this.getCompare(stack2)) != 0) {
                    return I18n.format((String)"embers.filter.forge_energy", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
                }
                if (setting == EnumFilterSetting.STRICT) {
                    return I18n.format((String)"embers.filter.forge_energy.strict", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
                }
                return I18n.format((String)"embers.filter.forge_energy.fuzzy", (Object[])new Object[]{RecipeRegistry.this.min(a, b), RecipeRegistry.this.max(a, b)});
            }
        });
        FilterUtil.registerFilter(FilterUtil.FILTER_ANY);
        FilterUtil.registerFilter(FilterUtil.FILTER_EXISTING);
        FilterUtil.registerFilter(FilterUtil.FILTER_NOT_EXISTING);
        FilterUtil.registerFilter(FilterSieve.RESOURCE_LOCATION, FilterSieve::new);
        FilterUtil.registerFilter(FilterItem.RESOURCE_LOCATION, FilterItem::new);
    }

    private Comparable min(Comparable a, Comparable b) {
        if (a.compareTo(b) < 0) {
            return a;
        }
        return b;
    }

    private Comparable max(Comparable a, Comparable b) {
        if (a.compareTo(b) > 0) {
            return a;
        }
        return b;
    }

    public static BoreOutput getBoreOutput(World world, BlockPos pos) {
        int dimensionId = world.provider.getDimension();
        Biome biome = world.getBiome(pos);
        for (BoreOutput output : boreOutputSets) {
            if (!output.dimensionIds.contains(dimensionId) || !output.biomeIds.contains(biome.getRegistryName())) continue;
            return output;
        }
        return defaultBoreOutput;
    }

    public static ItemStampingRecipe getStampingRecipe(ItemStack input, FluidStack fluid, ItemStack stamp) {
        ItemStampingRecipe matchedRecipe = null;
        for (ItemStampingRecipe recipe : stampingRecipes) {
            if (!recipe.matches(input, fluid, stamp)) continue;
            matchedRecipe = recipe;
        }
        return matchedRecipe;
    }

    @Deprecated
    public static ItemStampingRecipe getStampingRecipe(ItemStack stack, FluidStack fluid, EnumStampType type) {
        for (ItemStampingRecipe stampingRecipe : stampingRecipes) {
            if (!stampingRecipe.matches(stack, fluid, type)) continue;
            return stampingRecipe;
        }
        return null;
    }

    @Deprecated
    public static ItemStampingOreRecipe getStampingOreRecipe(ItemStack stack, FluidStack fluid, EnumStampType type) {
        for (ItemStampingOreRecipe stampingOreRecipe : stampingOreRecipes) {
            if (!stampingOreRecipe.matches(stack, fluid, type)) continue;
            return stampingOreRecipe;
        }
        return null;
    }

    public static ItemMeltingRecipe getMeltingRecipe(ItemStack stack) {
        for (ItemMeltingRecipe meltingRecipe : meltingRecipes) {
            if (!meltingRecipe.matches(stack)) continue;
            return meltingRecipe;
        }
        return null;
    }

    @Deprecated
    public static ItemMeltingOreRecipe getMeltingOreRecipe(ItemStack stack) {
        for (ItemMeltingOreRecipe meltingOreRecipe : meltingOreRecipes) {
            if (!meltingOreRecipe.matches(stack)) continue;
            return meltingOreRecipe;
        }
        return null;
    }

    public static FluidMixingRecipe getMixingRecipe(ArrayList<FluidStack> fluids) {
        for (FluidMixingRecipe mixingRecipe : mixingRecipes) {
            if (!mixingRecipe.matches(fluids)) continue;
            return mixingRecipe;
        }
        return null;
    }

    public static FluidReactionRecipe getFluidReactionRecipe(FluidStack fluid) {
        for (FluidReactionRecipe fluidReactionRecipe : fluidReactionRecipes) {
            if (!fluidReactionRecipe.matches(fluid)) continue;
            return fluidReactionRecipe;
        }
        return null;
    }

    public static AlchemyRecipe getAlchemyRecipe(ItemStack center, List<ItemStack> outside) {
        AlchemyRecipe matchedRecipe = null;
        for (AlchemyRecipe recipe : alchemyRecipes) {
            if (!recipe.matches(center, outside) || matchedRecipe != null && recipe.outsideIngredients.size() <= matchedRecipe.outsideIngredients.size()) continue;
            matchedRecipe = recipe;
        }
        return matchedRecipe;
    }

    @Deprecated
    public static AlchemyRecipe getAlchemyRecipe(ItemStack center, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
        return RecipeRegistry.getAlchemyRecipe(center, Lists.newArrayList((Object[])new ItemStack[]{stack1, stack2, stack3, stack4}));
    }

    public static DawnstoneAnvilRecipe getDawnstoneAnvilRecipe(ItemStack bottom, ItemStack top) {
        for (DawnstoneAnvilRecipe recipe : dawnstoneAnvilRecipes) {
            if (!recipe.matches(bottom, top)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isBlacklistedFromRepair(ItemStack stack) {
        return dawnstoneRepairBlacklist.stream().anyMatch(ingredient -> ingredient.apply(stack));
    }

    public static boolean isBlacklistedFromMateriaRepair(ItemStack stack) {
        return dawnstoneMateriaBlacklist.stream().anyMatch(ingredient -> ingredient.apply(stack));
    }

    public static boolean isBlacklistedFromBreakdown(ItemStack stack) {
        return dawnstoneBreakdownBlacklist.stream().anyMatch(ingredient -> ingredient.apply(stack));
    }

    public static HeatCoilRecipe getHeatCoilRecipe(ItemStack input) {
        for (HeatCoilRecipe recipe : heatCoilRecipes) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    @Nonnull
    public static ItemStack getItemStackFromOreDict(String name, int amount) {
        ItemStack stack = ((ItemStack)OreDictionary.getOres((String)name).get(0)).copy();
        stack.setCount(amount);
        return stack;
    }

    static {
        INGOT_AMOUNT = ConfigMisc.ingotFluidAmount;
        NUGGET_AMOUNT = ConfigMisc.nuggetFluidAmount;
        plateAmount = ConfigMachine.STAMPER.stampPlateAmount * INGOT_AMOUNT;
        rodAmount = INGOT_AMOUNT / ConfigMachine.STAMPER.stampRodAmount;
        oreMeltAmount = ConfigMachine.MELTER.melterOreAmount * INGOT_AMOUNT;
    }

    public static class CreativeHeatRecipe
    extends DawnstoneAnvilRecipe
    implements IWrappableRecipe {
        @Override
        public boolean matches(ItemStack input1, ItemStack input2) {
            return ItemModUtil.hasHeat(input1) && input2.getItem() == ItemRegister.CREATIVE_HEAT;
        }

        @Override
        public List<ItemStack> getResult(TileEntity tile, ItemStack input1, ItemStack input2) {
            ItemStack result = input1.copy();
            ItemModUtil.setHeat(result, ItemModUtil.getMaxHeat(result));
            return Lists.newArrayList((Object[])new ItemStack[]{result});
        }

        public List<DawnstoneAnvilRecipe> getWrappers() {
            return Lists.newArrayList();
        }
    }
}

