/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.IFocusRecipe;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.util.IngredientSpecial;
import teamroots.embers.util.ItemModUtil;

public class AnvilAddCoreRecipe
extends DawnstoneAnvilRecipe
implements IFocusRecipe {
    public AnvilAddCoreRecipe() {
        super(new IngredientSpecial(ItemModUtil::canAnyModifierApply), Ingredient.fromItem((Item)ItemRegister.ANCIENT_MOTIVE_CORE), new ItemStack[0]);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.getBottomInputs().stream().map(stack -> {
            ItemStack output = stack.copy();
            teamroots.embers.api.itemmod.ItemModUtil.addModifier(output, new ItemStack(ItemRegister.ANCIENT_MOTIVE_CORE));
            return output;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean matches(ItemStack input1, ItemStack input2) {
        ModifierBase modifier = teamroots.embers.api.itemmod.ItemModUtil.getModifier(input2);
        return input2.getItem() == ItemRegister.ANCIENT_MOTIVE_CORE && (!teamroots.embers.api.itemmod.ItemModUtil.hasHeat(input1) || !teamroots.embers.api.itemmod.ItemModUtil.hasModifier(input1, modifier)) && modifier.canApplyTo(input1);
    }

    @Override
    public List<ItemStack> getResult(TileEntity tile, ItemStack input1, ItemStack input2) {
        ItemStack result = input1.copy();
        teamroots.embers.api.itemmod.ItemModUtil.addModifier(result, input2);
        return Lists.newArrayList((Object[])new ItemStack[]{result});
    }

    @Override
    public List<ItemStack> getOutputs(IFocus<ItemStack> focus, int slot) {
        if (slot == 2) {
            ItemStack output = ((ItemStack)focus.getValue()).copy();
            teamroots.embers.api.itemmod.ItemModUtil.addModifier(output, new ItemStack(ItemRegister.ANCIENT_MOTIVE_CORE));
            return Lists.newArrayList((Object[])new ItemStack[]{output});
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItemStack> getInputs(IFocus<ItemStack> focus, int slot) {
        if (slot == 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)focus.getValue()});
        }
        if (slot == 1) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemRegister.ANCIENT_MOTIVE_CORE)});
        }
        return Lists.newArrayList();
    }
}

