/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.particle;

import java.awt.Color;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import teamroots.embers.config.ConfigClient;
import teamroots.embers.particle.IEmberParticle;
import teamroots.embers.particle.ParticleUtil;

public class ParticleFireBlast
extends Particle
implements IEmberParticle {
    Color color;

    public ParticleFireBlast(World worldIn, double posXIn, double posYIn, double posZIn, Color color, float scale, int lifetime) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.color = color;
        this.particleScale = scale;
        this.particleMaxAge = lifetime;
        this.canCollide = ConfigClient.enableParticleCollisions;
    }

    public void onUpdate() {
        super.onUpdate();
        float lifeCoeff = (float)this.particleAge / (float)this.particleMaxAge;
        float flameSize = this.particleScale * 1.5f;
        for (int i = 0; i < 60; ++i) {
            double yaw = this.rand.nextDouble() * Math.PI * 2.0;
            double pitch = this.rand.nextDouble() * Math.PI * 2.0;
            float dist = 0.2f;
            float dx = (float)(Math.sin(yaw) * Math.cos(pitch));
            float dy = (float)Math.sin(pitch);
            float dz = (float)(Math.cos(yaw) * Math.cos(pitch));
            float endDist = this.particleScale * 2.0f * (float)Math.sqrt(1.0f - lifeCoeff);
            int lifetime = 5 + this.rand.nextInt(45);
            float velocityFactor = endDist / (float)lifetime;
            float scale = flameSize * (float)Math.sqrt(lifeCoeff);
            ParticleUtil.spawnParticleGlow(this.world, (float)this.posX + dx * dist, (float)this.posY - 0.1f + dy * dist, (float)this.posZ + dz * dist, dx * (velocityFactor *= -1.0f), dy * velocityFactor + this.particleScale / (float)lifetime, dz * velocityFactor, this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (float)this.color.getAlpha() / 255.0f, scale, lifetime);
        }
    }

    public void renderParticle(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
    }

    @Override
    public boolean alive() {
        return this.particleAge < this.particleMaxAge;
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public boolean renderThroughBlocks() {
        return false;
    }
}

