/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.tileentity.TileEntityBeamCannon;
import teamroots.embers.util.Misc;

public class ModelBeamCannon
extends ModelBase {
    ModelRenderer base;
    ModelRenderer disc1;
    ModelRenderer disc2;
    ModelRenderer disc3;
    ModelRenderer disc4;

    public ModelBeamCannon() {
        this.textureWidth = 32;
        this.textureHeight = 32;
        this.base = new ModelRenderer((ModelBase)this, 0, 0);
        this.base.addBox(-2.5f, -2.5f, -2.5f, 5, 5, 5);
        this.base.setRotationPoint(0.0f, 16.0f, 0.0f);
        this.base.setTextureSize(32, 32);
        this.base.mirror = true;
        this.setRotation(this.base, 0.0f, 0.0f, 0.0f);
        this.disc1 = new ModelRenderer((ModelBase)this, 0, 10);
        this.disc1.addBox(-3.0f, -10.0f, -3.0f, 6, 2, 6);
        this.disc1.setRotationPoint(0.0f, 16.0f, 0.0f);
        this.disc1.setTextureSize(32, 32);
        this.disc1.mirror = true;
        this.setRotation(this.disc1, 0.0f, 0.0f, 0.0f);
        this.disc2 = new ModelRenderer((ModelBase)this, 0, 18);
        this.disc2.addBox(-2.0f, -12.0f, -2.0f, 4, 10, 4);
        this.disc2.setRotationPoint(0.0f, 16.0f, 0.0f);
        this.disc2.setTextureSize(32, 32);
        this.disc2.mirror = true;
        this.setRotation(this.disc2, 0.0f, 0.0f, 0.0f);
        this.disc3 = new ModelRenderer((ModelBase)this, 0, 10);
        this.disc3.addBox(-3.0f, -4.0f, -3.0f, 6, 2, 6);
        this.disc3.setRotationPoint(0.0f, 16.0f, 0.0f);
        this.disc3.setTextureSize(32, 32);
        this.disc3.mirror = true;
        this.setRotation(this.disc3, 0.0f, 0.0f, 0.0f);
        this.disc4 = new ModelRenderer((ModelBase)this, 0, 10);
        this.disc4.addBox(-3.0f, -7.0f, -3.0f, 6, 2, 6);
        this.disc4.setRotationPoint(0.0f, 16.0f, 0.0f);
        this.disc4.setTextureSize(32, 32);
        this.disc4.mirror = true;
        this.setRotation(this.disc4, 0.0f, 0.0f, 0.0f);
    }

    public void render(TileEntityBeamCannon tile, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (tile.target != null) {
            yaw = Misc.yawDegreesBetweenPoints(tile.getPos().getX(), tile.getPos().getY(), tile.getPos().getZ(), tile.target.getX(), tile.target.getY(), tile.target.getZ());
            pitch = Misc.pitchDegreesBetweenPoints(tile.getPos().getX(), tile.getPos().getY(), tile.getPos().getZ(), tile.target.getX(), tile.target.getY(), tile.target.getZ());
            this.base.rotateAngleY = (float)Math.toRadians(yaw);
            this.base.rotateAngleX = (float)Math.toRadians(pitch);
            this.disc1.rotateAngleY = (float)Math.toRadians(yaw);
            this.disc1.rotateAngleX = (float)Math.toRadians(pitch);
            this.disc2.rotateAngleY = (float)Math.toRadians(yaw);
            this.disc2.rotateAngleX = (float)Math.toRadians(pitch);
            this.disc3.rotateAngleY = (float)Math.toRadians(yaw);
            this.disc3.rotateAngleX = (float)Math.toRadians(pitch);
            this.disc4.rotateAngleY = (float)Math.toRadians(yaw);
            this.disc4.rotateAngleX = (float)Math.toRadians(pitch);
        }
        this.base.render(scale);
        this.disc1.render(scale);
        this.disc2.render(scale);
        this.disc3.render(scale);
        this.disc4.render(scale);
        GlStateManager.popMatrix();
    }

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        float speed = (float)Math.min(0.25, new Vec3d(entity.motionX, 0.0, entity.motionZ).length() * 4.0);
        super.render(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.base.render(scale);
        this.disc1.render(scale);
        this.disc2.render(scale);
        this.disc3.render(scale);
        this.disc4.render(scale);
        GlStateManager.popMatrix();
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5) {
        super.setRotationAngles(f, f1, f2, f3, f4, f5, null);
    }
}

