/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.Embers;
import teamroots.embers.item.IModeledItem;

public class ItemBlockSlab
extends ItemBlock
implements IModeledItem {
    Block doubleSlab;
    CreativeTabs tab;

    public ItemBlockSlab(Block block, Block doubleSlabBlock) {
        super(block);
        this.doubleSlab = doubleSlabBlock;
        this.setRegistryName(block.getRegistryName());
        this.tab = Embers.tab;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public CreativeTabs getCreativeTab() {
        return this.tab;
    }

    public void decrementHeldStack(EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (!player.capabilities.isCreativeMode) {
            stack.shrink(1);
            if (stack.getCount() == 0) {
                player.setItemStackToSlot(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.EMPTY);
            }
        }
    }

    public int getMetadata(int damage) {
        return damage;
    }

    public EnumActionResult onItemUse(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.getHeldItem(hand);
        if (stack.getCount() == 0) {
            return EnumActionResult.FAIL;
        }
        if (!playerIn.canPlayerEdit(pos.offset(side), side, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.getBlockState(pos);
        if (iblockstate.getBlock() == this.getBlock()) {
            BlockSlab.EnumBlockHalf enumblockhalf = (BlockSlab.EnumBlockHalf)iblockstate.getValue((IProperty)BlockSlab.HALF);
            if (side == EnumFacing.UP && enumblockhalf == BlockSlab.EnumBlockHalf.BOTTOM || side == EnumFacing.DOWN && enumblockhalf == BlockSlab.EnumBlockHalf.TOP) {
                IBlockState iblockstate1 = this.doubleSlab.getDefaultState();
                if (worldIn.checkNoEntityCollision(this.doubleSlab.getBoundingBox(iblockstate1, (IBlockAccess)worldIn, pos)) && worldIn.setBlockState(pos, iblockstate1, 3)) {
                    worldIn.playSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), this.doubleSlab.getSoundType().getPlaceSound(), SoundCategory.BLOCKS, (this.doubleSlab.getSoundType().getVolume() + 1.0f) / 2.0f, this.doubleSlab.getSoundType().getPitch() * 0.8f, true);
                    stack.shrink(1);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return this.func_180615_a(stack, worldIn, pos.offset(side)) || super.onItemUse(playerIn, worldIn, pos, hand, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canPlaceBlockOnSide(World worldIn, BlockPos p_179222_2_, EnumFacing p_179222_3_, EntityPlayer p_179222_4_, ItemStack p_179222_5_) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = p_179222_2_;
        IBlockState iblockstate = worldIn.getBlockState(p_179222_2_);
        if (iblockstate.getBlock() == this.getBlock()) {
            boolean flag;
            boolean bl = flag = iblockstate.getValue((IProperty)BlockSlab.HALF) == BlockSlab.EnumBlockHalf.TOP;
            if (p_179222_3_ == EnumFacing.UP && !flag || p_179222_3_ == EnumFacing.DOWN && flag) {
                return true;
            }
        }
        return (iblockstate1 = worldIn.getBlockState(p_179222_2_ = p_179222_2_.offset(p_179222_3_))).getBlock() == this.getBlock() || super.canPlaceBlockOnSide(worldIn, blockpos1, p_179222_3_, p_179222_4_, p_179222_5_);
    }

    private boolean func_180615_a(ItemStack p_180615_1_, World worldIn, BlockPos p_180615_3_) {
        IBlockState iblockstate = worldIn.getBlockState(p_180615_3_);
        if (iblockstate.getBlock() == this.getBlock()) {
            IBlockState iblockstate1 = this.doubleSlab.getDefaultState();
            if (worldIn.checkNoEntityCollision(this.doubleSlab.getBoundingBox(iblockstate1, (IBlockAccess)worldIn, p_180615_3_)) && worldIn.setBlockState(p_180615_3_, iblockstate1, 3)) {
                worldIn.playSound((double)((float)p_180615_3_.getX() + 0.5f), (double)((float)p_180615_3_.getY() + 0.5f), (double)((float)p_180615_3_.getZ() + 0.5f), this.doubleSlab.getSoundType().getPlaceSound(), SoundCategory.BLOCKS, (this.doubleSlab.getSoundType().getVolume() + 1.0f) / 2.0f, this.doubleSlab.getSoundType().getPitch() * 0.8f, true);
                p_180615_1_.shrink(1);
            }
            return true;
        }
        return false;
    }
}

