/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.api.filter.IFilterComparator;
import teamroots.embers.gui.ContainerEye;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEyeButton;
import teamroots.embers.util.Vec2i;

public class GuiEye
extends GuiContainer {
    private static final ResourceLocation guiLocation = new ResourceLocation("embers", "textures/gui/eye_gui.png");

    public GuiEye(EntityPlayer player) {
        super((Container)new ContainerEye(player));
        this.xSize = 176;
        this.ySize = 205;
    }

    private Vec2i getButton(float angle) {
        int xPos = (this.width - this.xSize) / 2;
        int yPos = (this.height - this.ySize) / 2;
        return ((ContainerEye)this.inventorySlots).getButtonPosition(xPos, yPos, angle);
    }

    private Vec2i getFinish() {
        return this.getButton(180.0f);
    }

    private Vec2i getLeft() {
        return this.getButton(140.0f);
    }

    private Vec2i getRight() {
        return this.getButton(-140.0f);
    }

    private Vec2i getInvert() {
        return this.getButton(-40.0f);
    }

    private Vec2i getFlag() {
        return this.getButton(40.0f);
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isOnButton(mouseX, mouseY, this.getFinish())) {
            this.triggerButton(ContainerEye.EnumButton.FINISH);
        } else if (this.isOnButton(mouseX, mouseY, this.getLeft())) {
            this.triggerButton(ContainerEye.EnumButton.LEFT);
        } else if (this.isOnButton(mouseX, mouseY, this.getRight())) {
            this.triggerButton(ContainerEye.EnumButton.RIGHT);
        } else if (this.isOnButton(mouseX, mouseY, this.getInvert())) {
            this.triggerButton(ContainerEye.EnumButton.INVERT);
        } else if (this.isOnButton(mouseX, mouseY, this.getFlag())) {
            this.triggerButton(ContainerEye.EnumButton.FLAG);
        } else {
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    private void triggerButton(ContainerEye.EnumButton button) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageEyeButton(button));
    }

    protected void renderHoveredToolTip(int mouseX, int mouseY) {
        Slot slot = this.getSlotUnderMouse();
        ContainerEye container = (ContainerEye)this.inventorySlots;
        int xPos = (this.width - this.xSize) / 2;
        int yPos = (this.height - this.ySize) / 2;
        if (this.isOnButton(mouseX, mouseY, this.getFinish())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Finish"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer);
        } else if (this.isOnButton(mouseX, mouseY, this.getLeft())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Previous"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer);
        } else if (this.isOnButton(mouseX, mouseY, this.getRight())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Next"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer);
        } else if (this.isOnButton(mouseX, mouseY, this.getInvert())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Invert"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer);
        } else if (this.isOnButton(mouseX, mouseY, this.getFlag())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Flag"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.fontRenderer);
        } else {
            super.renderHoveredToolTip(mouseX, mouseY);
        }
    }

    private boolean isOnButton(int mouseX, int mouseY, Vec2i button) {
        return mouseX >= button.x - 16 && mouseX < button.x + 16 && mouseY >= button.y - 16 && mouseY < button.y + 16;
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(guiLocation);
        int xPos = (this.width - this.xSize) / 2;
        int yPos = (this.height - this.ySize) / 2;
        int yInventory = yPos + this.ySize - 85;
        this.drawTexturedModalRect(xPos, yInventory, 0, 0, this.xSize, 85);
        int textWidth = 212;
        int textHeight = 33;
        int textX = xPos + (this.xSize - textWidth) / 2;
        int textY = yInventory - textHeight;
        this.drawTexturedModalRect(textX, textY, 0, 86, 212, 33);
        ContainerEye eye = (ContainerEye)this.inventorySlots;
        IFilterComparator comparator = eye.comparator;
        if (comparator != null) {
            ItemStack left = eye.filterInventory.getStackInSlot(0);
            ItemStack right = eye.filterInventory.getStackInSlot(1);
            GuiCodex.drawCenteredTextGlowing(this.fontRenderer, comparator.format(left, right, eye.flag, eye.inverted), textX + textWidth / 2, textY + textHeight / 2 - 4);
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(guiLocation);
        this.drawButton(xPos, yPos, 180.0f, false, 176, 32);
        this.drawButton(xPos, yPos, 140.0f, false, 176, 16);
        this.drawButton(xPos, yPos, -140.0f, false, 192, 16);
        this.drawButton(xPos, yPos, 90.0f, true, 0, 0);
        this.drawButton(xPos, yPos, -90.0f, true, 0, 0);
        this.drawButton(xPos, yPos, -40.0f, false, 208, 16);
        this.drawButton(xPos, yPos, 40.0f, false, 224, 16);
        int xCenter = xPos + 88;
        int yCenter = yPos + 85 - 50;
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)xCenter, (float)yCenter, (float)0.0f);
        GlStateManager.scale((float)2.0f, (float)2.0f, (float)0.0f);
        this.drawTexturedModalRect(-8, -8, 176, 0, 16, 16);
        GlStateManager.popMatrix();
    }

    private void drawButton(int xPos, int yPos, float angle, boolean itemSlot, int u, int v) {
        Vec2i button = ((ContainerEye)this.inventorySlots).getButtonPosition(xPos, yPos, angle);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)button.x, (float)button.y, (float)0.0f);
        GlStateManager.rotate((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        this.drawTexturedModalRect(-24, -24, 0, 119, 48, 48);
        GlStateManager.popMatrix();
        if (itemSlot) {
            this.drawTexturedModalRect(button.x - 24, button.y - 24, 48, 119, 48, 48);
        } else {
            this.drawTexturedModalRect(button.x - 8, button.y - 8, u, v, 16, 16);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }
}

