/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.gui;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.api.filter.EnumFilterSetting;
import teamroots.embers.api.filter.IFilterComparator;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Vec2i;

public class ContainerEye
extends Container {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 205;
    public static final int VAR_FLAG = 0;
    public static final int VAR_INVERTED = 1;
    public static final int VAR_FILTER_OFFSET = 2;
    EnumHand hand;
    ItemStack stack;
    IInventory filterInventory = new InventoryBasic("EyeFilter", true, 2);
    ItemStack stack1;
    ItemStack stack2;
    boolean inverted;
    EnumFilterSetting flag = EnumFilterSetting.STRICT;
    IFilterComparator comparator;
    int filterOffset;

    public ContainerEye(EntityPlayer player) {
        this.stack = player.getHeldItemMainhand();
        this.hand = EnumHand.MAIN_HAND;
        if (this.stack.isEmpty()) {
            this.stack = player.getHeldItemOffhand();
            this.hand = EnumHand.OFF_HAND;
        }
        this.readFromStack(this.stack);
        Vec2i leftItem = this.getButtonPosition(0, 0, 90.0f);
        Vec2i rightItem = this.getButtonPosition(0, 0, 270.0f);
        this.addSlotToContainer(new Slot(this.filterInventory, 0, leftItem.x - 8, leftItem.y - 8){

            public void onSlotChanged() {
                super.onSlotChanged();
                ContainerEye.this.filterOffset = 0;
                ContainerEye.this.refresh();
            }
        });
        this.addSlotToContainer(new Slot(this.filterInventory, 1, rightItem.x - 8, rightItem.y - 8){

            public void onSlotChanged() {
                super.onSlotChanged();
                ContainerEye.this.filterOffset = 0;
                ContainerEye.this.refresh();
            }
        });
        this.bindPlayerInventory(player.inventory);
    }

    private void readFromStack(ItemStack stack) {
        NBTTagCompound compound = stack.getTagCompound();
        if (compound != null) {
            String comparatorName = compound.getString("comparator");
            this.stack1 = new ItemStack(compound.getCompoundTag("stack1"));
            this.stack2 = new ItemStack(compound.getCompoundTag("stack2"));
            this.comparator = FilterUtil.getComparator(comparatorName);
            this.filterOffset = compound.getInteger("offset");
            this.inverted = compound.getBoolean("inverted");
            this.flag = EnumFilterSetting.get(compound.getInteger("setting"));
        }
    }

    public void triggerButton(EnumButton button) {
        switch (button) {
            case FINISH: {
                this.writeToStack();
                break;
            }
            case LEFT: {
                this.moveLeft();
                break;
            }
            case RIGHT: {
                this.moveRight();
                break;
            }
            case FLAG: {
                this.toggleFlag();
                break;
            }
            case INVERT: {
                this.toggleInvert();
            }
        }
    }

    public void writeToStack() {
        NBTTagCompound compound = this.stack.getTagCompound();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.setString("comparator", this.comparator.getName());
        compound.setInteger("offset", this.filterOffset);
        compound.setBoolean("inverted", this.inverted);
        compound.setInteger("setting", this.flag.ordinal());
        compound.setTag("stack1", (NBTBase)this.stack1.serializeNBT());
        compound.setTag("stack2", (NBTBase)this.stack2.serializeNBT());
        this.stack.setTagCompound(compound);
    }

    public void toggleInvert() {
        this.inverted = !this.inverted;
        this.detectAndSendChanges();
    }

    public void toggleFlag() {
        this.flag = this.flag.rotate(1);
        this.detectAndSendChanges();
    }

    public void moveLeft() {
        --this.filterOffset;
        this.refresh();
        this.detectAndSendChanges();
    }

    public void moveRight() {
        ++this.filterOffset;
        this.refresh();
        this.detectAndSendChanges();
    }

    private void refresh() {
        this.stack1 = this.filterInventory.getStackInSlot(0);
        this.stack2 = this.filterInventory.getStackInSlot(1);
        this.comparator = this.findComparator(this.stack1, this.stack2, this.filterOffset);
    }

    private IFilterComparator findComparator(ItemStack stack1, ItemStack stack2, int offset) {
        if (stack1.isEmpty() && stack2.isEmpty()) {
            return FilterUtil.ANY;
        }
        List<IFilterComparator> comparators = FilterUtil.getComparators(stack1, stack2);
        if (offset < 0) {
            offset = offset % comparators.size() + comparators.size();
        }
        return comparators.get(offset % comparators.size());
    }

    protected void broadcastData(IContainerListener crafting) {
        crafting.sendWindowProperty((Container)this, 0, this.flag.ordinal());
        crafting.sendWindowProperty((Container)this, 1, this.inverted ? 1 : 0);
        crafting.sendWindowProperty((Container)this, 2, this.filterOffset);
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        this.broadcastData(listener);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.listeners.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.listeners.get(i);
            this.broadcastData(icontainerlistener);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        switch (id) {
            case 2: {
                this.filterOffset = data;
                break;
            }
            case 1: {
                this.inverted = data > 0;
                break;
            }
            case 0: {
                this.flag = EnumFilterSetting.get(data);
                break;
            }
            default: {
                super.updateProgressBar(id, data);
            }
        }
        this.refresh();
    }

    public Vec2i getButtonPosition(int xPos, int yPos, float angle) {
        int xCenter = xPos + 88;
        int yCenter = yPos + 85 - 50;
        int xButton = xCenter + (int)(-Math.sin(Math.toRadians(angle)) * 106.0 / 2.0);
        int yButton = yCenter + (int)(-Math.cos(Math.toRadians(angle)) * 40.0);
        return new Vec2i(xButton, yButton);
    }

    public boolean canMergeSlot(ItemStack stack, Slot slotIn) {
        return false;
    }

    public ItemStack transferStackInSlot(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (index < 2 ? !this.mergeItemStack(itemstack1, 2, 38, true) : !this.mergeItemStack(itemstack1, 0, 2, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void onContainerClosed(EntityPlayer playerIn) {
        super.onContainerClosed(playerIn);
        World world = playerIn.getEntityWorld();
        if (!world.isRemote) {
            this.returnSlot(playerIn, world, this.getSlot(0));
            this.returnSlot(playerIn, world, this.getSlot(1));
        }
    }

    private void returnSlot(EntityPlayer playerIn, World worldIn, Slot slot) {
        if (!playerIn.isEntityAlive() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).hasDisconnected()) {
            playerIn.dropItem(slot.getStack(), false);
        } else {
            playerIn.inventory.placeItemBackInInventory(worldIn, slot.getStack());
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int yInventory = 120;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, yInventory + 4 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (inventoryPlayer.getStackInSlot(i) == this.stack) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, yInventory + 4 + 58){

                    public boolean canTakeStack(EntityPlayer playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, yInventory + 4 + 58));
        }
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.stack.isEmpty() && playerIn.getHeldItem(this.hand) == this.stack;
    }

    public static enum EnumButton {
        FINISH,
        LEFT,
        RIGHT,
        FLAG,
        INVERT;

    }
}

