/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.Embers;

public class BlockSlabBase
extends BlockSlab {
    private Block doubleSlab;
    public boolean isOpaqueCube = true;
    public boolean isFullCube = true;
    public BlockRenderLayer layer = BlockRenderLayer.SOLID;

    public BlockSlabBase(Block block, String name, boolean addToTab) {
        super(block.getDefaultState().getMaterial());
        this.setTranslationKey(name);
        this.setRegistryName("embers:" + name);
        this.doubleSlab = block;
        if (addToTab) {
            this.setCreativeTab(Embers.tab);
        }
        this.useNeighborBrightness = true;
    }

    public BlockSlabBase setIsOpaqueCube(boolean b) {
        this.isOpaqueCube = b;
        return this;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return this.isOpaqueCube;
    }

    public BlockSlabBase setIsFullCube(boolean b) {
        this.isFullCube = b;
        return this;
    }

    public boolean isFullCube(IBlockState state) {
        return this.isFullCube;
    }

    public BlockSlabBase setHarvestProperties(String toolType, int level) {
        super.setHarvestLevel(toolType, level);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isHalfSlab(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState iblockstate = this.getDefaultState();
        if (!this.isDouble()) {
            iblockstate = iblockstate.withProperty((IProperty)HALF, (Comparable)(meta == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int getMetaFromState(IBlockState state) {
        return state.getValue((IProperty)HALF) == BlockSlab.EnumBlockHalf.BOTTOM ? 0 : 1;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public boolean isDouble() {
        return false;
    }

    public String getTranslationKey(int meta) {
        return null;
    }

    public IProperty getVariantProperty() {
        return HALF;
    }

    public Comparable<?> getTypeForItem(ItemStack stack) {
        return 0;
    }
}

