/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import teamroots.embers.config.ConfigMaterial;
import teamroots.embers.config.ConfigWorld;
import teamroots.embers.register.BlockRegister;

public class WorldGenOres
implements IWorldGenerator {
    public static boolean isOreSpawnEnabled(int dimension) {
        return IntStream.of(ConfigWorld.ORE.blacklist).boxed().collect(Collectors.toList()).contains(dimension) == ConfigWorld.ORE.isWhitelist;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int y;
        int x;
        int i;
        if (!WorldGenOres.isOreSpawnEnabled(world.field_73011_w.getDimension()) || world.field_72995_K) {
            return;
        }
        if (ConfigMaterial.COPPER.mustLoad() && ConfigWorld.ORE.COPPER.generate) {
            WorldGenMinable ore_copper = new WorldGenMinable(BlockRegister.ORE_COPPER.func_176223_P(), ConfigWorld.ORE.COPPER.veinSize);
            for (i = 0; i < ConfigWorld.ORE.COPPER.veinPerChunk; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(ConfigWorld.ORE.COPPER.maxY - ConfigWorld.ORE.COPPER.minY) + ConfigWorld.ORE.COPPER.minY;
                z = chunkZ * 16 + random.nextInt(16);
                ore_copper.func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (ConfigMaterial.LEAD.mustLoad() && ConfigWorld.ORE.LEAD.generate) {
            WorldGenMinable ore_lead = new WorldGenMinable(BlockRegister.ORE_LEAD.func_176223_P(), ConfigWorld.ORE.LEAD.veinSize);
            for (i = 0; i < ConfigWorld.ORE.LEAD.veinPerChunk; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(ConfigWorld.ORE.LEAD.maxY - ConfigWorld.ORE.LEAD.minY) + ConfigWorld.ORE.LEAD.minY;
                z = chunkZ * 16 + random.nextInt(16);
                ore_lead.func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (ConfigMaterial.SILVER.mustLoad() && ConfigWorld.ORE.SILVER.generate) {
            WorldGenMinable ore_silver = new WorldGenMinable(BlockRegister.ORE_SILVER.func_176223_P(), ConfigWorld.ORE.SILVER.veinSize);
            for (i = 0; i < ConfigWorld.ORE.SILVER.veinPerChunk; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(ConfigWorld.ORE.SILVER.maxY - ConfigWorld.ORE.SILVER.minY) + ConfigWorld.ORE.SILVER.minY;
                z = chunkZ * 16 + random.nextInt(16);
                ore_silver.func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (ConfigWorld.ORE.QUARTZ.generate) {
            WorldGenMinable ore_quartz = new WorldGenMinable(BlockRegister.ORE_QUARTZ.func_176223_P(), ConfigWorld.ORE.QUARTZ.veinSize);
            for (i = 0; i < ConfigWorld.ORE.QUARTZ.veinPerChunk; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(ConfigWorld.ORE.QUARTZ.maxY - ConfigWorld.ORE.QUARTZ.minY) + ConfigWorld.ORE.QUARTZ.minY;
                z = chunkZ * 16 + random.nextInt(16);
                ore_quartz.func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (ConfigMaterial.ALUMINUM.mustLoad() && ConfigWorld.ORE.ALUMINUM.generate) {
            WorldGenMinable ore_aluminum = new WorldGenMinable(BlockRegister.ORE_ALUMINUM.func_176223_P(), ConfigWorld.ORE.ALUMINUM.veinSize);
            for (i = 0; i < ConfigWorld.ORE.ALUMINUM.veinPerChunk; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(ConfigWorld.ORE.ALUMINUM.maxY - ConfigWorld.ORE.ALUMINUM.minY) + ConfigWorld.ORE.ALUMINUM.minY;
                z = chunkZ * 16 + random.nextInt(16);
                ore_aluminum.func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (ConfigMaterial.NICKEL.mustLoad() && ConfigWorld.ORE.NICKEL.generate) {
            WorldGenMinable ore_nickel = new WorldGenMinable(BlockRegister.ORE_NICKEL.func_176223_P(), ConfigWorld.ORE.NICKEL.veinSize);
            for (i = 0; i < ConfigWorld.ORE.NICKEL.veinPerChunk; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(ConfigWorld.ORE.NICKEL.maxY - ConfigWorld.ORE.NICKEL.minY) + ConfigWorld.ORE.NICKEL.minY;
                z = chunkZ * 16 + random.nextInt(16);
                ore_nickel.func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (ConfigMaterial.TIN.mustLoad() && ConfigWorld.ORE.TIN.generate) {
            WorldGenMinable ore_tin = new WorldGenMinable(BlockRegister.ORE_TIN.func_176223_P(), ConfigWorld.ORE.TIN.veinSize);
            for (i = 0; i < ConfigWorld.ORE.TIN.veinPerChunk; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(ConfigWorld.ORE.TIN.maxY - ConfigWorld.ORE.TIN.minY) + ConfigWorld.ORE.TIN.minY;
                z = chunkZ * 16 + random.nextInt(16);
                ore_tin.func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
    }
}

